/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3749")
public class SpringComponentWithNonAutowiredMembersCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree clazzTree = (ClassTree)tree;
        SymbolMetadata clazzMeta = clazzTree.symbol().metadata();
        if (SpringComponentWithNonAutowiredMembersCheck.isSpringComponent(clazzMeta)) {
            clazzTree.members().stream().filter(v -> v.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(m -> (VariableTree)m).filter(v -> !v.symbol().isStatic()).filter(v -> !SpringComponentWithNonAutowiredMembersCheck.isSpringInjectionAnnotated(v.symbol().metadata())).forEach(v -> this.reportIssue((Tree)v.simpleName(), "Annotate this member with \"@Autowired\", \"@Resource\", or \"@Inject\", or remove it."));
        }
    }

    private static boolean isSpringInjectionAnnotated(SymbolMetadata metadata) {
        return metadata.isAnnotatedWith("org.springframework.beans.factory.annotation.Autowired") || metadata.isAnnotatedWith("javax.inject.Inject") || metadata.isAnnotatedWith("javax.annotation.Resource");
    }

    private static boolean isSpringComponent(SymbolMetadata clazzMeta) {
        return clazzMeta.isAnnotatedWith("org.springframework.stereotype.Controller") || clazzMeta.isAnnotatedWith("org.springframework.stereotype.Service") || clazzMeta.isAnnotatedWith("org.springframework.stereotype.Repository");
    }
}

