/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import java.util.HashSet;
import java.util.Set;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.java.filters.JavaIssueFilter;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AnyRuleIssueFilter
extends BaseTreeVisitor
implements JavaIssueFilter {
    private String componentKey;
    private final Set<Integer> excludedLines = new HashSet<Integer>();

    public void scanFile(JavaFileScannerContext context) {
        this.excludedLines.clear();
        this.scan((Tree)context.getTree());
    }

    @Override
    public void setComponentKey(String componentKey) {
        this.componentKey = componentKey;
    }

    @Override
    public boolean accept(FilterableIssue issue) {
        return !issue.componentKey().equals(this.componentKey) || !this.excludedLines.contains(issue.line());
    }

    @Override
    public final Set<Class<? extends JavaCheck>> filteredRules() {
        return ImmutableSet.of();
    }

    public void excludeLines(Tree tree) {
        this.excludedLines.addAll(AnyRuleIssueFilter.filteredLines(tree));
    }

    private static Set<Integer> filteredLines(Tree tree) {
        SyntaxToken firstSyntaxToken = tree.firstToken();
        SyntaxToken lastSyntaxToken = tree.lastToken();
        if (firstSyntaxToken != null && lastSyntaxToken != null) {
            return ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(firstSyntaxToken.line()), (Comparable)Integer.valueOf(lastSyntaxToken.line())), (DiscreteDomain)DiscreteDomain.integers());
        }
        return new HashSet<Integer>();
    }
}

