/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class AccessorsUtils {
    private AccessorsUtils() {
    }

    public static boolean isAccessor(ClassTree classTree, MethodTree methodTree) {
        return AccessorsUtils.isPublicMethod(methodTree) && methodTree.block() != null && (AccessorsUtils.isGetter(classTree, methodTree) || AccessorsUtils.isSetter(classTree, methodTree));
    }

    private static boolean isPublicMethod(MethodTree methodTree) {
        return methodTree.is(Tree.Kind.METHOD) && ModifiersUtils.hasModifier(methodTree.modifiers(), Modifier.PUBLIC);
    }

    private static boolean isSetter(ClassTree classTree, MethodTree methodTree) {
        return methodTree.simpleName().name().startsWith("set") && methodTree.parameters().size() == 1 && AccessorsUtils.returnTypeIs(methodTree, "void") && AccessorsUtils.hasOneAssignementStatement(methodTree, classTree);
    }

    private static boolean hasOneAssignementStatement(MethodTree methodTree, ClassTree classTree) {
        List<StatementTree> body = methodTree.block().body();
        return body.size() == 1 && body.get(0).is(Tree.Kind.EXPRESSION_STATEMENT) && ((ExpressionStatementTree)body.get(0)).expression().is(Tree.Kind.ASSIGNMENT) && AccessorsUtils.referencePrivateProperty((AssignmentExpressionTree)((ExpressionStatementTree)body.get(0)).expression(), classTree);
    }

    private static boolean referencePrivateProperty(AssignmentExpressionTree assignmentExpressionTree, ClassTree classTree) {
        return AccessorsUtils.referencePrivateProperty(assignmentExpressionTree.variable(), classTree);
    }

    private static boolean isGetter(ClassTree classTree, MethodTree methodTree) {
        return methodTree.parameters().isEmpty() && AccessorsUtils.hasOneReturnStatement(methodTree, classTree) && (AccessorsUtils.isValidGetter(methodTree) || AccessorsUtils.isBooleanGetter(methodTree));
    }

    private static boolean isBooleanGetter(MethodTree methodTree) {
        return methodTree.simpleName().name().startsWith("is") && AccessorsUtils.returnTypeIs(methodTree, "boolean");
    }

    private static boolean isValidGetter(MethodTree methodTree) {
        return methodTree.simpleName().name().startsWith("get");
    }

    private static boolean hasOneReturnStatement(MethodTree methodTree, ClassTree classTree) {
        List<StatementTree> body = methodTree.block().body();
        return body.size() == 1 && body.get(0).is(Tree.Kind.RETURN_STATEMENT) && AccessorsUtils.referencePrivateProperty((ReturnStatementTree)body.get(0), classTree);
    }

    private static boolean referencePrivateProperty(ReturnStatementTree returnStatementTree, ClassTree classTree) {
        ExpressionTree expression = returnStatementTree.expression();
        String variableName = "";
        if (expression == null) {
            return false;
        }
        if (expression.is(Tree.Kind.IDENTIFIER)) {
            variableName = ((IdentifierTree)expression).name();
        }
        return !StringUtils.isEmpty((String)variableName) && AccessorsUtils.referencePrivateProperty(variableName, classTree);
    }

    private static boolean referencePrivateProperty(ExpressionTree expression, ClassTree classTree) {
        String variableReturned = "";
        if (expression.is(Tree.Kind.IDENTIFIER)) {
            variableReturned = ((IdentifierTree)expression).name();
        } else if (expression.is(Tree.Kind.MEMBER_SELECT)) {
            variableReturned = ((MemberSelectExpressionTree)expression).identifier().name();
        }
        return !StringUtils.isEmpty((String)variableReturned) && AccessorsUtils.referencePrivateProperty(variableReturned, classTree);
    }

    private static boolean referencePrivateProperty(String variableName, ClassTree classTree) {
        for (Tree member : classTree.members()) {
            VariableTree variableTree;
            if (!member.is(Tree.Kind.VARIABLE) || !ModifiersUtils.hasModifier((variableTree = (VariableTree)member).modifiers(), Modifier.PRIVATE) || !variableTree.simpleName().name().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    private static boolean returnTypeIs(MethodTree methodTree, String expectedReturnType) {
        TypeTree returnType = methodTree.returnType();
        return returnType != null && returnType.is(Tree.Kind.PRIMITIVE_TYPE) && expectedReturnType.equals(((PrimitiveTypeTree)returnType).keyword().text());
    }
}

