/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.asm;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmClassProvider;
import org.sonar.java.bytecode.asm.AsmField;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.asm.AsmMethodVisitor;
import org.sonar.java.bytecode.asm.AsmSignature;

public class AsmClassVisitor
extends ClassVisitor {
    private final AsmClassProvider asmClassProvider;
    private final AsmClassProvider.DETAIL_LEVEL level;
    private final AsmClass asmClass;

    public AsmClassVisitor(AsmClassProvider asmClassProvider, AsmClass asmClass, AsmClassProvider.DETAIL_LEVEL level) {
        super(327680);
        this.asmClassProvider = asmClassProvider;
        this.level = level;
        this.asmClass = asmClass;
    }

    public void visit(int version, int accessFlags, String internalName, String signature, String superClass, String[] interfaces) {
        if (this.asmClass.getDetailLevel() == AsmClassProvider.DETAIL_LEVEL.NOTHING) {
            this.asmClass.setAccessFlags(accessFlags);
            if (this.asmClass.isInterface()) {
                if (interfaces.length == 1) {
                    this.asmClass.setSuperClass(this.asmClassProvider.getClass(interfaces[0], AsmClassProvider.DETAIL_LEVEL.STRUCTURE));
                }
            } else {
                if (superClass != null) {
                    this.asmClass.setSuperClass(this.asmClassProvider.getClass(superClass, AsmClassProvider.DETAIL_LEVEL.STRUCTURE));
                }
                for (String interfaceName : interfaces) {
                    this.asmClass.addInterface(this.asmClassProvider.getClass(interfaceName, AsmClassProvider.DETAIL_LEVEL.STRUCTURE));
                }
            }
            if (signature != null) {
                String[] internalNames = AsmSignature.extractInternalNames(signature);
                AsmClass[] asmClasses = this.internalNamesToAsmClasses(internalNames, AsmClassProvider.DETAIL_LEVEL.NOTHING);
                this.asmClass.addUsesOfClasses(asmClasses);
            }
        }
        this.asmClass.setDetailLevel(this.level);
    }

    public FieldVisitor visitField(int access, String fieldName, String description, String signature, Object value) {
        AsmField field = this.asmClass.getFieldOrCreateIt(fieldName);
        field.setAccessFlags(access);
        String[] internalNames = AsmSignature.extractInternalNames(description, signature);
        AsmClass[] asmClasses = this.internalNamesToAsmClasses(internalNames, AsmClassProvider.DETAIL_LEVEL.NOTHING);
        field.addUsesOfClasses(asmClasses);
        return null;
    }

    public MethodVisitor visitMethod(int access, String methodName, String description, String signature, String[] exceptions) {
        AsmMethod method = this.asmClass.getMethodOrCreateIt(methodName + description);
        if (AsmClassVisitor.isInheritedMethodSignature(method.getParent(), method.getKey())) {
            method.setInherited(true);
        }
        method.setSignature(signature);
        method.setBodyLoaded(true);
        method.setAccessFlags(access);
        method.clearOutogingEdges();
        String[] internalNames = AsmSignature.extractInternalNames(description, signature);
        AsmClass[] asmClasses = this.internalNamesToAsmClasses(internalNames, AsmClassProvider.DETAIL_LEVEL.NOTHING);
        method.addUsesOfClasses(asmClasses);
        AsmClass[] asmExceptionClasses = this.internalNamesToAsmClasses(exceptions, AsmClassProvider.DETAIL_LEVEL.STRUCTURE);
        method.addUsesOfClasses(asmExceptionClasses);
        method.addThrowsOfClasses(asmExceptionClasses);
        if (this.level == AsmClassProvider.DETAIL_LEVEL.STRUCTURE_AND_CALLS) {
            return new AsmMethodVisitor(method, this.asmClassProvider);
        }
        return null;
    }

    private AsmClass[] internalNamesToAsmClasses(String[] internalNames, AsmClassProvider.DETAIL_LEVEL level) {
        if (internalNames == null) {
            return new AsmClass[0];
        }
        AsmClass[] asmClasses = new AsmClass[internalNames.length];
        for (int i = 0; i < internalNames.length; ++i) {
            asmClasses[i] = this.asmClassProvider.getClass(internalNames[i], level);
        }
        return asmClasses;
    }

    private static boolean isInheritedMethodSignature(AsmClass parent, String key) {
        if (parent.getSuperClass() != null && (parent.getSuperClass().getMethod(key) != null || AsmClassVisitor.isInheritedMethodSignature(parent.getSuperClass(), key))) {
            return true;
        }
        for (AsmClass interfaceClass : parent.getInterfaces()) {
            if (interfaceClass.getMethod(key) == null && !AsmClassVisitor.isInheritedMethodSignature(interfaceClass, key)) continue;
            return true;
        }
        return false;
    }
}

