/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.visitor;

import javax.annotation.Nullable;
import org.sonar.api.design.Dependency;
import org.sonar.api.resources.Resource;
import org.sonar.graph.DirectedGraph;
import org.sonar.graph.Edge;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.visitor.BytecodeContext;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.java.bytecode.visitor.ResourceMapping;

public class DependenciesVisitor
extends BytecodeVisitor {
    @Nullable
    private Resource fromResource;
    private final DirectedGraph<Resource, Dependency> graph;

    public DependenciesVisitor(BytecodeContext bytecodeContext, DirectedGraph<Resource, Dependency> graph) {
        this.setContext(bytecodeContext);
        this.graph = graph;
    }

    @Override
    public void visitClass(AsmClass asmClass) {
        this.fromResource = this.getResource(asmClass);
    }

    @Override
    public void visitEdge(AsmEdge edge) {
        AsmClass toAsmClass = edge.getTargetAsmClass();
        Resource toResource = this.getResource(toAsmClass);
        Dependency fileEdge = this.createDependency(this.fromResource, toResource, null);
        if (this.fromResource != null && toResource != null) {
            this.createDependency(this.fromResource.getParent(), toResource.getParent(), fileEdge);
        }
    }

    private Dependency createDependency(@Nullable Resource from, @Nullable Resource to, @Nullable Dependency subDependency) {
        Dependency dependency = null;
        if (DependenciesVisitor.canWeLinkNodes(from, to)) {
            dependency = (Dependency)this.graph.getEdge((Object)from, (Object)to);
            if (dependency == null) {
                dependency = new Dependency(from, to).setUsage("USES");
                dependency.setWeight(1);
                this.graph.addEdge((Edge)dependency);
            }
            ResourceMapping resourceMapping = this.getContext().getJavaResourceLocator().getResourceMapping();
            if (subDependency != null && !resourceMapping.getSubDependencies(dependency).contains(subDependency)) {
                resourceMapping.addSubDependency(dependency, subDependency);
                dependency.setWeight(dependency.getWeight() + 1);
                subDependency.setParent(dependency);
            }
        }
        return dependency;
    }

    private static boolean canWeLinkNodes(@Nullable Resource from, @Nullable Resource to) {
        return from != null && to != null && !from.equals((Object)to);
    }

    private Resource getResource(AsmClass asmClass) {
        return this.getContext().getJavaResourceLocator().findResourceByClassName(asmClass.getInternalName());
    }
}

