/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.ast.parser.TypeUnionListTreeImpl;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.declaration.AnnotationTreeImpl;
import org.sonar.java.model.expression.TypeArgumentListTreeImpl;
import org.sonar.java.syntaxtoken.FirstSyntaxTokenFinder;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportClauseTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeArguments;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.WildcardTree;
import org.sonar.sslr.grammar.GrammarRuleKey;

public abstract class JavaTree
implements Tree {
    @Nullable
    private Tree parent;
    protected GrammarRuleKey grammarRuleKey;

    public JavaTree(GrammarRuleKey grammarRuleKey) {
        this.grammarRuleKey = grammarRuleKey;
    }

    public int getLine() {
        SyntaxToken firstSyntaxToken = FirstSyntaxTokenFinder.firstSyntaxToken(this);
        if (firstSyntaxToken == null) {
            return -1;
        }
        return firstSyntaxToken.line();
    }

    @Override
    public final boolean is(Tree.Kind ... kind) {
        Tree.Kind treeKind = this.kind();
        for (Tree.Kind kindIter : kind) {
            if (treeKind != kindIter) continue;
            return true;
        }
        return false;
    }

    @Override
    public Tree parent() {
        return this.parent;
    }

    public void setParent(Tree parent) {
        this.parent = parent;
    }

    public abstract Iterator<Tree> childrenIterator();

    public boolean isLeaf() {
        return false;
    }

    public GrammarRuleKey getGrammarRuleKey() {
        return this.grammarRuleKey;
    }

    public static class ArrayTypeTreeImpl
    extends AbstractTypedTree
    implements ArrayTypeTree {
        private TypeTree type;
        private List<AnnotationTree> annotations;
        private final InternalSyntaxToken openBracketToken;
        private final InternalSyntaxToken closeBracketToken;
        private final InternalSyntaxToken ellipsisToken;

        public ArrayTypeTreeImpl(@Nullable TypeTree type, List<AnnotationTreeImpl> annotations, InternalSyntaxToken openBracketToken, InternalSyntaxToken closeBracketToken) {
            super(Tree.Kind.ARRAY_TYPE);
            this.type = type;
            this.annotations = ArrayTypeTreeImpl.getAnnotations(annotations);
            this.openBracketToken = openBracketToken;
            this.closeBracketToken = closeBracketToken;
            this.ellipsisToken = null;
        }

        public ArrayTypeTreeImpl(@Nullable TypeTree type, List<AnnotationTreeImpl> annotations, InternalSyntaxToken ellispsisToken) {
            super(Tree.Kind.ARRAY_TYPE);
            this.type = type;
            this.annotations = ArrayTypeTreeImpl.getAnnotations(annotations);
            this.openBracketToken = null;
            this.closeBracketToken = null;
            this.ellipsisToken = ellispsisToken;
        }

        public void completeType(TypeTree type) {
            this.type = type;
        }

        public void setLastChildType(TypeTree type) {
            ArrayTypeTree childType = this;
            while (childType.type() != null && childType.is(Tree.Kind.ARRAY_TYPE)) {
                childType = (ArrayTypeTree)childType.type();
            }
            childType.completeType(type);
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.ARRAY_TYPE;
        }

        @Override
        public TypeTree type() {
            return this.type;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitArrayType(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            boolean hasBrackets = this.ellipsisToken == null;
            return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.type), this.annotations.iterator(), (Iterator)(hasBrackets ? Iterators.forArray((Object[])new InternalSyntaxToken[]{this.openBracketToken, this.closeBracketToken}) : Iterators.singletonIterator((Object)this.ellipsisToken)));
        }

        @Override
        public List<AnnotationTree> annotations() {
            return this.annotations;
        }

        @Override
        public SyntaxToken openBracketToken() {
            return this.openBracketToken;
        }

        @Override
        public SyntaxToken closeBracketToken() {
            return this.closeBracketToken;
        }

        @Override
        public SyntaxToken ellipsisToken() {
            return this.ellipsisToken;
        }

        private static ImmutableList<AnnotationTree> getAnnotations(List<AnnotationTreeImpl> annotations) {
            ImmutableList.Builder annotationBuilder = ImmutableList.builder();
            for (AnnotationTreeImpl annotation : annotations) {
                annotationBuilder.add((Object)annotation);
            }
            return annotationBuilder.build();
        }

        public void complete(List<AnnotationTree> typeAnnotations) {
            this.annotations = typeAnnotations;
        }
    }

    public static class ParameterizedTypeTreeImpl
    extends AbstractTypedTree
    implements ParameterizedTypeTree,
    ExpressionTree {
        private final TypeTree type;
        private final TypeArguments typeArguments;
        private List<AnnotationTree> annotations;

        public ParameterizedTypeTreeImpl(TypeTree type, TypeArgumentListTreeImpl typeArguments) {
            super(Tree.Kind.PARAMETERIZED_TYPE);
            this.type = (TypeTree)Preconditions.checkNotNull((Object)type);
            this.typeArguments = (TypeArguments)Preconditions.checkNotNull((Object)typeArguments);
            this.annotations = ImmutableList.of();
        }

        public ParameterizedTypeTreeImpl complete(List<AnnotationTree> annotations) {
            this.annotations = annotations;
            return this;
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.PARAMETERIZED_TYPE;
        }

        @Override
        public TypeTree type() {
            return this.type;
        }

        @Override
        public TypeArguments typeArguments() {
            return this.typeArguments;
        }

        @Override
        public List<AnnotationTree> annotations() {
            return this.annotations;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitParameterizedType(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return Iterators.concat(this.annotations.iterator(), (Iterator)Iterators.forArray((Object[])new Tree[]{this.type, this.typeArguments}));
        }
    }

    public static class PrimitiveTypeTreeImpl
    extends AbstractTypedTree
    implements PrimitiveTypeTree {
        private final InternalSyntaxToken token;
        private List<AnnotationTree> annotations;

        public PrimitiveTypeTreeImpl(InternalSyntaxToken token) {
            super(Tree.Kind.PRIMITIVE_TYPE);
            this.token = token;
            this.annotations = ImmutableList.of();
        }

        public PrimitiveTypeTreeImpl complete(List<AnnotationTree> annotations) {
            this.annotations = annotations;
            return this;
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.PRIMITIVE_TYPE;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitPrimitiveType(this);
        }

        @Override
        public SyntaxToken keyword() {
            return this.token;
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return Iterators.concat(this.annotations.iterator(), (Iterator)Iterators.singletonIterator((Object)this.token));
        }

        @Override
        public List<AnnotationTree> annotations() {
            return this.annotations;
        }
    }

    public static class NotImplementedTreeImpl
    extends AbstractTypedTree
    implements ExpressionTree {
        public NotImplementedTreeImpl() {
            super(Tree.Kind.OTHER);
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.OTHER;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitOther(this);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            throw new UnsupportedOperationException();
        }
    }

    public static class UnionTypeTreeImpl
    extends AbstractTypedTree
    implements UnionTypeTree {
        private final ListTree<TypeTree> typeAlternatives;

        public UnionTypeTreeImpl(TypeUnionListTreeImpl typeAlternatives) {
            super(Tree.Kind.UNION_TYPE);
            this.typeAlternatives = (ListTree)Preconditions.checkNotNull((Object)typeAlternatives);
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.UNION_TYPE;
        }

        @Override
        public ListTree<TypeTree> typeAlternatives() {
            return this.typeAlternatives;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitUnionType(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return ImmutableList.builder().add(this.typeAlternatives).build().iterator();
        }

        @Override
        public List<AnnotationTree> annotations() {
            return ImmutableList.of();
        }
    }

    public static class WildcardTreeImpl
    extends JavaTree
    implements WildcardTree {
        private SyntaxToken queryToken;
        @Nullable
        private final SyntaxToken extendsOrSuperToken;
        private final Tree.Kind kind;
        @Nullable
        private final TypeTree bound;
        private List<AnnotationTree> annotations;

        public WildcardTreeImpl(InternalSyntaxToken queryToken) {
            super(Tree.Kind.UNBOUNDED_WILDCARD);
            this.kind = Tree.Kind.UNBOUNDED_WILDCARD;
            this.annotations = Collections.emptyList();
            this.queryToken = queryToken;
            this.extendsOrSuperToken = null;
            this.bound = null;
        }

        public WildcardTreeImpl(Tree.Kind kind, InternalSyntaxToken extendsOrSuperToken, TypeTree bound) {
            super(kind);
            Preconditions.checkState((kind == Tree.Kind.EXTENDS_WILDCARD || kind == Tree.Kind.SUPER_WILDCARD ? 1 : 0) != 0);
            this.kind = kind;
            this.annotations = Collections.emptyList();
            this.extendsOrSuperToken = extendsOrSuperToken;
            this.bound = bound;
        }

        public WildcardTreeImpl complete(InternalSyntaxToken queryToken) {
            Preconditions.checkState((this.kind == Tree.Kind.EXTENDS_WILDCARD || this.kind == Tree.Kind.SUPER_WILDCARD ? 1 : 0) != 0);
            this.queryToken = queryToken;
            return this;
        }

        public WildcardTreeImpl complete(List<AnnotationTree> annotations) {
            this.annotations = annotations;
            return this;
        }

        @Override
        public Tree.Kind kind() {
            return this.kind;
        }

        @Override
        public List<AnnotationTree> annotations() {
            return this.annotations;
        }

        @Override
        public SyntaxToken queryToken() {
            return this.queryToken;
        }

        @Override
        @Nullable
        public SyntaxToken extendsOrSuperToken() {
            return this.extendsOrSuperToken;
        }

        @Override
        @Nullable
        public TypeTree bound() {
            return this.bound;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitWildcard(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            ImmutableList.Builder iteratorBuilder = ImmutableList.builder();
            iteratorBuilder.addAll(this.annotations);
            iteratorBuilder.add((Object)this.queryToken);
            if (this.bound != null) {
                iteratorBuilder.add((Object)this.extendsOrSuperToken);
                iteratorBuilder.add((Object)this.bound);
            }
            return iteratorBuilder.build().iterator();
        }
    }

    public static class ImportTreeImpl
    extends JavaTree
    implements ImportTree {
        private final boolean isStatic;
        private final Tree qualifiedIdentifier;
        private final SyntaxToken semicolonToken;
        private final SyntaxToken importToken;
        private final SyntaxToken staticToken;

        public ImportTreeImpl(InternalSyntaxToken importToken, @Nullable InternalSyntaxToken staticToken, Tree qualifiedIdentifier, InternalSyntaxToken semiColonToken) {
            super(Tree.Kind.IMPORT);
            this.importToken = importToken;
            this.staticToken = staticToken;
            this.qualifiedIdentifier = qualifiedIdentifier;
            this.semicolonToken = semiColonToken;
            this.isStatic = staticToken != null;
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.IMPORT;
        }

        @Override
        public boolean isStatic() {
            return this.isStatic;
        }

        @Override
        public SyntaxToken importKeyword() {
            return this.importToken;
        }

        @Override
        @Nullable
        public SyntaxToken staticKeyword() {
            return this.staticToken;
        }

        @Override
        public Tree qualifiedIdentifier() {
            return this.qualifiedIdentifier;
        }

        @Override
        public SyntaxToken semicolonToken() {
            return this.semicolonToken;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitImport(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.importToken), (Iterator)(this.isStatic ? Iterators.singletonIterator((Object)this.staticToken) : Iterators.emptyIterator()), (Iterator)Iterators.forArray((Object[])new Tree[]{this.qualifiedIdentifier, this.semicolonToken}));
        }
    }

    public static class PackageDeclarationTreeImpl
    extends JavaTree
    implements PackageDeclarationTree {
        private final List<AnnotationTree> annotations;
        private final SyntaxToken packageKeyword;
        private final ExpressionTree packageName;
        private final SyntaxToken semicolonToken;

        public PackageDeclarationTreeImpl(List<AnnotationTree> annotations, SyntaxToken packageKeyword, ExpressionTree packageName, SyntaxToken semicolonToken) {
            super(Tree.Kind.PACKAGE);
            this.annotations = (List)Preconditions.checkNotNull(annotations);
            this.packageKeyword = packageKeyword;
            this.packageName = packageName;
            this.semicolonToken = semicolonToken;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitPackage(this);
        }

        @Override
        public List<AnnotationTree> annotations() {
            return this.annotations;
        }

        @Override
        public SyntaxToken packageKeyword() {
            return this.packageKeyword;
        }

        @Override
        public ExpressionTree packageName() {
            return this.packageName;
        }

        @Override
        public SyntaxToken semicolonToken() {
            return this.semicolonToken;
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.PACKAGE;
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return Iterators.concat(this.annotations.iterator(), (Iterator)Iterators.forArray((Object[])new Tree[]{this.packageKeyword, this.packageName, this.semicolonToken}));
        }

        public static String packageNameAsString(@Nullable PackageDeclarationTree tree) {
            if (tree == null) {
                return "";
            }
            LinkedList<String> pieces = new LinkedList<String>();
            ExpressionTree expr = tree.packageName();
            while (expr.is(Tree.Kind.MEMBER_SELECT)) {
                MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
                pieces.push(mse.identifier().name());
                pieces.push(mse.operatorToken().text());
                expr = mse.expression();
            }
            if (expr.is(Tree.Kind.IDENTIFIER)) {
                IdentifierTree idt = (IdentifierTree)expr;
                pieces.push(idt.name());
            }
            StringBuilder sb = new StringBuilder();
            for (String piece : pieces) {
                sb.append(piece);
            }
            return sb.toString();
        }
    }

    public static class CompilationUnitTreeImpl
    extends JavaTree
    implements CompilationUnitTree {
        private final PackageDeclarationTree packageDeclaration;
        private final List<ImportClauseTree> imports;
        private final List<Tree> types;
        private final SyntaxToken eofToken;

        public CompilationUnitTreeImpl(@Nullable PackageDeclarationTree packageDeclaration, List<ImportClauseTree> imports, List<Tree> types, SyntaxToken eofToken) {
            super(Tree.Kind.COMPILATION_UNIT);
            this.packageDeclaration = packageDeclaration;
            this.imports = imports;
            this.types = types;
            this.eofToken = eofToken;
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.COMPILATION_UNIT;
        }

        @Override
        public List<ImportClauseTree> imports() {
            return this.imports;
        }

        @Override
        public List<Tree> types() {
            return this.types;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitCompilationUnit(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            UnmodifiableIterator packageIterator = this.packageDeclaration == null ? Iterators.emptyIterator() : Iterators.singletonIterator((Object)this.packageDeclaration);
            return Iterators.concat((Iterator)packageIterator, this.imports.iterator(), this.types.iterator(), (Iterator)Iterators.singletonIterator((Object)this.eofToken));
        }

        @Override
        @Nullable
        public PackageDeclarationTree packageDeclaration() {
            return this.packageDeclaration;
        }

        @Override
        public SyntaxToken eofToken() {
            return this.eofToken;
        }
    }
}

