/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ThrowStatementTreeImpl
extends JavaTree
implements ThrowStatementTree {
    private final InternalSyntaxToken throwKeyword;
    private final ExpressionTree expression;
    private final InternalSyntaxToken semicolonToken;

    public ThrowStatementTreeImpl(InternalSyntaxToken throwKeyword, ExpressionTree expression, InternalSyntaxToken semicolonToken) {
        super(Tree.Kind.THROW_STATEMENT);
        this.throwKeyword = throwKeyword;
        this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        this.semicolonToken = semicolonToken;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.THROW_STATEMENT;
    }

    @Override
    public SyntaxToken throwKeyword() {
        return this.throwKeyword;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken semicolonToken() {
        return this.semicolonToken;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitThrowStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.throwKeyword, this.expression, this.semicolonToken});
    }
}

