/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.ast.parser.ResourceListTreeImpl;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.statement.BlockTreeImpl;
import org.sonar.java.model.statement.CatchTreeImpl;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class TryStatementTreeImpl
extends JavaTree
implements TryStatementTree {
    private InternalSyntaxToken tryToken;
    @Nullable
    private InternalSyntaxToken openParenToken;
    private ListTree<VariableTree> resources;
    @Nullable
    private InternalSyntaxToken closeParenToken;
    private BlockTree block;
    private List<CatchTree> catches;
    @Nullable
    private final InternalSyntaxToken finallyKeyword;
    @Nullable
    private final BlockTreeImpl finallyBlock;

    public TryStatementTreeImpl(List<CatchTreeImpl> catches, @Nullable InternalSyntaxToken finallyKeyword, @Nullable BlockTreeImpl finallyBlock) {
        super(Tree.Kind.TRY_STATEMENT);
        this.openParenToken = null;
        this.resources = ResourceListTreeImpl.emptyList();
        this.closeParenToken = null;
        this.catches = TryStatementTreeImpl.getCatches(catches);
        this.finallyKeyword = finallyKeyword;
        this.finallyBlock = finallyBlock;
    }

    public TryStatementTreeImpl(InternalSyntaxToken finallyKeyword, BlockTreeImpl finallyBlock) {
        this((List<CatchTreeImpl>)ImmutableList.of(), finallyKeyword, finallyBlock);
    }

    public TryStatementTreeImpl(InternalSyntaxToken tryToken, InternalSyntaxToken openParenToken, ResourceListTreeImpl resources, InternalSyntaxToken closeParenToken, BlockTreeImpl block, List<CatchTreeImpl> catches) {
        super(Tree.Kind.TRY_STATEMENT);
        this.tryToken = tryToken;
        this.openParenToken = openParenToken;
        this.resources = resources;
        this.closeParenToken = closeParenToken;
        this.block = block;
        this.catches = TryStatementTreeImpl.getCatches(catches);
        this.finallyKeyword = null;
        this.finallyBlock = null;
    }

    public TryStatementTreeImpl completeWithCatches(List<CatchTreeImpl> catches) {
        this.catches = TryStatementTreeImpl.getCatches(catches);
        return this;
    }

    public TryStatementTreeImpl completeStandardTry(InternalSyntaxToken tryToken, BlockTreeImpl block) {
        this.tryToken = tryToken;
        this.block = block;
        return this;
    }

    public TryStatementTreeImpl completeTryWithResources(InternalSyntaxToken tryToken, InternalSyntaxToken openParenToken, ResourceListTreeImpl resources, InternalSyntaxToken closeParenToken, BlockTreeImpl block, List<CatchTreeImpl> catches) {
        this.tryToken = tryToken;
        this.openParenToken = openParenToken;
        this.resources = resources;
        this.closeParenToken = closeParenToken;
        this.block = block;
        this.catches = TryStatementTreeImpl.getCatches(catches);
        return this;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.TRY_STATEMENT;
    }

    @Override
    public SyntaxToken tryKeyword() {
        return this.tryToken;
    }

    @Override
    @Nullable
    public SyntaxToken openParenToken() {
        return this.openParenToken;
    }

    @Override
    public ListTree<VariableTree> resources() {
        return this.resources;
    }

    @Override
    @Nullable
    public SyntaxToken closeParenToken() {
        return this.closeParenToken;
    }

    @Override
    public BlockTree block() {
        return this.block;
    }

    @Override
    public List<CatchTree> catches() {
        return this.catches;
    }

    @Override
    @Nullable
    public SyntaxToken finallyKeyword() {
        if (this.finallyBlock == null) {
            return null;
        }
        return this.finallyKeyword;
    }

    @Override
    @Nullable
    public BlockTree finallyBlock() {
        return this.finallyBlock;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTryStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        ImmutableList.Builder iteratorBuilder = ImmutableList.builder();
        iteratorBuilder.add((Object)this.tryToken);
        if (this.openParenToken != null) {
            iteratorBuilder.add((Object)this.openParenToken);
            iteratorBuilder.add(this.resources);
            iteratorBuilder.add((Object)this.closeParenToken);
        }
        iteratorBuilder.add((Object)this.block);
        iteratorBuilder.addAll(this.catches);
        if (this.finallyKeyword != null) {
            iteratorBuilder.add((Object[])new Tree[]{this.finallyKeyword, this.finallyBlock});
        }
        return iteratorBuilder.build().iterator();
    }

    private static List<CatchTree> getCatches(List<CatchTreeImpl> catches) {
        return TryStatementTreeImpl.getList(catches);
    }

    private static <T> List<T> getList(List<? extends T> list) {
        return ImmutableList.builder().addAll(list).build();
    }
}

