/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

public class Convert {
    private Convert() {
    }

    public static String packagePart(String fullName) {
        int lastDot = fullName.lastIndexOf(46);
        return lastDot < 0 ? "" : fullName.substring(0, lastDot);
    }

    public static String shortName(String fullName) {
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    public static String flatName(String bytecodeName) {
        return bytecodeName.replace('/', '.');
    }

    public static String bytecodeName(String fullName) {
        return fullName.replace('.', '/');
    }

    public static String enclosingClassName(String shortName) {
        String normalizedShortName = Convert.normalizeShortName(shortName);
        int lastDollar = normalizedShortName.lastIndexOf(36);
        return lastDollar < 0 ? "" : normalizedShortName.substring(0, lastDollar);
    }

    public static String innerClassName(String enclosingClassName, String shortName) {
        Preconditions.checkArgument((!enclosingClassName.isEmpty() ? 1 : 0) != 0, (Object)("Enclosing class name should not be empty : " + shortName));
        int indexEnclosing = shortName.indexOf(enclosingClassName);
        Preconditions.checkState((indexEnclosing > -1 ? 1 : 0) != 0, (Object)("Error short name does not include outerclass name : " + shortName + " -- " + enclosingClassName));
        Preconditions.checkState((boolean)shortName.substring(indexEnclosing + enclosingClassName.length()).startsWith("$"));
        return shortName.substring(indexEnclosing + enclosingClassName.length() + 1);
    }

    private static String normalizeShortName(String shortName) {
        return StringUtils.removeEnd((String)StringUtils.removeEnd((String)shortName, (String)"$class"), (String)"$");
    }

    public static String fullName(String packagePart, String className) {
        String pck = StringUtils.defaultIfBlank((String)packagePart, (String)"");
        if (StringUtils.isNotEmpty((String)pck)) {
            pck = pck + ".";
        }
        return pck + className;
    }
}

