/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.java.model.expression.MethodInvocationTreeImpl;
import org.sonar.java.model.expression.NewClassTreeImpl;
import org.sonar.java.model.expression.TypeArgumentListTreeImpl;
import org.sonar.java.resolve.AnnotationInstanceResolve;
import org.sonar.java.resolve.AnnotationValueResolve;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.TypeSubstitution;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

public class TypeAndReferenceSolver
extends BaseTreeVisitor {
    private final Map<Tree.Kind, JavaType> typesOfLiterals = Maps.newEnumMap(Tree.Kind.class);
    private final SemanticModel semanticModel;
    private final Symbols symbols;
    private final Resolve resolve;
    private final ParametrizedTypeCache parametrizedTypeCache;
    private final Map<Tree, JavaType> types = Maps.newHashMap();
    Resolve.Env env;

    public TypeAndReferenceSolver(SemanticModel semanticModel, Symbols symbols, Resolve resolve, ParametrizedTypeCache parametrizedTypeCache) {
        this.semanticModel = semanticModel;
        this.symbols = symbols;
        this.resolve = resolve;
        this.parametrizedTypeCache = parametrizedTypeCache;
        this.typesOfLiterals.put(Tree.Kind.BOOLEAN_LITERAL, symbols.booleanType);
        this.typesOfLiterals.put(Tree.Kind.NULL_LITERAL, symbols.nullType);
        this.typesOfLiterals.put(Tree.Kind.CHAR_LITERAL, symbols.charType);
        this.typesOfLiterals.put(Tree.Kind.STRING_LITERAL, symbols.stringType);
        this.typesOfLiterals.put(Tree.Kind.FLOAT_LITERAL, symbols.floatType);
        this.typesOfLiterals.put(Tree.Kind.DOUBLE_LITERAL, symbols.doubleType);
        this.typesOfLiterals.put(Tree.Kind.LONG_LITERAL, symbols.longType);
        this.typesOfLiterals.put(Tree.Kind.INT_LITERAL, symbols.intType);
    }

    @Override
    public void visitMethod(MethodTree tree) {
        this.scan(tree.modifiers());
        TypeAndReferenceSolver.completeMetadata((JavaSymbol.MethodJavaSymbol)tree.symbol(), tree.modifiers().annotations());
        this.scan(tree.typeParameters());
        this.scan(tree.parameters());
        this.scan(tree.defaultValue());
        this.scan(tree.block());
    }

    @Override
    public void visitClass(ClassTree tree) {
        this.scan(tree.modifiers());
        TypeAndReferenceSolver.completeMetadata((JavaSymbol)((Object)tree.symbol()), tree.modifiers().annotations());
        this.scan(tree.typeParameters());
        this.scan(tree.members());
    }

    private static void completeMetadata(JavaSymbol symbol, List<AnnotationTree> annotations) {
        for (AnnotationTree tree : annotations) {
            AnnotationInstanceResolve annotationInstance = new AnnotationInstanceResolve((JavaSymbol.TypeJavaSymbol)tree.symbolType().symbol());
            symbol.metadata().addAnnotation(annotationInstance);
            Arguments arguments = tree.arguments();
            if (arguments.size() > 1 || !arguments.isEmpty() && ((ExpressionTree)arguments.get(0)).is(Tree.Kind.ASSIGNMENT)) {
                for (ExpressionTree expressionTree : arguments) {
                    AssignmentExpressionTree aet = (AssignmentExpressionTree)expressionTree;
                    annotationInstance.addValue(new AnnotationValueResolve(((IdentifierTree)aet.variable()).name(), aet.expression()));
                }
                continue;
            }
            TypeAndReferenceSolver.addConstantValue(tree, annotationInstance);
        }
    }

    private static void addConstantValue(AnnotationTree tree, AnnotationInstanceResolve annotationInstance) {
        Collection<Symbol> scopeSymbols = tree.annotationType().symbolType().symbol().memberSymbols();
        for (ExpressionTree expressionTree : tree.arguments()) {
            String name = "";
            for (Symbol scopeSymbol : scopeSymbols) {
                if (!scopeSymbol.isMethodSymbol()) continue;
                name = scopeSymbol.name();
                break;
            }
            annotationInstance.addValue(new AnnotationValueResolve(name, expressionTree));
        }
    }

    @Override
    public void visitImport(ImportTree tree) {
    }

    @Override
    public void visitLabeledStatement(LabeledStatementTree tree) {
        this.scan(tree.statement());
    }

    @Override
    public void visitBreakStatement(BreakStatementTree tree) {
    }

    @Override
    public void visitContinueStatement(ContinueStatementTree tree) {
    }

    @Override
    public void visitExpressionStatement(ExpressionStatementTree tree) {
        super.visitExpressionStatement(tree);
        this.registerType(tree, this.getType(tree.expression()));
    }

    @Override
    public void visitMethodInvocation(MethodInvocationTree tree) {
        ExpressionTree methodSelect = tree.methodSelect();
        Resolve.Env methodEnv = this.semanticModel.getEnv(tree);
        this.scan(tree.arguments());
        this.scan(tree.typeArguments());
        List<JavaType> argTypes = TypeAndReferenceSolver.getParameterTypes(tree.arguments());
        List<Object> typeParamTypes = Lists.newArrayList();
        if (tree.typeArguments() != null) {
            typeParamTypes = TypeAndReferenceSolver.getParameterTypes(tree.typeArguments());
        }
        Resolve.Resolution resolution = this.resolveMethodSymbol(methodSelect, methodEnv, argTypes, typeParamTypes);
        JavaSymbol symbol = resolution.symbol();
        ((MethodInvocationTreeImpl)tree).setSymbol(symbol);
        this.registerType(tree, resolution.type());
    }

    private static List<JavaType> getParameterTypes(List<? extends Tree> args) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Tree tree : args) {
            JavaType symbolType = Symbols.unknownType;
            if (((AbstractTypedTree)tree).isTypeSet()) {
                symbolType = (JavaType)((AbstractTypedTree)tree).symbolType();
            }
            builder.add((Object)symbolType);
        }
        return builder.build();
    }

    private Resolve.Resolution resolveMethodSymbol(Tree methodSelect, Resolve.Env methodEnv, List<JavaType> argTypes, List<JavaType> typeParamTypes) {
        Resolve.Resolution resolution;
        IdentifierTree identifier;
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree mset = (MemberSelectExpressionTree)methodSelect;
            this.resolveAs(mset.expression(), 6);
            JavaType type = this.getType(mset.expression());
            identifier = mset.identifier();
            resolution = this.resolve.findMethod(methodEnv, type, identifier.name(), argTypes, typeParamTypes);
        } else if (methodSelect.is(Tree.Kind.IDENTIFIER)) {
            identifier = (IdentifierTree)methodSelect;
            resolution = this.resolve.findMethod(methodEnv, identifier.name(), argTypes, typeParamTypes);
        } else {
            throw new IllegalStateException("Method select in method invocation is not of the expected type " + methodSelect);
        }
        this.associateReference(identifier, resolution.symbol());
        return resolution;
    }

    private void resolveAs(@Nullable Tree tree, int kind) {
        if (tree == null) {
            return;
        }
        if (this.env == null) {
            this.resolveAs(tree, kind, this.semanticModel.getEnv(tree));
        } else {
            this.resolveAs(tree, kind, this.env);
        }
    }

    public JavaSymbol resolveAs(Tree tree, int kind, Resolve.Env resolveEnv) {
        return this.resolveAs(tree, kind, resolveEnv, true);
    }

    public JavaSymbol resolveAs(Tree tree, int kind, Resolve.Env resolveEnv, boolean associateReference) {
        if (tree.is(Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT)) {
            JavaSymbol resolvedSymbol;
            IdentifierTree identifierTree;
            if (tree.is(Tree.Kind.MEMBER_SELECT)) {
                MemberSelectExpressionTree mse = (MemberSelectExpressionTree)tree;
                if (JavaKeyword.CLASS.getValue().equals(mse.identifier().name())) {
                    this.resolveAs(mse.expression(), 2, resolveEnv);
                    this.registerType(tree, this.symbols.classType);
                    return this.symbols.classType.symbol;
                }
                identifierTree = mse.identifier();
                Resolve.Resolution res = this.getSymbolOfMemberSelectExpression(mse, kind, resolveEnv);
                resolvedSymbol = res.symbol();
                JavaType resolvedType = this.resolve.resolveTypeSubstitution(res.type(), this.getType(mse.expression()));
                this.registerType(identifierTree, resolvedType);
                this.registerType(tree, resolvedType);
            } else {
                identifierTree = (IdentifierTree)tree;
                Resolve.Resolution resolution = this.resolve.findIdent(resolveEnv, identifierTree.name(), kind);
                resolvedSymbol = resolution.symbol();
                this.registerType(tree, resolution.type());
            }
            if (associateReference) {
                this.associateReference(identifierTree, resolvedSymbol);
            }
            return resolvedSymbol;
        }
        tree.accept(this);
        JavaType type = this.getType(tree);
        if (tree.is(Tree.Kind.INFERED_TYPE)) {
            type = Symbols.unknownType;
            this.registerType(tree, type);
        }
        if (type == null) {
            throw new IllegalStateException("Type not resolved " + tree);
        }
        return type.symbol;
    }

    private Resolve.Resolution getSymbolOfMemberSelectExpression(MemberSelectExpressionTree mse, int kind, Resolve.Env resolveEnv) {
        int expressionKind = 2;
        if ((kind & 4) != 0) {
            expressionKind |= 4;
        }
        if ((kind & 2) != 0) {
            expressionKind |= 1;
        }
        JavaSymbol site = this.resolveAs(mse.expression(), expressionKind, resolveEnv);
        if (site.kind == 4) {
            return this.resolve.findIdentInType(resolveEnv, this.getType((Tree)mse.expression()).symbol, mse.identifier().name(), 4);
        }
        if (site.kind == 2) {
            return this.resolve.findIdentInType(resolveEnv, (JavaSymbol.TypeJavaSymbol)site, mse.identifier().name(), kind);
        }
        if (site.kind == 1) {
            return Resolve.Resolution.resolution(this.resolve.findIdentInPackage(site, mse.identifier().name(), kind));
        }
        return this.resolve.unresolved();
    }

    private void resolveAs(List<? extends Tree> trees, int kind) {
        for (Tree tree : trees) {
            this.resolveAs(tree, kind);
        }
    }

    @Override
    public void visitTypeParameter(TypeParameterTree typeParameter) {
    }

    @Override
    public void visitTypeArguments(TypeArgumentListTreeImpl trees) {
        this.resolveAs(trees, 2);
    }

    @Override
    public void visitInstanceOf(InstanceOfTree tree) {
        this.resolveAs(tree.expression(), 4);
        this.resolveAs(tree.type(), 2);
        this.registerType(tree, this.symbols.booleanType);
    }

    @Override
    public void visitParameterizedType(ParameterizedTypeTree tree) {
        this.resolveAs(tree.type(), 2);
        this.resolveAs(tree.typeArguments(), 2);
        JavaType type = this.getType(tree.type());
        TypeSubstitution typeSubstitution = new TypeSubstitution();
        if (tree.typeArguments().size() <= type.getSymbol().typeVariableTypes.size()) {
            for (int i = 0; i < tree.typeArguments().size(); ++i) {
                typeSubstitution.add(type.getSymbol().typeVariableTypes.get(i), this.getType((Tree)tree.typeArguments().get(i)));
            }
        }
        this.registerType(tree, this.parametrizedTypeCache.getParametrizedTypeType(type.getSymbol(), typeSubstitution));
    }

    @Override
    public void visitWildcard(WildcardTree tree) {
        if (tree.bound() == null) {
            this.registerType(tree, Symbols.unknownType);
        } else {
            this.resolveAs(tree.bound(), 2);
            this.registerType(tree, this.getType(tree.bound()));
        }
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.resolveAs(tree.condition(), 4);
        this.resolveAs(tree.trueExpression(), 4);
        this.resolveAs(tree.falseExpression(), 4);
        this.registerType(tree, Symbols.unknownType);
    }

    @Override
    public void visitThrowStatement(ThrowStatementTree tree) {
        this.resolveAs(tree.expression(), 4);
    }

    @Override
    public void visitLambdaExpression(LambdaExpressionTree tree) {
        super.visitLambdaExpression(tree);
        this.registerType(tree, Symbols.unknownType);
    }

    @Override
    public void visitNewArray(NewArrayTree tree) {
        this.resolveAs(tree.type(), 2);
        this.scan(tree.dimensions());
        this.resolveAs((List<? extends Tree>)tree.initializers(), 4);
        JavaType type = this.getType(tree.type());
        int dimensions = tree.dimensions().size();
        type = new JavaType.ArrayJavaType(type, this.symbols.arrayClass);
        for (int i = 1; i < dimensions; ++i) {
            type = new JavaType.ArrayJavaType(type, this.symbols.arrayClass);
        }
        this.registerType(tree, type);
    }

    @Override
    public void visitParenthesized(ParenthesizedTree tree) {
        this.resolveAs(tree.expression(), 4);
        this.registerType(tree, this.getType(tree.expression()));
    }

    @Override
    public void visitArrayAccessExpression(ArrayAccessExpressionTree tree) {
        this.resolveAs(tree.expression(), 4);
        this.scan(tree.dimension());
        JavaType type = this.getType(tree.expression());
        if (type != null && type.tag == 11) {
            this.registerType(tree, ((JavaType.ArrayJavaType)type).elementType);
        } else {
            this.registerType(tree, Symbols.unknownType);
        }
    }

    @Override
    public void visitArrayDimension(ArrayDimensionTree tree) {
        this.resolveAs(tree.expression(), 4);
        this.registerType(tree, this.getType(tree.expression()));
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        this.resolveAs(tree.leftOperand(), 4);
        this.resolveAs(tree.rightOperand(), 4);
        JavaType left = this.getType(tree.leftOperand());
        JavaType right = this.getType(tree.rightOperand());
        if (left == null || right == null) {
            this.registerType(tree, Symbols.unknownType);
            return;
        }
        JavaSymbol symbol = this.resolve.findMethod(this.semanticModel.getEnv(tree), this.symbols.predefClass.type, tree.operatorToken().text(), (List<JavaType>)ImmutableList.of((Object)left, (Object)right)).symbol();
        if (symbol.kind != 16) {
            this.registerType(tree, Symbols.unknownType);
            return;
        }
        this.registerType(tree, ((JavaType.MethodJavaType)symbol.type).resultType);
    }

    @Override
    public void visitNewClass(NewClassTree tree) {
        if (tree.enclosingExpression() != null) {
            this.resolveAs(tree.enclosingExpression(), 4);
        }
        Resolve.Env newClassEnv = this.semanticModel.getEnv(tree);
        this.resolveAs(tree.identifier(), 2, newClassEnv, false);
        if (tree.typeArguments() != null) {
            this.resolveAs(tree.typeArguments(), 2);
        }
        this.resolveAs(tree.arguments(), 4);
        NewClassTreeImpl newClassTreeImpl = (NewClassTreeImpl)tree;
        this.resolveConstructorSymbol(newClassTreeImpl.getConstructorIdentifier(), newClassEnv, TypeAndReferenceSolver.getParameterTypes(tree.arguments()));
        ClassTree classBody = tree.classBody();
        if (classBody != null) {
            JavaType type = (JavaType)tree.identifier().symbolType();
            JavaType.ClassJavaType anonymousClassType = (JavaType.ClassJavaType)classBody.symbol().type();
            if (type.getSymbol().isFlag(512)) {
                anonymousClassType.interfaces = ImmutableList.of((Object)type);
                anonymousClassType.supertype = this.symbols.objectType;
            } else {
                anonymousClassType.supertype = type;
                anonymousClassType.interfaces = ImmutableList.of();
            }
            this.scan(classBody);
            this.registerType(tree, anonymousClassType);
        } else {
            this.registerType(tree, this.getType(tree.identifier()));
        }
    }

    private JavaSymbol resolveConstructorSymbol(IdentifierTree identifier, Resolve.Env methodEnv, List<JavaType> argTypes) {
        JavaSymbol symbol = this.resolve.findMethod(methodEnv, (JavaType)identifier.symbolType(), "<init>", argTypes).symbol();
        this.associateReference(identifier, symbol);
        return symbol;
    }

    @Override
    public void visitPrimitiveType(PrimitiveTypeTree tree) {
        Resolve.Env primitiveEnv = this.env;
        if (this.env == null) {
            primitiveEnv = this.semanticModel.getEnv(tree);
        }
        this.registerType(tree, this.resolve.findIdent(primitiveEnv, tree.keyword().text(), 2).type());
    }

    @Override
    public void visitVariable(VariableTree tree) {
        this.scan(tree.modifiers());
        TypeAndReferenceSolver.completeMetadata(((VariableTreeImpl)tree).getSymbol(), tree.modifiers().annotations());
        if (tree.initializer() != null) {
            this.resolveAs(tree.initializer(), 4);
        }
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        this.resolveAs(tree.variable(), 4);
        this.resolveAs(tree.expression(), 4);
        JavaType type = this.getType(tree.variable());
        this.registerType(tree, type);
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        JavaType type = this.typesOfLiterals.get((Object)tree.kind());
        this.registerType(tree, type);
    }

    @Override
    public void visitUnaryExpression(UnaryExpressionTree tree) {
        this.resolveAs(tree.expression(), 4);
        this.registerType(tree, this.getType(tree.expression()));
    }

    @Override
    public void visitArrayType(ArrayTypeTree tree) {
        if (this.getType(tree.type()) == null) {
            this.resolveAs(tree.type(), 2);
        }
        this.scan(tree.annotations());
        this.registerType(tree, new JavaType.ArrayJavaType(this.getType(tree.type()), this.symbols.arrayClass));
    }

    @Override
    public void visitTypeCast(TypeCastTree tree) {
        this.resolveAs(tree.type(), 2);
        this.resolveAs(tree.expression(), 4);
        this.registerType(tree, this.getType(tree.type()));
    }

    @Override
    public void visitUnionType(UnionTypeTree tree) {
        this.resolveAs((List<? extends Tree>)tree.typeAlternatives(), 2);
        ImmutableList.Builder uniontype = ImmutableList.builder();
        for (TypeTree typeTree : tree.typeAlternatives()) {
            uniontype.add((Object)typeTree.symbolType());
        }
        this.registerType(tree, (JavaType)this.resolve.leastUpperBound((List<Type>)uniontype.build()));
    }

    @Override
    public void visitEnumConstant(EnumConstantTree tree) {
        this.scan(tree.modifiers());
        NewClassTree newClassTree = tree.initializer();
        this.scan(newClassTree.enclosingExpression());
        this.registerType(newClassTree.identifier(), ((VariableTreeImpl)((Object)tree)).getSymbol().getType());
        this.scan(newClassTree.typeArguments());
        this.scan(newClassTree.arguments());
        ClassTree classBody = newClassTree.classBody();
        if (classBody != null) {
            this.scan(classBody);
            ((JavaType.ClassJavaType)classBody.symbol().type()).supertype = this.getType(newClassTree.identifier());
        }
        this.resolveConstructorSymbol(tree.simpleName(), this.semanticModel.getEnv(tree), TypeAndReferenceSolver.getParameterTypes(newClassTree.arguments()));
    }

    @Override
    public void visitAnnotation(AnnotationTree tree) {
        if (((AbstractTypedTree)((Object)tree.annotationType())).isTypeSet()) {
            return;
        }
        this.resolveAs(tree.annotationType(), 2);
        Arguments arguments = tree.arguments();
        if (arguments.size() > 1 || !arguments.isEmpty() && ((ExpressionTree)arguments.get(0)).is(Tree.Kind.ASSIGNMENT)) {
            for (ExpressionTree expressionTree : arguments) {
                AssignmentExpressionTree aet = (AssignmentExpressionTree)expressionTree;
                IdentifierTree variable = (IdentifierTree)aet.variable();
                JavaSymbol identInType = this.resolve.findMethod(this.semanticModel.getEnv(tree), this.getType(tree.annotationType()), variable.name(), (List<JavaType>)ImmutableList.of()).symbol();
                this.associateReference(variable, identInType);
                JavaType type = identInType.type;
                if (type == null) {
                    type = Symbols.unknownType;
                }
                this.registerType(variable, type);
                this.resolveAs(aet.expression(), 4);
            }
        } else {
            for (ExpressionTree expressionTree : arguments) {
                this.resolveAs(expressionTree, 4);
            }
        }
        this.registerType(tree, this.getType(tree.annotationType()));
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        if (!((AbstractTypedTree)((Object)tree)).isTypeSet()) {
            this.resolveAs(tree, 4);
        }
    }

    @Override
    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        if (!((AbstractTypedTree)((Object)tree)).isTypeSet()) {
            this.resolveAs(tree, 4);
        }
    }

    @Override
    public void visitMethodReference(MethodReferenceTree methodReferenceTree) {
        this.resolveAs(methodReferenceTree.expression(), 6);
        this.registerType(methodReferenceTree.method(), Symbols.unknownType);
        this.registerType(methodReferenceTree, Symbols.unknownType);
        this.scan(methodReferenceTree.typeArguments());
        this.scan(methodReferenceTree.method());
    }

    @Override
    public void visitOther(Tree tree) {
        this.registerType(tree, Symbols.unknownType);
    }

    @VisibleForTesting
    JavaType getType(Tree tree) {
        return this.types.get(tree);
    }

    private void registerType(Tree tree, JavaType type) {
        if (AbstractTypedTree.class.isAssignableFrom(tree.getClass())) {
            ((AbstractTypedTree)tree).setType(type);
        }
        this.types.put(tree, type);
    }

    private void associateReference(IdentifierTree tree, JavaSymbol symbol) {
        if (symbol.kind < 64) {
            this.semanticModel.associateReference(tree, symbol);
            ((IdentifierTreeImpl)tree).setSymbol(symbol);
            symbol.addUsage(tree);
        }
    }
}

