/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.collections.AVLTree;
import org.sonar.java.collections.PMap;
import org.sonar.java.se.ConstraintManager;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.ObjectConstraint;
import org.sonar.java.se.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.VariableTree;

public class ProgramState {
    private int hashCode;
    private final int constraintSize;
    public static final ProgramState EMPTY_STATE = new ProgramState(AVLTree.create(), AVLTree.create(), ((AVLTree)((AVLTree)AVLTree.create().put(SymbolicValue.NULL_LITERAL, ObjectConstraint.NULL)).put(SymbolicValue.TRUE_LITERAL, (Object)ConstraintManager.BooleanConstraint.TRUE)).put(SymbolicValue.FALSE_LITERAL, (Object)ConstraintManager.BooleanConstraint.FALSE), AVLTree.create(), Lists.newLinkedList());
    private final PMap<ExplodedGraph.ProgramPoint, Integer> visitedPoints;
    private final Deque<SymbolicValue> stack;
    private final PMap<Symbol, SymbolicValue> values;
    private final PMap<SymbolicValue, Integer> references;
    private final PMap<SymbolicValue, Object> constraints;

    private ProgramState(PMap<Symbol, SymbolicValue> values, PMap<SymbolicValue, Integer> references, PMap<SymbolicValue, Object> constraints, PMap<ExplodedGraph.ProgramPoint, Integer> visitedPoints, Deque<SymbolicValue> stack) {
        this.values = values;
        this.references = references;
        this.constraints = constraints;
        this.visitedPoints = visitedPoints;
        this.stack = stack;
        this.constraintSize = 3;
    }

    private ProgramState(ProgramState ps, Deque<SymbolicValue> newStack) {
        this.values = ps.values;
        this.references = ps.references;
        this.constraints = ps.constraints;
        this.constraintSize = ps.constraintSize;
        this.visitedPoints = ps.visitedPoints;
        this.stack = newStack;
    }

    private ProgramState(ProgramState ps, PMap<SymbolicValue, Object> newConstraints) {
        this.values = ps.values;
        this.references = ps.references;
        this.constraints = newConstraints;
        this.constraintSize = ps.constraintSize + 1;
        this.visitedPoints = ps.visitedPoints;
        this.stack = ps.stack;
    }

    ProgramState stackValue(SymbolicValue sv) {
        LinkedList<SymbolicValue> newStack = new LinkedList<SymbolicValue>(this.stack);
        newStack.push(sv);
        return new ProgramState(this, newStack);
    }

    ProgramState clearStack() {
        return this.unstackValue((int)this.stack.size()).state;
    }

    Pop unstackValue(int nbElements) {
        if (nbElements == 0) {
            return new Pop(this, Collections.emptyList());
        }
        Preconditions.checkArgument((this.stack.size() >= nbElements ? 1 : 0) != 0, (Object)nbElements);
        LinkedList<SymbolicValue> newStack = new LinkedList<SymbolicValue>(this.stack);
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < nbElements; ++i) {
            result.add(newStack.pop());
        }
        return new Pop(new ProgramState(this, newStack), result);
    }

    public SymbolicValue peekValue() {
        return this.stack.peek();
    }

    public List<SymbolicValue> peekValues(int n) {
        if (n > this.stack.size()) {
            throw new IllegalStateException("At least " + n + " values were expected on the stack!");
        }
        return ImmutableList.copyOf(this.stack).subList(0, n);
    }

    int numberOfTimeVisited(ExplodedGraph.ProgramPoint programPoint) {
        Integer count = this.visitedPoints.get(programPoint);
        return count == null ? 0 : count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgramState that = (ProgramState)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.constraints, that.constraints) && Objects.equals(this.peekValue(), that.peekValue());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.values, this.constraints, this.peekValue());
        }
        return this.hashCode;
    }

    public String toString() {
        return "{" + this.values.toString() + "}  {" + this.constraints.toString() + "}" + " { " + this.stack.toString() + " }";
    }

    public ProgramState addConstraint(SymbolicValue symbolicValue, Object constraint) {
        PMap<SymbolicValue, Object> newConstraints = this.constraints.put(symbolicValue, constraint);
        if (newConstraints != this.constraints) {
            return new ProgramState(this, newConstraints);
        }
        return this;
    }

    ProgramState put(Symbol symbol, SymbolicValue value) {
        if (symbol.isUnknown()) {
            return this;
        }
        SymbolicValue oldValue = this.values.get(symbol);
        if (oldValue == null || oldValue != value) {
            PMap<SymbolicValue, Integer> newReferences = this.references;
            if (oldValue != null) {
                newReferences = ProgramState.decreaseReference(newReferences, oldValue);
            }
            newReferences = ProgramState.increaseReference(newReferences, value);
            PMap<Symbol, SymbolicValue> newValues = this.values.put(symbol, value);
            return new ProgramState(newValues, newReferences, this.constraints, this.visitedPoints, this.stack);
        }
        return this;
    }

    private static PMap<SymbolicValue, Integer> decreaseReference(PMap<SymbolicValue, Integer> givenReferences, SymbolicValue sv) {
        Integer value = givenReferences.get(sv);
        Preconditions.checkNotNull((Object)value);
        return givenReferences.put(sv, value - 1);
    }

    private static PMap<SymbolicValue, Integer> increaseReference(PMap<SymbolicValue, Integer> givenReferences, SymbolicValue sv) {
        Integer value = givenReferences.get(sv);
        if (value == null) {
            return givenReferences.put(sv, 1);
        }
        return givenReferences.put(sv, value + 1);
    }

    private static boolean isDisposable(SymbolicValue symbolicValue, @Nullable Object constraint) {
        return SymbolicValue.isDisposable(symbolicValue) && (constraint == null || !(constraint instanceof ObjectConstraint) || ((ObjectConstraint)constraint).isDisposable());
    }

    private static boolean inStack(Deque<SymbolicValue> stack, SymbolicValue symbolicValue) {
        for (SymbolicValue value : stack) {
            if (!value.equals(symbolicValue) && !value.references(symbolicValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLocalVariable(Symbol symbol) {
        return symbol.isVariableSymbol() && symbol.owner().isMethodSymbol();
    }

    public ProgramState cleanupDeadSymbols(Set<Symbol> liveVariables) {
        PMap<Symbol, SymbolicValue> newValues = this.values;
        PMap<SymbolicValue, Integer> newReferences = this.references;
        PMap<SymbolicValue, Object> newConstraints = this.constraints;
        boolean newProgramState = false;
        Iterator<Map.Entry<Symbol, SymbolicValue>> iter = newValues.entriesIterator();
        while (iter.hasNext()) {
            Map.Entry<Symbol, SymbolicValue> next = iter.next();
            Symbol symbol = next.getKey();
            if (!ProgramState.isLocalVariable(symbol) || liveVariables.contains(symbol)) continue;
            if (!newProgramState) {
                newProgramState = true;
            }
            SymbolicValue symbolicValue = next.getValue();
            newValues = newValues.remove(symbol);
            if (ProgramState.isReachable(symbolicValue, newReferences = ProgramState.decreaseReference(newReferences, symbolicValue)) || !ProgramState.isDisposable(symbolicValue, newConstraints.get(symbolicValue)) || ProgramState.inStack(this.stack, symbolicValue)) continue;
            newConstraints = newConstraints.remove(symbolicValue);
            newReferences = newReferences.remove(symbolicValue);
        }
        return newProgramState ? new ProgramState(newValues, newReferences, newConstraints, this.visitedPoints, this.stack) : this;
    }

    public ProgramState cleanupConstraints() {
        PMap<SymbolicValue, Object> newConstraints = this.constraints;
        PMap<SymbolicValue, Integer> newReferences = this.references;
        boolean newProgramState = false;
        Iterator<Map.Entry<SymbolicValue, Object>> iter = newConstraints.entriesIterator();
        while (iter.hasNext()) {
            Map.Entry<SymbolicValue, Object> next = iter.next();
            SymbolicValue symbolicValue = next.getKey();
            if (ProgramState.isReachable(symbolicValue, newReferences) || !ProgramState.isDisposable(symbolicValue, next.getValue()) || ProgramState.inStack(this.stack, symbolicValue)) continue;
            if (!newProgramState) {
                newProgramState = true;
            }
            newConstraints = newConstraints.remove(symbolicValue);
            newReferences = newReferences.remove(symbolicValue);
        }
        return newProgramState ? new ProgramState(this.values, newReferences, newConstraints, this.visitedPoints, this.stack) : this;
    }

    public ProgramState resetFieldValues(ConstraintManager constraintManager) {
        final ArrayList variableTrees = new ArrayList();
        this.values.forEach(new PMap.Consumer<Symbol, SymbolicValue>(){

            @Override
            public void accept(Symbol symbol, SymbolicValue value) {
                VariableTree variable;
                if (ProgramState.isField(symbol) && (variable = ((Symbol.VariableSymbol)symbol).declaration()) != null) {
                    variableTrees.add(variable);
                }
            }
        });
        if (variableTrees.isEmpty()) {
            return this;
        }
        PMap<Symbol, SymbolicValue> newValues = this.values;
        PMap<SymbolicValue, Integer> newReferences = this.references;
        for (VariableTree variableTree : variableTrees) {
            Symbol symbol = variableTree.symbol();
            SymbolicValue oldValue = newValues.get(symbol);
            if (oldValue != null) {
                newReferences = ProgramState.decreaseReference(newReferences, oldValue);
            }
            SymbolicValue newValue = constraintManager.createSymbolicValue(variableTree);
            newValues = newValues.put(symbol, newValue);
            newReferences = ProgramState.increaseReference(newReferences, newValue);
        }
        return new ProgramState(newValues, newReferences, this.constraints, this.visitedPoints, this.stack);
    }

    public static boolean isField(Symbol symbol) {
        return symbol.isVariableSymbol() && !symbol.owner().isMethodSymbol();
    }

    private static boolean isReachable(SymbolicValue symbolicValue, PMap<SymbolicValue, Integer> references) {
        Integer integer = references.get(symbolicValue);
        return integer != null && integer > 0;
    }

    public boolean canReach(SymbolicValue symbolicValue) {
        return ProgramState.isReachable(symbolicValue, this.references);
    }

    public ProgramState visitedPoint(ExplodedGraph.ProgramPoint programPoint, int nbOfVisit) {
        return new ProgramState(this.values, this.references, this.constraints, this.visitedPoints.put(programPoint, nbOfVisit), this.stack);
    }

    @CheckForNull
    public Object getConstraint(SymbolicValue sv) {
        return this.constraints.get(sv);
    }

    public int constraintsSize() {
        return this.constraintSize;
    }

    @CheckForNull
    public SymbolicValue getValue(Symbol symbol) {
        return this.values.get(symbol);
    }

    public Map<SymbolicValue, ObjectConstraint> getValuesWithConstraints(final Object state) {
        final HashMap<SymbolicValue, ObjectConstraint> result = new HashMap<SymbolicValue, ObjectConstraint>();
        this.constraints.forEach(new PMap.Consumer<SymbolicValue, Object>(){

            @Override
            public void accept(SymbolicValue value, Object valueConstraint) {
                ObjectConstraint constraint;
                if (valueConstraint instanceof ObjectConstraint && (constraint = (ObjectConstraint)valueConstraint).hasStatus(state)) {
                    result.put(value, constraint);
                }
            }
        });
        return result;
    }

    public List<ObjectConstraint> getFieldConstraints(final Object state) {
        final Set<SymbolicValue> valuesAssignedToFields = this.getFieldValues();
        final ArrayList<ObjectConstraint> result = new ArrayList<ObjectConstraint>();
        this.constraints.forEach(new PMap.Consumer<SymbolicValue, Object>(){

            @Override
            public void accept(SymbolicValue value, Object valueConstraint) {
                ObjectConstraint constraint;
                if (valueConstraint instanceof ObjectConstraint && !valuesAssignedToFields.contains(value) && (constraint = (ObjectConstraint)valueConstraint).hasStatus(state)) {
                    result.add(constraint);
                }
            }
        });
        return result;
    }

    public Set<SymbolicValue> getFieldValues() {
        final HashSet<SymbolicValue> fieldValues = new HashSet<SymbolicValue>();
        this.values.forEach(new PMap.Consumer<Symbol, SymbolicValue>(){

            @Override
            public void accept(Symbol key, SymbolicValue value) {
                if (ProgramState.isField(key)) {
                    fieldValues.add(value);
                }
            }
        });
        return fieldValues;
    }

    public static class Pop {
        public final ProgramState state;
        public final List<SymbolicValue> values;

        public Pop(ProgramState programState, List<SymbolicValue> result) {
            this.state = programState;
            this.values = result;
        }
    }
}

