/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.maven;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.SonarComponents;
import org.sonar.maven.MavenFileScanner;
import org.sonar.maven.MavenFileScannerContextImpl;
import org.sonar.maven.MavenParser;
import org.sonar.maven.model.maven2.MavenProject;
import org.sonar.squidbridge.ProgressReport;
import org.sonar.squidbridge.api.CodeVisitor;

public class MavenAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(MavenAnalyzer.class);
    private final SonarComponents sonarComponents;
    private final List<MavenFileScanner> scanners;

    public MavenAnalyzer(SonarComponents sonarComponents, CodeVisitor ... visitors) {
        ImmutableList.Builder scannersBuilder = ImmutableList.builder();
        for (CodeVisitor visitor : visitors) {
            if (!(visitor instanceof MavenFileScanner)) continue;
            scannersBuilder.add((Object)((MavenFileScanner)visitor));
        }
        this.scanners = scannersBuilder.build();
        this.sonarComponents = sonarComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(Iterable<File> files) {
        boolean hasPomFile;
        boolean hasMavenFileScanners = !this.scanners.isEmpty();
        boolean bl = hasPomFile = !Iterables.isEmpty(files);
        if (hasMavenFileScanners && !hasPomFile) {
            LOG.warn("No 'pom.xml' file have been indexed.");
            return;
        }
        ProgressReport progressReport = new ProgressReport("Report about progress of Maven Pom analyzer", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start((Collection)Lists.newArrayList(files));
        boolean successfulyCompleted = false;
        try {
            for (File file : files) {
                this.simpleScan(file);
                progressReport.nextFile();
            }
            successfulyCompleted = true;
        }
        finally {
            if (successfulyCompleted) {
                progressReport.stop();
            } else {
                progressReport.cancel();
            }
        }
    }

    private void simpleScan(File file) {
        MavenProject project = MavenParser.parseXML(file);
        if (project != null) {
            MavenFileScannerContextImpl scannerContext = new MavenFileScannerContextImpl(project, file, this.sonarComponents);
            for (MavenFileScanner mavenFileScanner : this.scanners) {
                mavenFileScanner.scanFile(scannerContext);
            }
        }
    }
}

