/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.AbstractFilePredicate;
import org.sonar.api.batch.fs.internal.FalsePredicate;
import org.sonar.api.batch.fs.internal.OperatorPredicate;
import org.sonar.api.batch.fs.internal.OptimizedFilePredicate;
import org.sonar.api.batch.fs.internal.OptimizedFilePredicateAdapter;
import org.sonar.api.batch.fs.internal.TruePredicate;

class AndPredicate
extends AbstractFilePredicate
implements OperatorPredicate {
    private final List<OptimizedFilePredicate> predicates = new ArrayList<OptimizedFilePredicate>();

    private AndPredicate() {
    }

    public static FilePredicate create(Collection<FilePredicate> predicates) {
        if (predicates.isEmpty()) {
            return TruePredicate.TRUE;
        }
        AndPredicate result = new AndPredicate();
        for (FilePredicate filePredicate : predicates) {
            if (filePredicate == TruePredicate.TRUE) continue;
            if (filePredicate == FalsePredicate.FALSE) {
                return FalsePredicate.FALSE;
            }
            if (filePredicate instanceof AndPredicate) {
                result.predicates.addAll(((AndPredicate)filePredicate).predicates);
                continue;
            }
            result.predicates.add(OptimizedFilePredicateAdapter.create(filePredicate));
        }
        Collections.sort(result.predicates);
        return result;
    }

    @Override
    public boolean apply(InputFile f) {
        for (OptimizedFilePredicate predicate : this.predicates) {
            if (predicate.apply(f)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterable<InputFile> filter(Iterable<InputFile> target) {
        Iterable<InputFile> result = target;
        for (OptimizedFilePredicate predicate : this.predicates) {
            result = predicate.filter(result);
        }
        return result;
    }

    @Override
    public Iterable<InputFile> get(FileSystem.Index index) {
        if (this.predicates.isEmpty()) {
            return index.inputFiles();
        }
        Iterable<InputFile> result = this.predicates.get(0).get(index);
        for (int i = 1; i < this.predicates.size(); ++i) {
            result = this.predicates.get(i).filter(result);
        }
        return result;
    }

    Collection<OptimizedFilePredicate> predicates() {
        return this.predicates;
    }

    @Override
    public List<FilePredicate> operands() {
        return this.predicates.stream().map(p -> p).collect(Collectors.toList());
    }
}

