/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.BitSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Shell;

public final class FileUtils {
    private static final Log LOG;
    static BitSet charToEscape;

    public static Path makeQualified(Path path, Configuration conf) throws IOException {
        if (!path.isAbsolute()) {
            return path.makeQualified(FileSystem.get((Configuration)conf));
        }
        URI fsUri = FileSystem.getDefaultUri((Configuration)conf);
        URI pathUri = path.toUri();
        String scheme = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        if (scheme == null) {
            scheme = fsUri.getScheme();
            authority = fsUri.getAuthority();
            if (authority == null) {
                authority = "";
            }
        } else if (authority == null) {
            authority = scheme.equals(fsUri.getScheme()) && fsUri.getAuthority() != null ? fsUri.getAuthority() : "";
        }
        return new Path(scheme, authority, pathUri.getPath());
    }

    private FileUtils() {
    }

    public static String makePartName(List<String> partCols, List<String> vals) {
        return FileUtils.makePartName(partCols, vals, null);
    }

    public static String makePartName(List<String> partCols, List<String> vals, String defaultStr) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < partCols.size(); ++i) {
            if (i > 0) {
                name.append("/");
            }
            name.append(FileUtils.escapePathName(partCols.get(i).toLowerCase(), defaultStr));
            name.append('=');
            name.append(FileUtils.escapePathName(vals.get(i), defaultStr));
        }
        return name.toString();
    }

    public static String makeDefaultListBucketingDirName(List<String> skewedCols, String name) {
        String defaultDir = FileUtils.escapePathName(name);
        StringBuilder defaultDirPath = new StringBuilder();
        for (int i = 0; i < skewedCols.size(); ++i) {
            if (i > 0) {
                defaultDirPath.append("/");
            }
            defaultDirPath.append(defaultDir);
        }
        String lbDirName = defaultDirPath.toString();
        return lbDirName;
    }

    public static String makeListBucketingDirName(List<String> lbCols, List<String> vals) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < lbCols.size(); ++i) {
            if (i > 0) {
                name.append("/");
            }
            name.append(FileUtils.escapePathName(lbCols.get(i).toLowerCase()));
            name.append('=');
            name.append(FileUtils.escapePathName(vals.get(i)));
        }
        return name.toString();
    }

    static boolean needsEscaping(char c) {
        return c >= '\u0000' && c < charToEscape.size() && charToEscape.get(c);
    }

    public static String escapePathName(String path) {
        return FileUtils.escapePathName(path, null);
    }

    public static String escapePathName(String path, String defaultPath) {
        if (path == null || path.length() == 0) {
            if (defaultPath == null) {
                return "__HIVE_DEFAULT_PARTITION__";
            }
            return defaultPath;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (FileUtils.needsEscaping(c)) {
                sb.append('%');
                sb.append(String.format("%1$02X", c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescapePathName(String path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < path.length()) {
                int code = -1;
                try {
                    code = Integer.valueOf(path.substring(i + 1, i + 3), 16);
                }
                catch (Exception e) {
                    code = -1;
                }
                if (code >= 0) {
                    sb.append((char)code);
                    i += 2;
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void listStatusRecursively(FileSystem fs, FileStatus fileStatus, List<FileStatus> results) throws IOException {
        if (fileStatus.isDir()) {
            for (FileStatus stat : fs.listStatus(fileStatus.getPath(), new PathFilter(){

                public boolean accept(Path p) {
                    String name = p.getName();
                    return !name.startsWith("_") && !name.startsWith(".");
                }
            })) {
                FileUtils.listStatusRecursively(fs, stat, results);
            }
        } else {
            results.add(fileStatus);
        }
    }

    public static Path getPathOrParentThatExists(FileSystem fs, Path path) throws IOException {
        if (!fs.exists(path)) {
            Path parentPath = path.getParent();
            return FileUtils.getPathOrParentThatExists(fs, parentPath);
        }
        return path;
    }

    public static boolean isActionPermittedForUser(String userName, FileStatus fsStatus, FsAction action) {
        String[] userGroups;
        FsPermission permissions = fsStatus.getPermission();
        if (fsStatus.getOwner().equals(userName) && permissions.getUserAction().implies(action)) {
            return true;
        }
        if (permissions.getOtherAction().implies(action)) {
            return true;
        }
        String fileGroup = fsStatus.getGroup();
        for (String group : userGroups = UserGroupInformation.createRemoteUser((String)userName).getGroupNames()) {
            if (!group.equals(fileGroup)) continue;
            return permissions.getGroupAction().implies(action);
        }
        return false;
    }

    public static boolean isActionPermittedForFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName, FsAction action) throws IOException {
        FileStatus[] childStatuses;
        boolean isDir = fileStatus.isDir();
        FsAction dirActionNeeded = action;
        if (isDir) {
            dirActionNeeded.and(FsAction.EXECUTE);
        }
        if (!FileUtils.isActionPermittedForUser(userName, fileStatus, dirActionNeeded)) {
            return false;
        }
        if (!isDir) {
            return true;
        }
        for (FileStatus childStatus : childStatuses = fs.listStatus(fileStatus.getPath())) {
            if (FileUtils.isActionPermittedForFileHierarchy(fs, childStatus, userName, action)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLocalFile(HiveConf conf, String fileName) {
        try {
            return FileUtils.isLocalFile(conf, new URI(fileName));
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("Unable to create URI from " + fileName), (Throwable)e);
            return false;
        }
    }

    public static boolean isLocalFile(HiveConf conf, URI fileUri) {
        try {
            FileSystem fsForFile = FileSystem.get((URI)fileUri, (Configuration)conf);
            return LocalFileSystem.class.isInstance(fsForFile);
        }
        catch (IOException e) {
            LOG.warn((Object)("Unable to get FileSystem for " + fileUri), (Throwable)e);
            return false;
        }
    }

    public static boolean isOwnerOfFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName) throws IOException {
        FileStatus[] childStatuses;
        if (!fileStatus.getOwner().equals(userName)) {
            return false;
        }
        if (!fileStatus.isDir()) {
            return true;
        }
        for (FileStatus childStatus : childStatuses = fs.listStatus(fileStatus.getPath())) {
            if (FileUtils.isOwnerOfFileHierarchy(fs, childStatus, userName)) continue;
            return false;
        }
        return true;
    }

    static {
        char[] clist;
        LOG = LogFactory.getLog((String)FileUtils.class.getName());
        charToEscape = new BitSet(128);
        for (int c = 0; c < 32; c = (int)((char)(c + 1))) {
            charToEscape.set(c);
        }
        for (char c : clist = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', '[', ']', '^'}) {
            charToEscape.set(c);
        }
        if (Shell.WINDOWS) {
            char[] winClist;
            for (char c : winClist = new char[]{' ', '<', '>', '|'}) {
                charToEscape.set(c);
            }
        }
    }
}

