/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class OrcOutputFormat
extends FileOutputFormat<NullWritable, OrcSerde.OrcSerdeRow>
implements HiveOutputFormat<NullWritable, OrcSerde.OrcSerdeRow> {
    public RecordWriter<NullWritable, OrcSerde.OrcSerdeRow> getRecordWriter(FileSystem fileSystem, JobConf conf, String name, Progressable reporter) throws IOException {
        return new OrcRecordWriter(new Path(name), OrcFile.writerOptions((Configuration)conf));
    }

    @Override
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf conf, Path path, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable reporter) throws IOException {
        OrcFile.WriterOptions options = OrcFile.writerOptions((Configuration)conf);
        if (tableProperties.containsKey("orc.stripe.size")) {
            options.stripeSize(Long.parseLong(tableProperties.getProperty("orc.stripe.size")));
        }
        if (tableProperties.containsKey("orc.compress")) {
            options.compress(CompressionKind.valueOf(tableProperties.getProperty("orc.compress")));
        }
        if (tableProperties.containsKey("orc.compress.size")) {
            options.bufferSize(Integer.parseInt(tableProperties.getProperty("orc.compress.size")));
        }
        if (tableProperties.containsKey("orc.row.index.stride")) {
            options.rowIndexStride(Integer.parseInt(tableProperties.getProperty("orc.row.index.stride")));
        }
        if (tableProperties.containsKey("orc.create.index") && "false".equals(tableProperties.getProperty("orc.create.index"))) {
            options.rowIndexStride(0);
        }
        if (tableProperties.containsKey("orc.block.padding")) {
            options.blockPadding(Boolean.parseBoolean(tableProperties.getProperty("orc.block.padding")));
        }
        return new OrcRecordWriter(path, options);
    }

    private static class OrcRecordWriter
    implements RecordWriter<NullWritable, OrcSerde.OrcSerdeRow>,
    FileSinkOperator.RecordWriter {
        private Writer writer = null;
        private final Path path;
        private final OrcFile.WriterOptions options;

        OrcRecordWriter(Path path, OrcFile.WriterOptions options) {
            this.path = path;
            this.options = options;
        }

        public void write(NullWritable nullWritable, OrcSerde.OrcSerdeRow row) throws IOException {
            if (this.writer == null) {
                this.options.inspector(row.getInspector());
                this.writer = OrcFile.createWriter(this.path, this.options);
            }
            this.writer.addRow(row.getRow());
        }

        @Override
        public void write(Writable row) throws IOException {
            OrcSerde.OrcSerdeRow serdeRow = (OrcSerde.OrcSerdeRow)row;
            if (this.writer == null) {
                this.options.inspector(serdeRow.getInspector());
                this.writer = OrcFile.createWriter(this.path, this.options);
            }
            this.writer.addRow(serdeRow.getRow());
        }

        public void close(Reporter reporter) throws IOException {
            this.close(true);
        }

        @Override
        public void close(boolean b) throws IOException {
            if (this.writer == null) {
                StandardStructObjectInspector inspector = ObjectInspectorFactory.getStandardStructObjectInspector(new ArrayList<String>(), new ArrayList<ObjectInspector>());
                this.options.inspector(inspector);
                this.writer = OrcFile.createWriter(this.path, this.options);
            }
            this.writer.close();
        }
    }
}

