/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;

public class NonBlockingOpDeDupProc
implements Transform {
    private ParseContext pctx;

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        this.pctx = pctx;
        String SEL = SelectOperator.getOperatorName();
        String FIL = FilterOperator.getOperatorName();
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", SEL + "%" + SEL + "%"), new SelectDedup());
        opRules.put(new RuleRegExp("R2", FIL + "%" + FIL + "%"), new FilterDedup());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private class FilterDedup
    implements NodeProcessor {
        private FilterDedup() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            FilterOperator cFIL = (FilterOperator)nd;
            FilterOperator pFIL = (FilterOperator)stack.get(stack.size() - 2);
            if (((FilterDesc)pFIL.getConf()).getIsSamplingPred()) {
                return null;
            }
            ArrayList<ExprNodeDesc> splits = new ArrayList<ExprNodeDesc>();
            ExprNodeDescUtils.split(((FilterDesc)cFIL.getConf()).getPredicate(), splits);
            ExprNodeDescUtils.split(((FilterDesc)pFIL.getConf()).getPredicate(), splits);
            ((FilterDesc)pFIL.getConf()).setPredicate(ExprNodeDescUtils.mergePredicates(splits));
            boolean sortedFilter = ((FilterDesc)pFIL.getConf()).isSortedFilter() || ((FilterDesc)cFIL.getConf()).isSortedFilter();
            ((FilterDesc)pFIL.getConf()).setSortedFilter(sortedFilter);
            pFIL.removeChildAndAdoptItsChildren(cFIL);
            cFIL.setParentOperators(null);
            cFIL.setChildOperators(null);
            cFIL = null;
            return null;
        }
    }

    private class SelectDedup
    implements NodeProcessor {
        private SelectDedup() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator cSEL = (SelectOperator)nd;
            SelectOperator pSEL = (SelectOperator)stack.get(stack.size() - 2);
            if (pSEL.getNumChild() > 1) {
                return null;
            }
            if (((SelectDesc)pSEL.getConf()).isSelStarNoCompute()) {
                return null;
            }
            if (!((SelectDesc)cSEL.getConf()).isSelStarNoCompute()) {
                Set<String> funcOutputs = this.getFunctionOutputs(((SelectDesc)pSEL.getConf()).getOutputColumnNames(), ((SelectDesc)pSEL.getConf()).getColList());
                List<ExprNodeDesc> cSELColList = ((SelectDesc)cSEL.getConf()).getColList();
                List<String> cSELOutputColumnNames = ((SelectDesc)cSEL.getConf()).getOutputColumnNames();
                if (!funcOutputs.isEmpty() && !this.checkReferences(cSELColList, funcOutputs)) {
                    return null;
                }
                if (cSEL.getColumnExprMap() == null) {
                    ((SelectDesc)pSEL.getConf()).setColList(ExprNodeDescUtils.backtrack(cSELColList, cSEL, pSEL));
                    ((SelectDesc)pSEL.getConf()).setOutputColumnNames(cSELOutputColumnNames);
                } else {
                    ArrayList<ExprNodeDesc> newPSELColList = new ArrayList<ExprNodeDesc>();
                    ArrayList<String> newPSELOutputColumnNames = new ArrayList<String>();
                    HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
                    for (int i = 0; i < cSELOutputColumnNames.size(); ++i) {
                        String outputColumnName = cSELOutputColumnNames.get(i);
                        ExprNodeDesc cSELExprNodeDesc = cSELColList.get(i);
                        ExprNodeDesc newPSELExprNodeDesc = ExprNodeDescUtils.backtrack(cSELExprNodeDesc, cSEL, pSEL);
                        newPSELColList.add(newPSELExprNodeDesc);
                        newPSELOutputColumnNames.add(outputColumnName);
                        colExprMap.put(outputColumnName, newPSELExprNodeDesc);
                    }
                    ((SelectDesc)pSEL.getConf()).setColList(newPSELColList);
                    ((SelectDesc)pSEL.getConf()).setOutputColumnNames(newPSELOutputColumnNames);
                    pSEL.setColumnExprMap(colExprMap);
                }
                pSEL.setSchema(cSEL.getSchema());
            }
            ((SelectDesc)pSEL.getConf()).setSelectStar(((SelectDesc)cSEL.getConf()).isSelectStar());
            NonBlockingOpDeDupProc.this.pctx.updateOpParseCtx(pSEL, NonBlockingOpDeDupProc.this.pctx.removeOpParseCtx(cSEL));
            pSEL.removeChildAndAdoptItsChildren(cSEL);
            cSEL.setParentOperators(null);
            cSEL.setChildOperators(null);
            cSEL = null;
            return null;
        }

        private Set<String> getFunctionOutputs(List<String> colNames, List<ExprNodeDesc> targets) {
            HashSet<String> functionOutputs = new HashSet<String>();
            for (int i = 0; i < targets.size(); ++i) {
                if (!(targets.get(i) instanceof ExprNodeGenericFuncDesc)) continue;
                functionOutputs.add(colNames.get(i));
            }
            return functionOutputs;
        }

        private boolean checkReferences(List<ExprNodeDesc> sources, Set<String> funcOutputs) {
            HashSet<String> ref = new HashSet<String>();
            for (ExprNodeDesc source : sources) {
                if (this.checkReferences(source, funcOutputs, ref)) continue;
                return false;
            }
            return true;
        }

        private boolean checkReferences(ExprNodeDesc expr, Set<String> funcOutputs, Set<String> ref) {
            String col;
            if (expr instanceof ExprNodeColumnDesc && funcOutputs.contains(col = ((ExprNodeColumnDesc)expr).getColumn()) && !ref.add(col)) {
                return false;
            }
            if (expr.getChildren() != null) {
                for (ExprNodeDesc child : expr.getChildren()) {
                    if (this.checkReferences(child, funcOutputs, ref)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

