/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public abstract class SizeBasedBigTableSelectorForAutoSMJ {
    protected void getListTopOps(Operator<? extends OperatorDesc> op, List<TableScanOperator> topOps) {
        if (op.getParentOperators() == null || op.getParentOperators().isEmpty()) {
            return;
        }
        for (Operator<OperatorDesc> parentOp : op.getParentOperators()) {
            if (parentOp instanceof TableScanOperator) {
                topOps.add((TableScanOperator)parentOp);
                continue;
            }
            if (parentOp instanceof CommonJoinOperator) {
                topOps.add(null);
                continue;
            }
            this.getListTopOps(parentOp, topOps);
        }
    }

    private long getSize(HiveConf conf, String size, Path path) {
        if (size != null) {
            try {
                return Long.valueOf(size);
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        try {
            FileSystem fs = path.getFileSystem((Configuration)conf);
            return fs.getContentSummary(path).getLength();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    protected long getSize(HiveConf conf, Table table) {
        Path path = table.getPath();
        String size = table.getProperty("totalSize");
        return this.getSize(conf, size, path);
    }

    protected long getSize(HiveConf conf, Partition partition) {
        Path path = partition.getPartitionPath();
        String size = partition.getParameters().get("totalSize");
        return this.getSize(conf, size, path);
    }
}

