/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.List;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.PTFTranslator;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLeadLag;

public class WindowingExprNodeEvaluatorFactory {
    public static ExprNodeEvaluator get(PTFTranslator.LeadLagInfo llInfo, ExprNodeDesc desc) throws HiveException {
        FindLeadLagFuncExprs visitor = new FindLeadLagFuncExprs(llInfo, desc);
        new ExprNodeWalker(visitor).walk(desc);
        return ExprNodeEvaluatorFactory.get(desc);
    }

    static class ExprNodeWalker {
        FindLeadLagFuncExprs visitor;

        public ExprNodeWalker(FindLeadLagFuncExprs visitor) {
            this.visitor = visitor;
        }

        public void walk(ExprNodeDesc e) throws HiveException {
            if (e == null) {
                return;
            }
            List<ExprNodeDesc> children = e.getChildren();
            if (children != null) {
                for (ExprNodeDesc child : children) {
                    this.walk(child);
                }
            }
            if (e instanceof ExprNodeGenericFuncDesc) {
                this.visitor.visit((ExprNodeGenericFuncDesc)e);
            }
        }
    }

    public static class FindLeadLagFuncExprs {
        ExprNodeDesc topExpr;
        PTFTranslator.LeadLagInfo llInfo;

        FindLeadLagFuncExprs(PTFTranslator.LeadLagInfo llInfo, ExprNodeDesc topExpr) {
            this.llInfo = llInfo;
            this.topExpr = topExpr;
        }

        public void visit(ExprNodeGenericFuncDesc fnExpr) throws HiveException {
            GenericUDF fn = fnExpr.getGenericUDF();
            if (fn instanceof GenericUDFLeadLag.GenericUDFLead || fn instanceof GenericUDFLeadLag.GenericUDFLag) {
                this.llInfo.addLLFuncExprForTopExpr(this.topExpr, fnExpr);
            }
        }
    }
}

