/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.List;

public class ReducerTimeStatsPerJob {
    private final String jobId;
    private final long minimumTime;
    private final long maximumTime;
    private final double meanTime;
    private final double standardDeviationTime;

    public ReducerTimeStatsPerJob(List<Integer> reducersRunTimes, String jobId) {
        this.jobId = jobId;
        if (!reducersRunTimes.isEmpty()) {
            int i;
            long minimumTime = reducersRunTimes.get(0).intValue();
            long maximumTime = reducersRunTimes.get(0).intValue();
            long totalTime = reducersRunTimes.get(0).intValue();
            double standardDeviationTime = 0.0;
            double meanTime = 0.0;
            for (i = 1; i < reducersRunTimes.size(); ++i) {
                if ((long)reducersRunTimes.get(i).intValue() < minimumTime) {
                    minimumTime = reducersRunTimes.get(i).intValue();
                }
                if ((long)reducersRunTimes.get(i).intValue() > maximumTime) {
                    maximumTime = reducersRunTimes.get(i).intValue();
                }
                totalTime += (long)reducersRunTimes.get(i).intValue();
            }
            meanTime = (double)totalTime / (double)reducersRunTimes.size();
            for (i = 0; i < reducersRunTimes.size(); ++i) {
                standardDeviationTime += Math.pow(meanTime - (double)reducersRunTimes.get(i).intValue(), 2.0);
            }
            standardDeviationTime /= (double)reducersRunTimes.size();
            standardDeviationTime = Math.sqrt(standardDeviationTime);
            this.minimumTime = minimumTime;
            this.maximumTime = maximumTime;
            this.meanTime = meanTime;
            this.standardDeviationTime = standardDeviationTime;
            return;
        }
        this.minimumTime = -1L;
        this.maximumTime = -1L;
        this.meanTime = -1.0;
        this.standardDeviationTime = -1.0;
    }

    public long getMinimumTime() {
        return this.minimumTime;
    }

    public long getMaximumTime() {
        return this.maximumTime;
    }

    public double getMeanTime() {
        return this.meanTime;
    }

    public double getStandardDeviationTime() {
        return this.standardDeviationTime;
    }

    public String getJobId() {
        return this.jobId;
    }
}

