/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDFReflect;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@Description(name="reflect2", value="_FUNC_(arg0,method[,arg1[,arg2..]]) calls method of arg0 with reflection", extended="Use this UDF to call Java methods by matching the argument signature\n")
@UDFType(deterministic=true)
public class GenericUDFReflect2
extends AbstractGenericUDFReflect {
    private PrimitiveObjectInspector targetOI;
    private PrimitiveObjectInspector returnOI;
    private transient Method method;
    private transient Writable returnObj;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 2) {
            throw new UDFArgumentLengthException("The function GenericUDFReflect2(arg0,method[,arg1[,arg2]...]) accepts 2 or more arguments.");
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "The target instance should be a primitive type.");
        }
        this.targetOI = (PrimitiveObjectInspector)arguments[0];
        if (!(arguments[1] instanceof StringObjectInspector)) {
            throw new UDFArgumentTypeException(1, "The method name should be string type.");
        }
        if (!(arguments[1] instanceof ConstantObjectInspector)) {
            throw new UDFArgumentTypeException(1, "The method name should be a constant.");
        }
        Text methodName = (Text)((ConstantObjectInspector)arguments[1]).getWritableConstantValue();
        if (methodName.toString().equals("hashCode") && arguments.length == 2) {
            throw new UDFArgumentTypeException(1, "Use hash() UDF instead of this.");
        }
        this.setupParameterOIs(arguments, 2);
        Class<?> targetClass = PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveCategory((PrimitiveObjectInspector.PrimitiveCategory)this.targetOI.getPrimitiveCategory()).primitiveJavaClass;
        try {
            this.method = this.findMethod(targetClass, methodName.toString(), null, true);
            PrimitiveObjectInspectorUtils.PrimitiveTypeEntry typeEntry = this.getTypeFor(this.method.getReturnType());
            this.returnOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(PrimitiveObjectInspectorUtils.getTypeEntryFromTypeSpecs(typeEntry.primitiveCategory, typeEntry.typeParams));
            this.returnObj = (Writable)this.returnOI.getPrimitiveWritableClass().newInstance();
        }
        catch (Exception e) {
            throw new UDFArgumentException(e);
        }
        return this.returnOI;
    }

    private PrimitiveObjectInspectorUtils.PrimitiveTypeEntry getTypeFor(Class<?> retType) throws UDFArgumentException {
        PrimitiveObjectInspectorUtils.PrimitiveTypeEntry entry = PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveJavaType(retType);
        if (entry == null) {
            entry = PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveJavaClass(retType);
        }
        if (entry == null) {
            throw new UDFArgumentException("Invalid return type " + retType);
        }
        return entry;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object targetObject = this.targetOI.getPrimitiveJavaObject(arguments[0].get());
        if (targetObject == null) {
            return null;
        }
        Object result = null;
        try {
            result = this.method.invoke(targetObject, this.setupParameters(arguments, 2));
        }
        catch (InvocationTargetException e) {
            throw new HiveException(e.getCause());
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        if (result == null) {
            return null;
        }
        switch (this.returnOI.getPrimitiveCategory()) {
            case VOID: {
                return null;
            }
            case BOOLEAN: {
                ((BooleanWritable)this.returnObj).set(((Boolean)result).booleanValue());
                return this.returnObj;
            }
            case BYTE: {
                ((ByteWritable)this.returnObj).set((Byte)result);
                return this.returnObj;
            }
            case SHORT: {
                ((ShortWritable)this.returnObj).set((Short)result);
                return this.returnObj;
            }
            case INT: {
                ((IntWritable)this.returnObj).set(((Integer)result).intValue());
                return this.returnObj;
            }
            case LONG: {
                ((LongWritable)this.returnObj).set(((Long)result).longValue());
                return this.returnObj;
            }
            case FLOAT: {
                ((FloatWritable)this.returnObj).set(((Float)result).floatValue());
                return this.returnObj;
            }
            case DOUBLE: {
                ((DoubleWritable)this.returnObj).set((Double)result);
                return this.returnObj;
            }
            case STRING: {
                ((Text)this.returnObj).set((String)result);
                return this.returnObj;
            }
            case TIMESTAMP: {
                ((TimestampWritable)this.returnObj).set((Timestamp)result);
                return this.returnObj;
            }
            case BINARY: {
                ((BytesWritable)this.returnObj).set((byte[])result, 0, ((byte[])result).length);
                return this.returnObj;
            }
            case DECIMAL: {
                ((HiveDecimalWritable)this.returnObj).set((HiveDecimal)result);
                return this.returnObj;
            }
        }
        throw new HiveException("Invalid type " + (Object)((Object)this.returnOI.getPrimitiveCategory()));
    }

    @Override
    protected String functionName() {
        return "reflect2";
    }
}

