/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.LongWritable;

@Description(name="to_unix_timestamp", value="_FUNC_(date[, pattern]) - Returns the UNIX timestamp", extended="Converts the specified time to number of seconds since 1970-01-01.")
public class GenericUDFToUnixTimeStamp
extends GenericUDF {
    private transient StringObjectInspector intputTextOI;
    private transient DateObjectInspector inputDateOI;
    private transient TimestampObjectInspector inputTimestampOI;
    private transient StringObjectInspector patternOI;
    private String lasPattern = "yyyy-MM-dd HH:mm:ss";
    private final transient SimpleDateFormat formatter = new SimpleDateFormat(this.lasPattern);
    protected final transient LongWritable retValue = new LongWritable();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.initializeInput(arguments);
        return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
    }

    protected void initializeInput(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 1) {
            throw new UDFArgumentLengthException("The function TO_UNIX_TIMESTAMP requires at least one argument");
        }
        if (arguments[0] instanceof StringObjectInspector) {
            this.intputTextOI = (StringObjectInspector)arguments[0];
            if (arguments.length > 1) {
                if (!(arguments[1] instanceof StringObjectInspector)) {
                    throw new UDFArgumentException("The time pattern for " + this.getName().toUpperCase() + " should be string type");
                }
                this.patternOI = (StringObjectInspector)arguments[1];
            }
        } else if (arguments[0] instanceof DateObjectInspector) {
            this.inputDateOI = (DateObjectInspector)arguments[0];
        } else if (arguments[0] instanceof TimestampObjectInspector) {
            this.inputTimestampOI = (TimestampObjectInspector)arguments[0];
        } else {
            throw new UDFArgumentException("The function " + this.getName().toUpperCase() + " takes only string or timestamp types");
        }
    }

    protected String getName() {
        return "to_unix_timestamp";
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (this.intputTextOI != null) {
            String textVal = this.intputTextOI.getPrimitiveJavaObject(arguments[0].get());
            if (textVal == null) {
                return null;
            }
            if (this.patternOI != null) {
                String patternVal = this.patternOI.getPrimitiveJavaObject(arguments[1].get());
                if (patternVal == null) {
                    return null;
                }
                if (!patternVal.equals(this.lasPattern)) {
                    this.formatter.applyPattern(patternVal);
                    this.lasPattern = patternVal;
                }
            }
            try {
                this.retValue.set(this.formatter.parse(textVal).getTime() / 1000L);
                return this.retValue;
            }
            catch (ParseException e) {
                return null;
            }
        }
        if (this.inputDateOI != null) {
            this.retValue.set(this.inputDateOI.getPrimitiveWritableObject(arguments[0].get()).getTimeInSeconds());
            return this.retValue;
        }
        Timestamp timestamp = this.inputTimestampOI.getPrimitiveJavaObject(arguments[0].get());
        this.retValue.set(timestamp.getTime() / 1000L);
        return this.retValue;
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.getName());
        sb.append('(');
        sb.append(StringUtils.join((Object[])children, (char)','));
        sb.append(')');
        return sb.toString();
    }
}

