/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.typeinfo;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.BaseTypeParams;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;

public final class TypeInfoFactory {
    private static Log LOG = LogFactory.getLog(TypeInfoFactory.class);
    static ConcurrentHashMap<String, TypeInfo> cachedPrimitiveTypeInfo = new ConcurrentHashMap();
    public static final TypeInfo voidTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("void");
    public static final TypeInfo booleanTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("boolean");
    public static final TypeInfo intTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("int");
    public static final TypeInfo longTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("bigint");
    public static final TypeInfo stringTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("string");
    public static final TypeInfo floatTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("float");
    public static final TypeInfo doubleTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("double");
    public static final TypeInfo byteTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("tinyint");
    public static final TypeInfo shortTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("smallint");
    public static final TypeInfo dateTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("date");
    public static final TypeInfo timestampTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("timestamp");
    public static final TypeInfo binaryTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("binary");
    public static final TypeInfo decimalTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("decimal");
    public static final TypeInfo unknownTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("unknown");
    static ConcurrentHashMap<ArrayList<List<?>>, TypeInfo> cachedStructTypeInfo = new ConcurrentHashMap();
    static ConcurrentHashMap<List<?>, TypeInfo> cachedUnionTypeInfo = new ConcurrentHashMap();
    static ConcurrentHashMap<TypeInfo, TypeInfo> cachedListTypeInfo = new ConcurrentHashMap();
    static ConcurrentHashMap<ArrayList<TypeInfo>, TypeInfo> cachedMapTypeInfo = new ConcurrentHashMap();

    private TypeInfoFactory() {
    }

    public static TypeInfo getPrimitiveTypeInfo(String typeName) {
        PrimitiveObjectInspectorUtils.PrimitiveTypeEntry typeEntry = PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName(TypeInfoUtils.getBaseName(typeName));
        if (null == typeEntry) {
            throw new RuntimeException("Cannot getPrimitiveTypeInfo for " + typeName);
        }
        TypeInfo result = cachedPrimitiveTypeInfo.get(typeName);
        if (result == null) {
            TypeInfoUtils.PrimitiveParts parts = TypeInfoUtils.parsePrimitiveParts(typeName);
            if (parts.typeParams != null && parts.typeParams.length > 0) {
                try {
                    BaseTypeParams typeParams = PrimitiveObjectInspectorUtils.PrimitiveTypeEntry.createTypeParams(parts.typeName, parts.typeParams);
                    result = new PrimitiveTypeInfo(typeName);
                    ((PrimitiveTypeInfo)result).setTypeParams(typeParams);
                }
                catch (Exception err) {
                    LOG.error((Object)err);
                    throw new RuntimeException("Error creating type parameters for " + typeName + ": " + err, err);
                }
            } else {
                if (typeEntry.primitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.VARCHAR) {
                    LOG.error((Object)"varchar type used with no type params");
                    throw new RuntimeException("varchar type used with no type params");
                }
                result = new PrimitiveTypeInfo(parts.typeName);
            }
            cachedPrimitiveTypeInfo.put(typeName, result);
        }
        return result;
    }

    public static TypeInfo getPrimitiveTypeInfoFromPrimitiveWritable(Class<?> clazz) {
        String typeName = PrimitiveObjectInspectorUtils.getTypeNameFromPrimitiveWritable(clazz);
        if (typeName == null) {
            throw new RuntimeException("Internal error: Cannot get typeName for " + clazz);
        }
        return TypeInfoFactory.getPrimitiveTypeInfo(typeName);
    }

    public static TypeInfo getPrimitiveTypeInfoFromJavaPrimitive(Class<?> clazz) {
        return TypeInfoFactory.getPrimitiveTypeInfo(PrimitiveObjectInspectorUtils.getTypeNameFromPrimitiveJava(clazz));
    }

    public static TypeInfo getStructTypeInfo(List<String> names, List<TypeInfo> typeInfos) {
        ArrayList<List<Object>> signature = new ArrayList<List<Object>>(2);
        signature.add(names);
        signature.add(typeInfos);
        TypeInfo result = cachedStructTypeInfo.get(signature);
        if (result == null) {
            result = new StructTypeInfo(names, typeInfos);
            cachedStructTypeInfo.put(signature, result);
        }
        return result;
    }

    public static TypeInfo getUnionTypeInfo(List<TypeInfo> typeInfos) {
        TypeInfo result = cachedUnionTypeInfo.get(typeInfos);
        if (result == null) {
            result = new UnionTypeInfo(typeInfos);
            cachedUnionTypeInfo.put(typeInfos, result);
        }
        return result;
    }

    public static TypeInfo getListTypeInfo(TypeInfo elementTypeInfo) {
        TypeInfo result = cachedListTypeInfo.get(elementTypeInfo);
        if (result == null) {
            result = new ListTypeInfo(elementTypeInfo);
            cachedListTypeInfo.put(elementTypeInfo, result);
        }
        return result;
    }

    public static TypeInfo getMapTypeInfo(TypeInfo keyTypeInfo, TypeInfo valueTypeInfo) {
        ArrayList<TypeInfo> signature = new ArrayList<TypeInfo>(2);
        signature.add(keyTypeInfo);
        signature.add(valueTypeInfo);
        TypeInfo result = cachedMapTypeInfo.get(signature);
        if (result == null) {
            result = new MapTypeInfo(keyTypeInfo, valueTypeInfo);
            cachedMapTypeInfo.put(signature, result);
        }
        return result;
    }
}

