/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.typeinfo;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.typeinfo.BaseTypeParams;
import org.apache.hadoop.io.WritableUtils;

public class VarcharTypeParams
extends BaseTypeParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int length;

    @Override
    public void validateParams() throws SerDeException {
        if (this.length < 1) {
            throw new SerDeException("VARCHAR length must be positive");
        }
        if (this.length > 65535) {
            throw new SerDeException("Length " + this.length + " exceeds max varchar length of " + 65535);
        }
    }

    @Override
    public void populateParams(String[] params) throws SerDeException {
        if (params.length != 1) {
            throw new SerDeException("Invalid number of parameters for VARCHAR");
        }
        try {
            this.length = Integer.valueOf(params[0]);
        }
        catch (NumberFormatException err) {
            throw new SerDeException("Error setting VARCHAR length: " + err);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(this.length);
        sb.append(")");
        return sb.toString();
    }

    public void readFields(DataInput in) throws IOException {
        this.length = WritableUtils.readVInt((DataInput)in);
        try {
            this.validateParams();
        }
        catch (SerDeException err) {
            throw new IOException(err);
        }
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.length);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int len) {
        this.length = len;
    }

    @Override
    public boolean hasCharacterMaximumLength() {
        return true;
    }

    @Override
    public int getCharacterMaximumLength() {
        return this.length;
    }
}

