/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.listedlicense;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.InvalidSpdxPropertyException;
import org.spdx.library.model.license.ListedLicenseException;

public class ExceptionJson {
    static final List<String> PROPERTY_VALUE_NAMES = Collections.unmodifiableList(Arrays.asList("licenseExceptionText", "name", "licenseExceptionTemplate", "example", "isDeprecatedLicenseId", "deprecatedVersion", "comment", "licenseExceptionId", "seeAlso", "exceptionTextHtml"));
    Boolean isDeprecatedLicenseId;
    String licenseExceptionText;
    String name;
    String licenseComments;
    String comment;
    List<String> seeAlso = new ArrayList<String>();
    String licenseExceptionId;
    String licenseExceptionTemplate;
    String example;
    String deprecatedVersion;
    String exceptionTextHtml;

    public ExceptionJson(String id) {
        this.licenseExceptionId = id;
    }

    public ExceptionJson() {
    }

    public List<String> getPropertyValueNames() {
        return PROPERTY_VALUE_NAMES;
    }

    public void setTypedProperty(String propertyName, String valueId, String type) throws InvalidSpdxPropertyException {
        throw new InvalidSpdxPropertyException("Invalid type for Listed License SPDX Property: " + type);
    }

    public void setPrimativeValue(String propertyName, Object value) throws InvalidSpdxPropertyException {
        switch (propertyName) {
            case "licenseExceptionText": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.licenseExceptionText = (String)value;
                break;
            }
            case "name": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.name = (String)value;
                break;
            }
            case "seeAlso": {
                throw new InvalidSpdxPropertyException("Expected list type for " + propertyName);
            }
            case "licenseExceptionTemplate": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.licenseExceptionTemplate = (String)value;
                break;
            }
            case "example": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.example = (String)value;
                break;
            }
            case "isDeprecatedLicenseId": {
                if (!(value instanceof Boolean)) {
                    throw new InvalidSpdxPropertyException("Expected Boolean type for " + propertyName);
                }
                this.isDeprecatedLicenseId = (Boolean)value;
                break;
            }
            case "deprecatedVersion": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.deprecatedVersion = (String)value;
                break;
            }
            case "comment": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.licenseComments = (String)value;
                this.comment = (String)value;
                break;
            }
            case "licenseExceptionId": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.licenseExceptionId = (String)value;
                break;
            }
            case "exceptionTextHtml": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.exceptionTextHtml = (String)value;
                break;
            }
            default: {
                throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyName);
            }
        }
    }

    public void clearPropertyValueList(String propertyName) throws InvalidSpdxPropertyException {
        if (!"seeAlso".equals(propertyName)) {
            throw new InvalidSpdxPropertyException(propertyName + "is not a list type");
        }
        this.seeAlso.clear();
    }

    public void addValueToList(String propertyName, String valueId, String type) throws InvalidSpdxPropertyException {
        throw new InvalidSpdxPropertyException("Invalid type for Listed License SPDX Property: " + type);
    }

    public boolean addPrimitiveValueToList(String propertyName, Object value) throws InvalidSpdxPropertyException {
        if (!"seeAlso".equals(propertyName)) {
            throw new InvalidSpdxPropertyException(propertyName + "is not a list type");
        }
        if (!(value instanceof String)) {
            throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
        }
        return this.seeAlso.add((String)value);
    }

    public List<?> getValueList(String propertyName) throws InvalidSpdxPropertyException {
        if (!"seeAlso".equals(propertyName)) {
            throw new InvalidSpdxPropertyException(propertyName + "is not a list type");
        }
        return this.seeAlso;
    }

    public Object getValue(String propertyName) throws InvalidSpdxPropertyException {
        switch (propertyName) {
            case "licenseExceptionText": {
                return this.licenseExceptionText;
            }
            case "name": {
                return this.name;
            }
            case "seeAlso": {
                return this.seeAlso;
            }
            case "licenseExceptionTemplate": {
                return this.licenseExceptionTemplate;
            }
            case "example": {
                return this.example;
            }
            case "isDeprecatedLicenseId": {
                return this.isDeprecatedLicenseId;
            }
            case "deprecatedVersion": {
                return this.deprecatedVersion;
            }
            case "comment": {
                if (this.comment != null) {
                    return this.comment;
                }
                return this.licenseComments;
            }
            case "licenseExceptionId": {
                return this.licenseExceptionId;
            }
            case "exceptionTextHtml": {
                return this.exceptionTextHtml;
            }
        }
        throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyName);
    }

    public void removeProperty(String propertyName) throws InvalidSpdxPropertyException {
        switch (propertyName) {
            case "licenseExceptionText": {
                this.licenseExceptionText = null;
                break;
            }
            case "name": {
                this.name = null;
                break;
            }
            case "seeAlso": {
                this.seeAlso.clear();
                break;
            }
            case "licenseExceptionTemplate": {
                this.licenseExceptionTemplate = null;
                break;
            }
            case "example": {
                this.example = null;
                break;
            }
            case "isDeprecatedLicenseId": {
                this.isDeprecatedLicenseId = null;
                break;
            }
            case "deprecatedVersion": {
                this.deprecatedVersion = null;
                break;
            }
            case "comment": {
                this.comment = null;
                this.licenseComments = null;
                break;
            }
            case "licenseExceptionId": {
                this.licenseExceptionId = null;
                break;
            }
            case "exceptionTextHtml": {
                this.exceptionTextHtml = null;
                break;
            }
            default: {
                throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyName);
            }
        }
    }

    public void copyFrom(ListedLicenseException fromException) throws InvalidSPDXAnalysisException {
        this.comment = null;
        this.licenseComments = fromException.getComment();
        if (Objects.nonNull(this.licenseComments) && this.licenseComments.isEmpty()) {
            this.licenseComments = null;
        }
        this.deprecatedVersion = fromException.getDeprecatedVersion();
        if (Objects.nonNull(this.deprecatedVersion) && this.deprecatedVersion.isEmpty()) {
            this.deprecatedVersion = null;
        }
        this.example = fromException.getExample();
        if (Objects.nonNull(this.example) && this.example.isEmpty()) {
            this.example = null;
        }
        this.isDeprecatedLicenseId = fromException.isDeprecated();
        this.licenseExceptionId = fromException.getId();
        this.licenseExceptionTemplate = fromException.getLicenseExceptionTemplate();
        if (Objects.nonNull(this.licenseExceptionTemplate) && this.licenseExceptionTemplate.isEmpty()) {
            this.licenseExceptionTemplate = null;
        }
        this.licenseExceptionText = fromException.getLicenseExceptionText();
        if (Objects.nonNull(this.licenseExceptionText) && this.licenseExceptionText.isEmpty()) {
            this.licenseExceptionText = null;
        }
        this.name = fromException.getName();
        if (Objects.nonNull(this.name) && this.name.isEmpty()) {
            this.name = null;
        }
        this.seeAlso = new ArrayList<String>(fromException.getSeeAlso());
        this.exceptionTextHtml = fromException.getExceptionTextHtml();
        if (Objects.nonNull(this.exceptionTextHtml) && this.exceptionTextHtml.isEmpty()) {
            this.exceptionTextHtml = null;
        }
    }

    public boolean removePrimitiveValueToList(String propertyName, Object value) throws InvalidSpdxPropertyException {
        if (!"seeAlso".equals(propertyName)) {
            throw new InvalidSpdxPropertyException(propertyName + "is not a list type");
        }
        return this.seeAlso.remove(value);
    }

    public boolean isPropertyValueAssignableTo(String propertyName, Class<?> clazz) throws InvalidSpdxPropertyException {
        switch (propertyName) {
            case "licenseExceptionText": 
            case "name": 
            case "licenseExceptionTemplate": 
            case "example": 
            case "comment": 
            case "deprecatedVersion": 
            case "exceptionTextHtml": 
            case "licenseExceptionId": {
                return String.class.isAssignableFrom(clazz);
            }
            case "seeAlso": {
                return false;
            }
            case "isDeprecatedLicenseId": {
                return Boolean.class.isAssignableFrom(clazz);
            }
        }
        throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyName);
    }

    public boolean isCollectionMembersAssignableTo(String propertyName, Class<?> clazz) {
        if (!"seeAlso".equals(propertyName)) {
            return false;
        }
        return String.class.isAssignableFrom(clazz);
    }

    public boolean isCollectionProperty(String propertyName) {
        return "seeAlso".equals(propertyName);
    }
}

