/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.simple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.SpdxConstants;
import org.spdx.library.model.DuplicateSpdxIdException;
import org.spdx.library.model.ModelCollection;
import org.spdx.library.model.SpdxIdInUseException;
import org.spdx.library.model.SpdxIdNotFoundException;
import org.spdx.library.model.TypedValue;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.StoredTypedItem;

public class InMemSpdxStore
implements IModelStore {
    static final Logger logger = LoggerFactory.getLogger((String)InMemSpdxStore.class.getName());
    static final String GENERATED = "gnrtd";
    public static Pattern LICENSE_ID_PATTERN_GENERATED = Pattern.compile(SpdxConstants.NON_STD_LICENSE_ID_PRENUM + "gnrtd" + "(\\d+)$");
    static Pattern DOCUMENT_ID_PATTERN_GENERATED = Pattern.compile(SpdxConstants.EXTERNAL_DOC_REF_PRENUM + "gnrtd" + "(\\d+)$");
    static Pattern SPDX_ID_PATTERN_GENERATED = Pattern.compile(SpdxConstants.SPDX_ELEMENT_REF_PRENUM + "gnrtd" + "(\\d+)$");
    static final String ANON_PREFIX = "__anon__";
    static Pattern ANON_ID_PATTERN_GENERATED = Pattern.compile("__anon__gnrtd(\\d+)$");
    private static final Set<String> LITERAL_VALUE_SET = new HashSet<String>(Arrays.asList(SpdxConstants.LITERAL_VALUES));
    protected Map<String, Map<String, StoredTypedItem>> documentValues = Collections.synchronizedMap(new LinkedHashMap());
    private int nextNextLicenseId = 0;
    private int nextNextDocumentId = 0;
    private int nextNextSpdxId = 0;
    private int nextAnonId = 0;
    private final ReadWriteLock transactionLock = new ReentrantReadWriteLock();
    private final ReadWriteLock referenceCountLock = new ReentrantReadWriteLock();
    private final IModelStore.IModelStoreLock readLock = new IModelStore.IModelStoreLock(){

        @Override
        public void unlock() {
            InMemSpdxStore.this.transactionLock.readLock().unlock();
        }
    };
    private final IModelStore.IModelStoreLock writeLock = new IModelStore.IModelStoreLock(){

        @Override
        public void unlock() {
            InMemSpdxStore.this.transactionLock.writeLock().unlock();
        }
    };

    @Override
    public boolean exists(String documentUri, String id) {
        Map<String, StoredTypedItem> idMap = this.documentValues.get(documentUri);
        if (idMap == null) {
            return false;
        }
        return idMap.containsKey(id.toLowerCase());
    }

    @Override
    public void create(String documentUri, String id, String type) throws InvalidSPDXAnalysisException {
        StoredTypedItem value = new StoredTypedItem(documentUri, id, type);
        Map<String, StoredTypedItem> idMap = this.documentValues.get(documentUri);
        while (idMap == null) {
            idMap = this.documentValues.putIfAbsent(documentUri, Collections.synchronizedMap(new LinkedHashMap()));
        }
        this.updateNextIds(id);
        if (Objects.nonNull(idMap.putIfAbsent(id.toLowerCase(), value))) {
            throw new DuplicateSpdxIdException("ID " + id + " already exists.");
        }
    }

    void updateNextIds(String id) {
        if (id == null) {
            return;
        }
        Matcher licenseRefMatcher = LICENSE_ID_PATTERN_GENERATED.matcher(id);
        if (licenseRefMatcher.matches()) {
            this.checkUpdateNextLicenseId(licenseRefMatcher);
            return;
        }
        Matcher documentRefMatcher = DOCUMENT_ID_PATTERN_GENERATED.matcher(id);
        if (documentRefMatcher.matches()) {
            this.checkUpdateNextDocumentId(documentRefMatcher);
            return;
        }
        Matcher spdxRefMatcher = SPDX_ID_PATTERN_GENERATED.matcher(id);
        if (spdxRefMatcher.matches()) {
            this.checkUpdateNextSpdxId(spdxRefMatcher);
            return;
        }
        Matcher anonRefMatcher = ANON_ID_PATTERN_GENERATED.matcher(id);
        if (anonRefMatcher.matches()) {
            this.checkUpdateNextAnonId(anonRefMatcher);
            return;
        }
    }

    private synchronized void checkUpdateNextAnonId(Matcher anonRefMatcher) {
        String strNum = anonRefMatcher.group(1);
        int num = Integer.parseInt(strNum);
        if (num >= this.nextAnonId) {
            this.nextAnonId = num + 1;
        }
    }

    private synchronized void checkUpdateNextSpdxId(Matcher spdxRefMatcher) {
        String strNum = spdxRefMatcher.group(1);
        int num = Integer.parseInt(strNum);
        if (num >= this.nextNextSpdxId) {
            this.nextNextSpdxId = num + 1;
        }
    }

    private synchronized void checkUpdateNextDocumentId(Matcher documentRefMatcher) {
        String strNum = documentRefMatcher.group(1);
        int num = Integer.parseInt(strNum);
        if (num >= this.nextNextDocumentId) {
            this.nextNextDocumentId = num + 1;
        }
    }

    private synchronized void checkUpdateNextLicenseId(Matcher licenseRefMatcher) {
        String strNum = licenseRefMatcher.group(1);
        int num = Integer.parseInt(strNum);
        if (num >= this.nextNextLicenseId) {
            this.nextNextLicenseId = num + 1;
        }
    }

    protected StoredTypedItem getItem(String documentUri, String id) throws InvalidSPDXAnalysisException {
        Map<String, StoredTypedItem> idMap = this.documentValues.get(documentUri);
        if (idMap == null) {
            throw new SpdxIdNotFoundException("Document URI " + documentUri + " was not found in the memory store.  The ID must first be created before getting or setting property values.");
        }
        StoredTypedItem item = idMap.get(id.toLowerCase());
        if (item == null) {
            throw new SpdxIdNotFoundException("ID " + id + " was not found in the memory store.  The ID must first be created before getting or setting property values.");
        }
        return item;
    }

    @Override
    public List<String> getPropertyValueNames(String documentUri, String id) throws InvalidSPDXAnalysisException {
        return this.getItem(documentUri, id).getPropertyValueNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        if (value instanceof TypedValue) {
            this.referenceCountLock.writeLock().lock();
            try {
                StoredTypedItem itemToBeStored = this.getItem(documentUri, ((TypedValue)value).getId());
                this.getItem(documentUri, id).setValue(propertyName, value);
                itemToBeStored.incReferenceCount();
            }
            finally {
                this.referenceCountLock.writeLock().unlock();
            }
        } else {
            this.getItem(documentUri, id).setValue(propertyName, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearValueCollection(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        this.referenceCountLock.writeLock().lock();
        try {
            ArrayList<StoredTypedItem> removedItems = new ArrayList<StoredTypedItem>();
            Iterator<Object> iter = this.getItem(documentUri, id).getValueList(propertyName);
            while (iter.hasNext()) {
                Object nextItem = iter.next();
                if (!(nextItem instanceof TypedValue)) continue;
                removedItems.add(this.getItem(documentUri, ((TypedValue)nextItem).getId()));
            }
            this.getItem(documentUri, id).clearPropertyValueList(propertyName);
            for (StoredTypedItem item : removedItems) {
                item.decReferenceCount();
            }
        }
        finally {
            this.referenceCountLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addValueToCollection(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        if (value instanceof TypedValue) {
            this.referenceCountLock.writeLock().lock();
            try {
                StoredTypedItem itemToBeStored = this.getItem(documentUri, ((TypedValue)value).getId());
                boolean result = this.getItem(documentUri, id).addValueToList(propertyName, value);
                itemToBeStored.incReferenceCount();
                boolean bl = result;
                return bl;
            }
            finally {
                this.referenceCountLock.writeLock().unlock();
            }
        }
        return this.getItem(documentUri, id).addValueToList(propertyName, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeValueFromCollection(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        if (value instanceof TypedValue) {
            this.referenceCountLock.writeLock().lock();
            try {
                StoredTypedItem itemToBeStored = this.getItem(documentUri, ((TypedValue)value).getId());
                boolean result = this.getItem(documentUri, id).removeValueFromList(propertyName, value);
                itemToBeStored.decReferenceCount();
                boolean bl = result;
                return bl;
            }
            finally {
                this.referenceCountLock.writeLock().unlock();
            }
        }
        return this.getItem(documentUri, id).removeValueFromList(propertyName, value);
    }

    @Override
    public Iterator<Object> listValues(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        return this.getItem(documentUri, id).getValueList(propertyName);
    }

    @Override
    public Optional<Object> getValue(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        StoredTypedItem item = this.getItem(documentUri, id);
        if (item.isCollectionProperty(propertyName)) {
            logger.warn("Returning a collection for a getValue call for property " + propertyName);
            return Optional.of(new ModelCollection(this, documentUri, id, propertyName, null, null));
        }
        return Optional.ofNullable(item.getValue(propertyName));
    }

    @Override
    public synchronized String getNextId(IModelStore.IdType idType, String documentUri) throws InvalidSPDXAnalysisException {
        switch (idType) {
            case Anonymous: {
                return "__anon__gnrtd" + String.valueOf(this.nextAnonId++);
            }
            case LicenseRef: {
                return SpdxConstants.NON_STD_LICENSE_ID_PRENUM + GENERATED + String.valueOf(this.nextNextLicenseId++);
            }
            case DocumentRef: {
                return SpdxConstants.EXTERNAL_DOC_REF_PRENUM + GENERATED + String.valueOf(this.nextNextDocumentId++);
            }
            case SpdxId: {
                return SpdxConstants.SPDX_ELEMENT_REF_PRENUM + GENERATED + String.valueOf(this.nextNextSpdxId++);
            }
            case ListedLicense: {
                throw new InvalidSPDXAnalysisException("Can not generate a license ID for a Listed License");
            }
            case Literal: {
                throw new InvalidSPDXAnalysisException("Can not generate a license ID for a Literal");
            }
        }
        throw new InvalidSPDXAnalysisException("Unknown ID type for next ID: " + idType.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProperty(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        this.referenceCountLock.writeLock().lock();
        try {
            Object itemToBeRemoved = this.getItem(documentUri, id).getValue(propertyName);
            this.getItem(documentUri, id).removeProperty(propertyName);
            if (itemToBeRemoved instanceof TypedValue) {
                this.getItem(documentUri, ((TypedValue)itemToBeRemoved).getId()).decReferenceCount();
            }
        }
        finally {
            this.referenceCountLock.writeLock().unlock();
        }
    }

    @Override
    public List<String> getDocumentUris() {
        return Collections.unmodifiableList(new ArrayList<String>(this.documentValues.keySet()));
    }

    @Override
    public Stream<TypedValue> getAllItems(String documentUri, String typeFilter) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Document URi can not be null");
        ArrayList<StoredTypedItem> allItems = new ArrayList<StoredTypedItem>();
        Map<String, StoredTypedItem> itemMap = this.documentValues.get(documentUri);
        if (Objects.nonNull(itemMap)) {
            for (StoredTypedItem item : itemMap.values()) {
                if (!Objects.isNull(typeFilter) && !typeFilter.equals(item.getType())) continue;
                allItems.add(item);
            }
        }
        return Collections.unmodifiableList(allItems).stream();
    }

    @Override
    public int collectionSize(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        return this.getItem(documentUri, id).collectionSize(propertyName);
    }

    @Override
    public boolean collectionContains(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        return this.getItem(documentUri, id).collectionContains(propertyName, value);
    }

    @Override
    public boolean isCollectionMembersAssignableTo(String documentUri, String id, String propertyName, Class<?> clazz) throws InvalidSPDXAnalysisException {
        return this.getItem(documentUri, id).isCollectionMembersAssignableTo(propertyName, clazz);
    }

    @Override
    public boolean isPropertyValueAssignableTo(String documentUri, String id, String propertyName, Class<?> clazz) throws InvalidSPDXAnalysisException {
        return this.getItem(documentUri, id).isPropertyValueAssignableTo(propertyName, clazz);
    }

    @Override
    public boolean isCollectionProperty(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        return this.getItem(documentUri, id).isCollectionProperty(propertyName);
    }

    @Override
    public IModelStore.IdType getIdType(String id) {
        if (id.startsWith("__anon__gnrtd")) {
            return IModelStore.IdType.Anonymous;
        }
        if (id.startsWith(SpdxConstants.NON_STD_LICENSE_ID_PRENUM)) {
            return IModelStore.IdType.LicenseRef;
        }
        if (id.startsWith(SpdxConstants.EXTERNAL_DOC_REF_PRENUM)) {
            return IModelStore.IdType.DocumentRef;
        }
        if (id.startsWith(SpdxConstants.SPDX_ELEMENT_REF_PRENUM)) {
            return IModelStore.IdType.SpdxId;
        }
        if (LITERAL_VALUE_SET.contains(id)) {
            return IModelStore.IdType.Literal;
        }
        if (LicenseInfoFactory.isSpdxListedLicenseId(id) || LicenseInfoFactory.isSpdxListedExceptionId(id)) {
            return IModelStore.IdType.ListedLicense;
        }
        return IModelStore.IdType.Unkown;
    }

    @Override
    public IModelStore.IModelStoreLock enterCriticalSection(String documentUri, boolean readLockRequested) {
        if (readLockRequested) {
            this.transactionLock.readLock().lock();
            return this.readLock;
        }
        this.transactionLock.writeLock().lock();
        return this.writeLock;
    }

    @Override
    public void leaveCriticalSection(IModelStore.IModelStoreLock lock) {
        lock.unlock();
    }

    @Override
    public Optional<String> getCaseSensisitiveId(String documentUri, String caseInsensisitiveId) {
        Map<String, StoredTypedItem> idMap = this.documentValues.get(documentUri);
        if (Objects.isNull(idMap)) {
            return Optional.empty();
        }
        StoredTypedItem item = idMap.get(caseInsensisitiveId.toLowerCase());
        if (Objects.isNull(item)) {
            return Optional.empty();
        }
        return Optional.of(item.getId());
    }

    @Override
    public Optional<TypedValue> getTypedValue(String documentUri, String id) throws InvalidSPDXAnalysisException {
        try {
            return Optional.of(this.getItem(documentUri, id));
        }
        catch (SpdxIdNotFoundException ex) {
            return Optional.empty();
        }
    }

    public void clear(String documentUri) {
        Objects.requireNonNull(documentUri, "Document uri can not be null");
        this.documentValues.put(documentUri, new ConcurrentHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String documentUri, String id) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing Document URI");
        Objects.requireNonNull(id, "Missing ID");
        Map<String, StoredTypedItem> idMap = this.documentValues.get(documentUri);
        if (Objects.isNull(idMap)) {
            logger.error("Error deleting - documentUri " + documentUri + " does not exits.");
            throw new SpdxIdNotFoundException("Error deleting - documentUri " + documentUri + " does not exits.");
        }
        this.referenceCountLock.writeLock().lock();
        try {
            if (this.getItem(documentUri, id).getReferenceCount() > 0) {
                logger.error("Can not delete ID " + id + ".  It is in use");
                throw new SpdxIdInUseException("Can not delete ID " + id + ".  It is in use.");
            }
            List<String> propertyNames = this.getPropertyValueNames(documentUri, id);
            for (String property : propertyNames) {
                if (this.isCollectionProperty(documentUri, id, property)) {
                    Iterator<Object> iter = this.listValues(documentUri, id, property);
                    while (iter.hasNext()) {
                        Object val = iter.next();
                        if (!(val instanceof TypedValue)) continue;
                        this.getItem(documentUri, ((TypedValue)val).getId()).decReferenceCount();
                    }
                    continue;
                }
                Optional<Object> val = this.getValue(documentUri, id, property);
                if (!val.isPresent() || !(val.get() instanceof TypedValue)) continue;
                this.getItem(documentUri, ((TypedValue)val.get()).getId()).decReferenceCount();
            }
            if (Objects.isNull(idMap.remove(id.toLowerCase()))) {
                logger.error("Error deleting - ID " + id + " does not exist.");
                throw new SpdxIdNotFoundException("Error deleting - ID " + id + " does not exist.");
            }
        }
        finally {
            this.referenceCountLock.writeLock().unlock();
        }
    }

    @Override
    public void close() throws Exception {
    }
}

