/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.AbstractFileCompareSheet;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.model.SpdxFile;

public class FileContributorsSheet
extends AbstractFileCompareSheet {
    private static final int FILE_CONTRIBUTOR_COL_WIDTH = 50;

    public FileContributorsSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 50);
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException {
        return SpdxComparer.stringArraysEqual(fileA.getFileContributors(), fileB.getFileContributors());
    }

    @Override
    String getFileValue(SpdxFile spdxFile) {
        StringBuilder sb = new StringBuilder();
        String[] contributors = spdxFile.getFileContributors();
        if (contributors != null && contributors.length > 0) {
            sb.append(contributors[0]);
            for (int i = 1; i < contributors.length; ++i) {
                sb.append(", ");
                sb.append(contributors[i]);
            }
        }
        return sb.toString();
    }
}

