/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tag;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXCreatorInformation;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.DoapProject;
import org.spdx.rdfparser.model.ExternalDocumentRef;
import org.spdx.rdfparser.model.ExternalRef;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxPackage;
import org.spdx.rdfparser.model.SpdxSnippet;
import org.spdx.rdfparser.model.pointer.ByteOffsetPointer;
import org.spdx.rdfparser.model.pointer.LineCharPointer;
import org.spdx.rdfparser.model.pointer.StartEndPointer;
import org.spdx.rdfparser.referencetype.ListedReferenceTypes;
import org.spdx.rdfparser.referencetype.ReferenceType;
import org.spdx.spdxspreadsheet.InvalidLicenseStringException;
import org.spdx.tag.InvalidFileFormatException;
import org.spdx.tag.InvalidSpdxTagFileException;
import org.spdx.tag.TagValueBehavior;

public class BuildDocument
implements TagValueBehavior {
    private static Pattern EXTERNAL_DOC_REF_PATTERN = Pattern.compile("(\\S+)\\s+(\\S+)\\s+SHA1:\\s+(\\S+)");
    private static Pattern RELATIONSHIP_PATTERN = Pattern.compile("(\\S+)\\s+(\\S+)\\s+(\\S+)");
    public static Pattern CHECKSUM_PATTERN = Pattern.compile("(\\S+)\\s+(\\S+)");
    private static Pattern NUMBER_RANGE_PATTERN = Pattern.compile("(\\d+):(\\d+)");
    private static Pattern EXTERNAL_REF_PATTERN = Pattern.compile("([^ ]+) ([^ ]+) (.+)");
    private Set<String> ANNOTATION_TAGS = Sets.newHashSet();
    private Set<String> FILE_TAGS = Sets.newHashSet();
    private Set<String> SNIPPET_TAGS = Sets.newHashSet();
    private Set<String> EXTRACTED_LICENSE_TAGS = Sets.newHashSet();
    private Set<String> PACKAGE_TAGS = Sets.newHashSet();
    private Properties constants;
    private SpdxDocument analysis;
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private SPDXReview lastReviewer = null;
    private int lastReviewerLineNumber = 0;
    private ExtractedLicenseInfo lastExtractedLicense = null;
    private int lastExtractedLicenseLineNumber = 0;
    private SpdxFile lastFile = null;
    private int lastFileLineNumber = 0;
    private SpdxSnippet lastSnippet = null;
    private int lastSnippetLineNumber = 0;
    private DoapProject lastProject = null;
    private int lastProjectLineNumber = 0;
    private Map<String, Integer> elementIdLineNumberMap = Maps.newHashMap();
    private Map<String, List<SpdxFile>> fileDependencyMap = Maps.newHashMap();
    private Map<String, List<SpdxSnippet>> snippetDependencyMap = Maps.newHashMap();
    private RelationshipWithId lastRelationship = null;
    private List<RelationshipWithId> relationships = Lists.newArrayList();
    private AnnotationWithId lastAnnotation;
    private List<AnnotationWithId> annotations = Lists.newArrayList();
    private SpdxDocumentContainer[] result = null;
    private String specVersion;
    private AnyLicenseInfo dataLicense;
    private String documentName;
    List<String> warningMessages;
    private boolean inPackageDefinition = false;
    private boolean inFileDefinition = false;
    private boolean inSnippetDefinition = false;
    private boolean inAnnotation = false;
    private boolean inExtractedLicenseDefinition = false;
    private SpdxPackage lastPackage = null;
    private int lastPackageLineNumber = 0;
    private ExternalRef lastExternalRef = null;

    public BuildDocument(SpdxDocumentContainer[] result, Properties constants, List<String> warnings) {
        this.constants = constants;
        this.warningMessages = warnings;
        this.result = result;
        this.ANNOTATION_TAGS.add(constants.getProperty("PROP_ANNOTATION_DATE").trim() + " ");
        this.ANNOTATION_TAGS.add(constants.getProperty("PROP_ANNOTATION_COMMENT").trim() + " ");
        this.ANNOTATION_TAGS.add(constants.getProperty("PROP_ANNOTATION_ID").trim() + " ");
        this.ANNOTATION_TAGS.add(constants.getProperty("PROP_ANNOTATION_TYPE").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_FILE_TYPE").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_FILE_LICENSE").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_FILE_COPYRIGHT").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_FILE_CHECKSUM").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_FILE_SEEN_LICENSE").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_FILE_LIC_COMMENTS").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_FILE_COMMENT").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_FILE_DEPENDENCY").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_FILE_CONTRIBUTOR").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_FILE_NOTICE_TEXT").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_ELEMENT_ID").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_PROJECT_NAME").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_PROJECT_HOMEPAGE").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_PROJECT_URI").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_DOCUMENT_NAMESPACE").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_RELATIONSHIP").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_RELATIONSHIP_COMMENT").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_ANNOTATOR").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_ANNOTATION_DATE").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_ANNOTATION_COMMENT").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_ANNOTATION_ID").trim() + " ");
        this.FILE_TAGS.add(constants.getProperty("PROP_ANNOTATION_TYPE").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_SNIPPET_SPDX_ID").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_SNIPPET_FROM_FILE_ID").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_SNIPPET_BYTE_RANGE").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_SNIPPET_LINE_RANGE").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_SNIPPET_CONCLUDED_LICENSE").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_SNIPPET_LIC_COMMENTS").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_SNIPPET_COPYRIGHT").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_SNIPPET_COMMENT").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_SNIPPET_NAME").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_SNIPPET_SEEN_LICENSE").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_DOCUMENT_NAMESPACE").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_RELATIONSHIP").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_RELATIONSHIP_COMMENT").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_ANNOTATOR").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_ANNOTATION_DATE").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_ANNOTATION_COMMENT").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_ANNOTATION_ID").trim() + " ");
        this.SNIPPET_TAGS.add(constants.getProperty("PROP_ANNOTATION_TYPE").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_COMMENT").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_FILE_NAME").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_CHECKSUM").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_DOWNLOAD_URL").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_SOURCE_INFO").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_DECLARED_LICENSE").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_CONCLUDED_LICENSE").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_DECLARED_COPYRIGHT").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_SHORT_DESC").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_DESCRIPTION").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_VERIFICATION_CODE").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_LICENSE_INFO_FROM_FILES").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_LICENSE_COMMENT").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_VERSION_INFO").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_ORIGINATOR").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_SUPPLIER").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_HOMEPAGE_URL").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_ELEMENT_ID").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_FILE_NAME").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_RELATIONSHIP").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_RELATIONSHIP_COMMENT").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_ANNOTATOR").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_ANNOTATION_DATE").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_ANNOTATION_COMMENT").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_ANNOTATION_ID").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_ANNOTATION_TYPE").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_EXTERNAL_REFERENCE").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_EXTERNAL_REFERENCE_COMMENT").trim() + " ");
        this.PACKAGE_TAGS.add(constants.getProperty("PROP_PACKAGE_FILES_ANALYZED").trim() + " ");
        this.EXTRACTED_LICENSE_TAGS.add(constants.getProperty("PROP_LICENSE_TEXT").trim() + " ");
        this.EXTRACTED_LICENSE_TAGS.add(constants.getProperty("PROP_EXTRACTED_TEXT").trim() + " ");
        this.EXTRACTED_LICENSE_TAGS.add(constants.getProperty("PROP_LICENSE_COMMENT").trim() + " ");
        this.EXTRACTED_LICENSE_TAGS.add(constants.getProperty("PROP_LICENSE_NAME").trim() + " ");
        this.EXTRACTED_LICENSE_TAGS.add(constants.getProperty("PROP_SOURCE_URLS").trim() + " ");
    }

    @Override
    public void enter() throws Exception {
    }

    @Override
    public void buildDocument(String tag, String value, int lineNumber) throws Exception {
        tag = tag.trim() + " ";
        value = BuildDocument.trim(value.trim());
        if (this.inAnnotation && this.ANNOTATION_TAGS.contains(tag)) {
            this.buildAnnotation(tag, value, this.lastAnnotation);
        } else if (this.inFileDefinition && this.FILE_TAGS.contains(tag)) {
            this.buildFile(this.lastFile, tag, value, lineNumber);
        } else if (this.inSnippetDefinition && this.SNIPPET_TAGS.contains(tag)) {
            this.buildSnippet(this.lastSnippet, tag, value, lineNumber);
        } else if (this.inPackageDefinition && this.PACKAGE_TAGS.contains(tag)) {
            this.buildPackage(this.lastPackage, tag, value, lineNumber);
        } else if (this.inExtractedLicenseDefinition && this.EXTRACTED_LICENSE_TAGS.contains(tag)) {
            this.buildExtractedLicense(this.lastExtractedLicense, tag, value, lineNumber);
        } else {
            if (this.inExtractedLicenseDefinition && this.lastExtractedLicense != null) {
                this.verifyElement(this.lastExtractedLicense.verify(), "Extracted License", this.lastExtractedLicenseLineNumber, false);
            }
            if (this.inFileDefinition) {
                this.addLastFile();
            }
            if (this.inSnippetDefinition) {
                this.addLastSnippet();
            }
            this.inAnnotation = false;
            this.inFileDefinition = false;
            this.inPackageDefinition = false;
            this.inSnippetDefinition = false;
            this.buildDocumentProperties(tag, value, lineNumber);
        }
    }

    private void buildSnippet(SpdxSnippet snippet, String tag, String value, int lineNumber) throws InvalidSpdxTagFileException, InvalidSPDXAnalysisException, InvalidLicenseStringException {
        if (snippet == null) {
            throw new InvalidSpdxTagFileException("Missing Snippet ID - An SPDX Snippet ID must be specified before the snippet properties");
        }
        if (tag.equals(this.constants.getProperty("PROP_SNIPPET_SPDX_ID"))) {
            snippet.setId(value);
            this.elementIdLineNumberMap.put(value, lineNumber);
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_FROM_FILE_ID"))) {
            ArrayList snippetsWithThisAsADependency = this.snippetDependencyMap.get(value);
            if (snippetsWithThisAsADependency == null) {
                snippetsWithThisAsADependency = Lists.newArrayList();
                this.snippetDependencyMap.put(value, snippetsWithThisAsADependency);
            }
            snippetsWithThisAsADependency.add(snippet);
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_BYTE_RANGE"))) {
            snippet.setByteRange(this.parseByteRange(value, lineNumber));
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_LINE_RANGE"))) {
            snippet.setLineRange(this.parseLineRange(value, lineNumber));
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_CONCLUDED_LICENSE"))) {
            snippet.setLicenseConcluded(LicenseInfoFactory.parseSPDXLicenseString(value, this.analysis.getDocumentContainer()));
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_LIC_COMMENTS"))) {
            snippet.setLicenseComments(value);
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_COPYRIGHT"))) {
            snippet.setCopyrightText(value);
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_COMMENT"))) {
            snippet.setComment(value);
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_NAME"))) {
            snippet.setName(value);
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_SEEN_LICENSE"))) {
            snippet.setLicenseInfosFromFiles(new AnyLicenseInfo[]{LicenseInfoFactory.parseSPDXLicenseString(value, this.analysis.getDocumentContainer())});
        } else if (tag.equals(this.constants.getProperty("PROP_ANNOTATOR"))) {
            if (this.lastAnnotation != null) {
                this.annotations.add(this.lastAnnotation);
            }
            this.inAnnotation = true;
            this.lastAnnotation = new AnnotationWithId(value, lineNumber);
        } else if (tag.equals(this.constants.getProperty("PROP_RELATIONSHIP"))) {
            if (this.lastRelationship != null) {
                this.relationships.add(this.lastRelationship);
            }
            this.lastRelationship = this.parseRelationship(value, lineNumber);
        } else if (tag.equals(this.constants.getProperty("PROP_RELATIONSHIP_COMMENT"))) {
            if (this.lastRelationship == null) {
                throw new InvalidSpdxTagFileException("Relationship comment found outside of a relationship: " + value + " at line number " + lineNumber);
            }
            this.lastRelationship.setComment(value);
        } else {
            throw new InvalidSPDXAnalysisException("Error parsing snippet.  Unrecognized tag: " + tag + " at line number " + lineNumber);
        }
    }

    private void verifyElement(List<String> verify, String prefix, int lineNumber) {
        this.verifyElement(verify, prefix, lineNumber, false);
    }

    private void verifyElement(List<String> verify, String prefix, int lineNumber, boolean ignoreMissingLicenseText) {
        if (!verify.isEmpty()) {
            for (String verMsg : verify) {
                if (ignoreMissingLicenseText && verMsg.contains("Missing required license text")) continue;
                boolean found = false;
                String newWarning = prefix + " at line " + lineNumber + " invalid: " + verMsg;
                for (String existingWarn : this.warningMessages) {
                    if (!existingWarn.equals(newWarning)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.warningMessages.add(newWarning);
            }
        }
    }

    private StartEndPointer parseLineRange(String value, int lineNumber) throws InvalidSpdxTagFileException {
        Matcher matcher = NUMBER_RANGE_PATTERN.matcher(value.trim());
        if (!matcher.find()) {
            throw new InvalidSpdxTagFileException("Invalid snippet line range: " + value + " at line number " + lineNumber);
        }
        LineCharPointer start = null;
        try {
            start = new LineCharPointer(null, Integer.parseInt(matcher.group(1)));
        }
        catch (Exception ex) {
            throw new InvalidSpdxTagFileException("Non integer start to snippet line offset: " + value + " at line number " + lineNumber);
        }
        LineCharPointer end = null;
        try {
            end = new LineCharPointer(null, Integer.parseInt(matcher.group(2)));
        }
        catch (Exception ex) {
            throw new InvalidSpdxTagFileException("Non integer end to snippet line offset: " + value + " at line number " + lineNumber);
        }
        return new StartEndPointer(start, end);
    }

    private StartEndPointer parseByteRange(String value, int lineNumber) throws InvalidSpdxTagFileException {
        Matcher matcher = NUMBER_RANGE_PATTERN.matcher(value.trim());
        if (!matcher.find()) {
            throw new InvalidSpdxTagFileException("Invalid snippet byte range: " + value + " at line number " + lineNumber);
        }
        ByteOffsetPointer start = null;
        try {
            start = new ByteOffsetPointer(null, Integer.parseInt(matcher.group(1)));
        }
        catch (Exception ex) {
            throw new InvalidSpdxTagFileException("Non integer start to snippet byte offset: " + value + " at line number " + lineNumber);
        }
        ByteOffsetPointer end = null;
        try {
            end = new ByteOffsetPointer(null, Integer.parseInt(matcher.group(2)));
        }
        catch (Exception ex) {
            throw new InvalidSpdxTagFileException("Non integer end to snippet byte offset: " + value + " at line number " + lineNumber);
        }
        return new StartEndPointer(start, end);
    }

    private void buildExtractedLicense(ExtractedLicenseInfo license, String tag, String value, int lineNumber) throws InvalidSpdxTagFileException {
        if (tag.equals(this.constants.getProperty("PROP_EXTRACTED_TEXT"))) {
            if (this.lastExtractedLicense == null) {
                throw new InvalidSpdxTagFileException("Missing Extracted License - An  extracted license ID must be provided before the license text at line number " + lineNumber);
            }
            license.setExtractedText(value);
        } else if (tag.equals(this.constants.getProperty("PROP_LICENSE_NAME"))) {
            if (this.lastExtractedLicense == null) {
                throw new InvalidSpdxTagFileException("Missing Extracted License - An  extracted license ID must be provided before the license name at line number " + lineNumber);
            }
            license.setName(value);
        } else if (tag.equals(this.constants.getProperty("PROP_SOURCE_URLS"))) {
            if (this.lastExtractedLicense == null) {
                throw new InvalidSpdxTagFileException("Missing Extracted License - An  extracted license ID must be provided before the license URL at line number " + lineNumber);
            }
            String[] values = value.split(",");
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
            }
            license.setSeeAlso(values);
        } else if (tag.equals(this.constants.getProperty("PROP_LICENSE_COMMENT"))) {
            if (this.lastExtractedLicense == null) {
                throw new InvalidSpdxTagFileException("Missing Extracted License - An  extracted license ID must be provided before the license comment at line number " + lineNumber);
            }
            license.setComment(value);
        }
    }

    private void buildDocumentProperties(String tag, String value, int lineNumber) throws Exception {
        if (tag.equals(this.constants.getProperty("PROP_SPDX_VERSION"))) {
            this.specVersion = value;
            if (this.analysis != null) {
                this.analysis.setSpecVersion(value);
            }
        } else if (tag.equals(this.constants.getProperty("PROP_SPDX_DATA_LICENSE"))) {
            try {
                this.dataLicense = LicenseInfoFactory.getListedLicenseById(value);
            }
            catch (InvalidSPDXAnalysisException ex) {
                this.dataLicense = null;
            }
            if (this.dataLicense == null) {
                this.dataLicense = new ExtractedLicenseInfo(value, "NO TEXT FOR " + value);
            }
            if (this.analysis != null) {
                this.analysis.setDataLicense(this.dataLicense);
            }
        } else if (tag.equals(this.constants.getProperty("PROP_DOCUMENT_NAME"))) {
            this.documentName = value;
            if (this.analysis != null) {
                this.analysis.setName(value);
            }
        } else if (tag.equals(this.constants.getProperty("PROP_DOCUMENT_NAMESPACE"))) {
            if (this.analysis != null) {
                throw new InvalidSpdxTagFileException("More than one document namespace was specified at line number " + lineNumber);
            }
            this.result[0] = this.specVersion == null ? new SpdxDocumentContainer(value) : new SpdxDocumentContainer(value, this.specVersion);
            this.analysis = this.result[0].getSpdxDocument();
            if (this.dataLicense != null) {
                this.analysis.setDataLicense(this.dataLicense);
            }
            if (this.documentName != null) {
                this.analysis.setName(this.documentName);
            }
        } else if (tag.equals(this.constants.getProperty("PROP_ELEMENT_ID"))) {
            if (!value.equals("SPDXRef-DOCUMENT")) {
                throw new InvalidSpdxTagFileException("SPDX Document " + value + " is invalid.  Document IDs must be " + "SPDXRef-DOCUMENT" + " at line number " + lineNumber);
            }
        } else if (tag.equals(this.constants.getProperty("PROP_EXTERNAL_DOC_URI"))) {
            this.checkAnalysisNull();
            this.addExternalDocRef(value, lineNumber);
        } else if (tag.equals(this.constants.getProperty("PROP_RELATIONSHIP"))) {
            if (this.lastRelationship != null) {
                this.relationships.add(this.lastRelationship);
            }
            this.lastRelationship = this.parseRelationship(value, lineNumber);
        } else if (tag.equals(this.constants.getProperty("PROP_RELATIONSHIP_COMMENT"))) {
            if (this.lastRelationship == null) {
                throw new InvalidSpdxTagFileException("Relationship comment found outside of a relationship: " + value + " at line number " + lineNumber);
            }
            this.lastRelationship.setComment(value);
        } else if (tag.equals(this.constants.getProperty("PROP_ANNOTATOR"))) {
            if (this.lastAnnotation != null) {
                this.annotations.add(this.lastAnnotation);
            }
            this.inAnnotation = true;
            this.lastAnnotation = new AnnotationWithId(value, lineNumber);
        } else {
            if (tag.equals(this.constants.getProperty("PROP_ANNOTATION_DATE"))) {
                throw new InvalidSpdxTagFileException("Annotation date found outside of an annotation: " + value + " at line number " + lineNumber);
            }
            if (tag.equals(this.constants.getProperty("PROP_ANNOTATION_COMMENT"))) {
                throw new InvalidSpdxTagFileException("Annotation comment found outside of an annotation: " + value + " at line number " + lineNumber);
            }
            if (tag.equals(this.constants.getProperty("PROP_ANNOTATION_ID"))) {
                throw new InvalidSpdxTagFileException("Annotation ID found outside of an annotation: " + value + " at line number " + lineNumber);
            }
            if (tag.equals(this.constants.getProperty("PROP_ANNOTATION_TYPE"))) {
                throw new InvalidSpdxTagFileException("Annotation type found outside of an annotation: " + value + " at line number " + lineNumber);
            }
            if (tag.equals(this.constants.getProperty("PROP_CREATION_CREATOR"))) {
                this.checkAnalysisNull();
                if (this.analysis.getCreationInfo() == null) {
                    SPDXCreatorInformation creator = new SPDXCreatorInformation(new String[]{value}, "", "", "");
                    this.analysis.setCreationInfo(creator);
                } else {
                    ArrayList creators = Lists.newArrayList((Object[])this.analysis.getCreationInfo().getCreators());
                    creators.add(value);
                    this.analysis.getCreationInfo().setCreators(creators.toArray(new String[0]));
                }
            } else if (tag.equals(this.constants.getProperty("PROP_CREATION_CREATED"))) {
                this.checkAnalysisNull();
                if (this.analysis.getCreationInfo() == null) {
                    SPDXCreatorInformation creator = new SPDXCreatorInformation(new String[0], "", "", "");
                    this.analysis.setCreationInfo(creator);
                }
                this.analysis.getCreationInfo().setCreated(value);
            } else if (tag.equals(this.constants.getProperty("PROP_CREATION_COMMENT"))) {
                this.checkAnalysisNull();
                if (this.analysis.getCreationInfo() == null) {
                    SPDXCreatorInformation creator = new SPDXCreatorInformation(new String[]{value}, "", "", "");
                    this.analysis.setCreationInfo(creator);
                }
                this.analysis.getCreationInfo().setComment(value);
            } else if (tag.equals(this.constants.getProperty("PROP_LICENSE_LIST_VERSION"))) {
                this.checkAnalysisNull();
                if (this.analysis.getCreationInfo() == null) {
                    SPDXCreatorInformation creator = new SPDXCreatorInformation(new String[]{value}, "", "", "");
                    this.analysis.setCreationInfo(creator);
                }
                this.analysis.getCreationInfo().setLicenseListVersion(value);
            } else if (tag.equals(this.constants.getProperty("PROP_SPDX_COMMENT"))) {
                this.checkAnalysisNull();
                this.analysis.setComment(value);
            } else if (tag.equals(this.constants.getProperty("PROP_REVIEW_REVIEWER"))) {
                this.checkAnalysisNull();
                this.lastReviewer = new SPDXReview(value, this.format.format(new Date()), "");
                ArrayList reviewers = Lists.newArrayList((Object[])this.analysis.getReviewers());
                reviewers.add(this.lastReviewer);
                this.analysis.setReviewers(reviewers.toArray(new SPDXReview[0]));
                this.verifyElement(this.lastReviewer.verify(), "Reviewer", this.lastReviewerLineNumber);
            } else if (tag.equals(this.constants.getProperty("PROP_REVIEW_DATE"))) {
                this.checkAnalysisNull();
                if (this.lastReviewer == null) {
                    throw new InvalidSpdxTagFileException("Missing Reviewer - A reviewer must be provided before a review date");
                }
                this.lastReviewer.setReviewDate(value);
                this.verifyElement(this.lastReviewer.verify(), "Reviewer", this.lastReviewerLineNumber);
            } else if (tag.equals(this.constants.getProperty("PROP_REVIEW_COMMENT"))) {
                this.checkAnalysisNull();
                if (this.lastReviewer == null) {
                    throw new InvalidSpdxTagFileException("Missing Reviewer - A reviewer must be provided before a review comment");
                }
                this.lastReviewer.setComment(value);
            } else if (tag.equals(this.constants.getProperty("PROP_LICENSE_ID"))) {
                this.checkAnalysisNull();
                if (this.inExtractedLicenseDefinition) {
                    this.verifyElement(this.lastExtractedLicense.verify(), "Extracted License", this.lastExtractedLicenseLineNumber, false);
                }
                if (this.analysis.getDocumentContainer().extractedLicenseExists(value)) {
                    this.lastExtractedLicense = this.analysis.getDocumentContainer().getExtractedLicense(value);
                } else {
                    this.lastExtractedLicense = new ExtractedLicenseInfo(value, "WARNING: TEXT IS REQUIRED", null, null, null);
                    this.lastExtractedLicenseLineNumber = lineNumber;
                    this.analysis.addExtractedLicenseInfos(this.lastExtractedLicense);
                }
                this.inExtractedLicenseDefinition = true;
            } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DECLARED_NAME"))) {
                this.checkAnalysisNull();
                this.inPackageDefinition = true;
                this.inFileDefinition = false;
                this.inAnnotation = false;
                this.inSnippetDefinition = false;
                this.inExtractedLicenseDefinition = false;
                if (this.lastPackage != null) {
                    this.analysis.getDocumentContainer().addElement(this.lastPackage);
                    this.elementIdLineNumberMap.put(this.lastPackage.getId(), this.lastPackageLineNumber);
                }
                this.lastPackage = new SpdxPackage(value, null, null, null, null, null, null, null);
                this.lastPackageLineNumber = lineNumber;
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_NAME"))) {
                this.checkAnalysisNull();
                this.addLastFile();
                this.inFileDefinition = true;
                this.inPackageDefinition = false;
                this.inAnnotation = false;
                this.inSnippetDefinition = false;
                this.inExtractedLicenseDefinition = false;
                this.lastFile = new SpdxFile(value, null, new Annotation[0], new Relationship[0], null, new AnyLicenseInfo[0], null, null, new SpdxFile.FileType[0], new Checksum[0], new String[0], null, new DoapProject[0]);
                this.lastFileLineNumber = lineNumber;
            } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_SPDX_ID"))) {
                this.checkAnalysisNull();
                this.addLastSnippet();
                this.inSnippetDefinition = true;
                this.inFileDefinition = false;
                this.inPackageDefinition = false;
                this.inAnnotation = false;
                this.inExtractedLicenseDefinition = false;
                this.lastSnippet = new SpdxSnippet(null, null, new Annotation[0], new Relationship[0], null, new AnyLicenseInfo[0], null, null, null, null, null);
                this.lastSnippet.setId(value);
                this.lastSnippetLineNumber = lineNumber;
            } else {
                throw new InvalidSpdxTagFileException("Expecting a definition of a file, package, license information, or document property at " + tag + value + " line number " + lineNumber);
            }
        }
    }

    private void addLastFile() throws InvalidSPDXAnalysisException {
        if (this.lastFile != null) {
            if (this.lastPackage != null) {
                this.lastPackage.addFile(this.lastFile);
            } else {
                this.analysis.getDocumentContainer().addElement(this.lastFile);
            }
            this.elementIdLineNumberMap.put(this.lastFile.getId(), this.lastFileLineNumber);
        }
        this.lastFile = null;
    }

    private void addLastSnippet() throws InvalidSPDXAnalysisException {
        if (this.lastSnippet != null) {
            this.analysis.getDocumentContainer().addElement(this.lastSnippet);
            this.elementIdLineNumberMap.put(this.lastSnippet.getId(), this.lastSnippetLineNumber);
        }
        this.lastSnippet = null;
    }

    private void buildAnnotation(String tag, String value, AnnotationWithId annotation) throws InvalidSPDXAnalysisException {
        if (tag.equals(this.constants.getProperty("PROP_ANNOTATION_DATE"))) {
            annotation.setDate(value);
        } else if (tag.equals(this.constants.getProperty("PROP_ANNOTATION_COMMENT"))) {
            annotation.setComment(value);
        } else if (tag.equals(this.constants.getProperty("PROP_ANNOTATION_ID"))) {
            annotation.setId(value);
        } else if (tag.equals(this.constants.getProperty("PROP_ANNOTATION_TYPE"))) {
            Annotation.AnnotationType annotationType = Annotation.AnnotationType.fromTag(value);
            if (annotationType == null) {
                throw new InvalidSPDXAnalysisException("Invalid annotation type: " + value + " at line number " + annotation.getLineNumber());
            }
            annotation.setAnnotationType(annotationType);
        }
    }

    private RelationshipWithId parseRelationship(String value, int lineNumber) throws InvalidSpdxTagFileException {
        Matcher matcher = RELATIONSHIP_PATTERN.matcher(value.trim());
        if (!matcher.find()) {
            throw new InvalidSpdxTagFileException("Invalid relationship: " + value + " at line number " + lineNumber);
        }
        Relationship.RelationshipType relationshipType = null;
        try {
            relationshipType = Relationship.RelationshipType.fromTag(matcher.group(2).toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidSpdxTagFileException("Invalid relationship type: " + value + " at line number " + lineNumber);
        }
        return new RelationshipWithId(matcher.group(1), matcher.group(3), relationshipType, lineNumber);
    }

    private void checkAnalysisNull() throws InvalidSpdxTagFileException, InvalidSPDXAnalysisException, InvalidFileFormatException {
        if (this.analysis == null) {
            if (this.specVersion != null && this.specVersion.compareTo("SPDX-2.0") < 0) {
                this.result[0] = new SpdxDocumentContainer(this.generateDocumentNamespace());
                this.analysis = this.result[0].getSpdxDocument();
            } else {
                throw new InvalidFileFormatException("The SPDX Document Namespace must be set before other SPDX document properties are set.");
            }
        }
    }

    private String generateDocumentNamespace() {
        return "http://spdx.org/documents/" + UUID.randomUUID().toString();
    }

    private void addExternalDocRef(String value, int lineNumber) throws InvalidSpdxTagFileException, InvalidSPDXAnalysisException {
        ExternalDocumentRef ref = BuildDocument.parseExternalDocumentRef(value, lineNumber);
        this.verifyElement(ref.verify(), "External Document Reference", lineNumber);
        ExternalDocumentRef[] oldRefs = this.analysis.getExternalDocumentRefs();
        if (oldRefs == null) {
            oldRefs = new ExternalDocumentRef[]{};
        }
        ExternalDocumentRef[] newRefs = Arrays.copyOf(oldRefs, oldRefs.length + 1);
        newRefs[oldRefs.length] = ref;
        this.analysis.setExternalDocumentRefs(newRefs);
    }

    public static ExternalDocumentRef parseExternalDocumentRef(String refStr, int lineNumber) throws InvalidSpdxTagFileException {
        Matcher matcher = EXTERNAL_DOC_REF_PATTERN.matcher(refStr.trim());
        if (!matcher.find()) {
            throw new InvalidSpdxTagFileException("Invalid external document reference: " + refStr + " at line number " + lineNumber);
        }
        Checksum checksum = new Checksum(Checksum.ChecksumAlgorithm.checksumAlgorithm_sha1, matcher.group(3));
        ExternalDocumentRef ref = new ExternalDocumentRef(matcher.group(2), checksum, matcher.group(1));
        return ref;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildPackage(SpdxPackage pkg, String tag, String value, int lineNumber) throws InvalidSPDXAnalysisException, InvalidSpdxTagFileException, InvalidLicenseStringException {
        if (tag.equals(this.constants.getProperty("PROP_ELEMENT_ID"))) {
            pkg.setId(value);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_VERSION_INFO"))) {
            pkg.setVersionInfo(value);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_FILE_NAME"))) {
            pkg.setPackageFileName(value);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_SUPPLIER"))) {
            pkg.setSupplier(value);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_ORIGINATOR"))) {
            pkg.setOriginator(value);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DOWNLOAD_URL"))) {
            pkg.setDownloadLocation(value);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_VERIFICATION_CODE"))) {
            SpdxPackageVerificationCode verificationCode = null;
            if (value.contains("(")) {
                String[] verification = value.split("\\(");
                String[] excludedFiles = verification[1].replace(")", "").split(",");
                for (int i = 0; i < excludedFiles.length; ++i) {
                    excludedFiles[i] = excludedFiles[i].trim();
                }
                verificationCode = new SpdxPackageVerificationCode(verification[0].trim(), excludedFiles);
            } else {
                verificationCode = new SpdxPackageVerificationCode(value, new String[0]);
            }
            this.verifyElement(verificationCode.verify(), "Verification Code", lineNumber);
            pkg.setPackageVerificationCode(verificationCode);
            return;
        } else if (this.constants.getProperty("PROP_PACKAGE_CHECKSUM").startsWith(tag)) {
            Checksum checksum = BuildDocument.parseChecksum(value, lineNumber);
            this.verifyElement(checksum.verify(), "Package Checksum", lineNumber);
            pkg.addChecksum(checksum);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_HOMEPAGE_URL"))) {
            pkg.setHomepage(value);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_SOURCE_INFO"))) {
            pkg.setSourceInfo(value);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_CONCLUDED_LICENSE"))) {
            AnyLicenseInfo licenseSet = LicenseInfoFactory.parseSPDXLicenseString(value, this.analysis.getDocumentContainer());
            pkg.setLicenseConcluded(licenseSet);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_LICENSE_INFO_FROM_FILES"))) {
            AnyLicenseInfo license = LicenseInfoFactory.parseSPDXLicenseString(value, this.analysis.getDocumentContainer());
            ArrayList licenses = Lists.newArrayList((Object[])pkg.getLicenseInfoFromFiles());
            licenses.add(license);
            pkg.setLicenseInfosFromFiles(licenses.toArray(new AnyLicenseInfo[0]));
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DECLARED_LICENSE"))) {
            AnyLicenseInfo licenseSet = LicenseInfoFactory.parseSPDXLicenseString(value, this.analysis.getDocumentContainer());
            pkg.setLicenseDeclared(licenseSet);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_LICENSE_COMMENT"))) {
            pkg.setLicenseComments(value);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DECLARED_COPYRIGHT"))) {
            pkg.setCopyrightText(value);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_SHORT_DESC"))) {
            pkg.setSummary(value);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DESCRIPTION"))) {
            pkg.setDescription(value);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_EXTERNAL_REFERENCE"))) {
            this.lastExternalRef = this.parseExternalRef(value, lineNumber);
            this.verifyElement(this.lastExternalRef.verify(), "External Reference", lineNumber);
            pkg.addExternalRef(this.lastExternalRef);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_EXTERNAL_REFERENCE_COMMENT"))) {
            if (this.lastExternalRef == null) {
                throw new InvalidSpdxTagFileException("External reference comment found without an external reference: " + value + " at line number " + lineNumber);
            }
            if (this.lastExternalRef.getComment() != null && !this.lastExternalRef.getComment().isEmpty()) {
                throw new InvalidSpdxTagFileException("Second reference comment found for the same external reference: " + value + " at line number " + lineNumber);
            }
            this.lastExternalRef.setComment(value);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_ANNOTATOR"))) {
            if (this.lastAnnotation != null) {
                this.annotations.add(this.lastAnnotation);
            }
            this.inAnnotation = true;
            this.lastAnnotation = new AnnotationWithId(value, lineNumber);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_RELATIONSHIP"))) {
            if (this.lastRelationship != null) {
                this.relationships.add(this.lastRelationship);
            }
            this.lastRelationship = this.parseRelationship(value, lineNumber);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_RELATIONSHIP_COMMENT"))) {
            if (this.lastRelationship == null) {
                throw new InvalidSpdxTagFileException("Relationship comment found outside of a relationship: " + value + " at line number " + lineNumber);
            }
            this.lastRelationship.setComment(value);
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_NAME"))) {
            this.addLastFile();
            this.lastFile = new SpdxFile(value, null, new Annotation[0], new Relationship[0], null, new AnyLicenseInfo[0], null, null, new SpdxFile.FileType[0], new Checksum[0], new String[0], null, new DoapProject[0]);
            this.inFileDefinition = true;
            this.inSnippetDefinition = false;
            this.inAnnotation = false;
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_SPDX_ID"))) {
            this.addLastSnippet();
            this.inSnippetDefinition = true;
            this.inFileDefinition = false;
            this.inPackageDefinition = false;
            this.inAnnotation = false;
            this.lastSnippet = new SpdxSnippet(null, null, new Annotation[0], new Relationship[0], null, new AnyLicenseInfo[0], null, null, null, null, null);
            this.lastSnippet.setId(value);
            this.lastSnippetLineNumber = lineNumber;
            return;
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_COMMENT"))) {
            pkg.setComment(value);
            return;
        } else {
            if (!tag.equals(this.constants.getProperty("PROP_PACKAGE_FILES_ANALYZED"))) throw new InvalidSpdxTagFileException("Expecting a file definition, snippet definition or a package property.  Found " + value + " at line number " + lineNumber);
            if ("TRUE".equals(value.toUpperCase())) {
                pkg.setFilesAnalyzed(true);
                return;
            } else {
                if (!"FALSE".equals(value.toUpperCase())) throw new InvalidSpdxTagFileException("Invalid value for files analyzed.  Must be 'true' or 'false'.  Found value: " + value + " at line number " + lineNumber);
                pkg.setFilesAnalyzed(false);
            }
        }
    }

    private ExternalRef parseExternalRef(String value, int lineNumber) throws InvalidSpdxTagFileException, InvalidSPDXAnalysisException {
        Matcher matcher = EXTERNAL_REF_PATTERN.matcher(value);
        if (!matcher.find()) {
            throw new InvalidSpdxTagFileException("Invalid External Ref format: " + value + " at line number " + lineNumber);
        }
        ExternalRef.ReferenceCategory referenceCategory = ExternalRef.ReferenceCategory.fromTag(matcher.group(1).trim());
        if (referenceCategory == null) {
            throw new InvalidSpdxTagFileException("Invalid External Ref category: " + value + " at line number " + lineNumber);
        }
        ReferenceType referenceType = null;
        String tagType = matcher.group(2).trim();
        try {
            referenceType = ListedReferenceTypes.getListedReferenceTypes().getListedReferenceTypeByName(tagType);
        }
        catch (InvalidSPDXAnalysisException e) {
            referenceType = null;
        }
        if (referenceType == null) {
            try {
                URI refTypeUri = null;
                refTypeUri = tagType.contains("/") || tagType.contains(":") ? new URI(tagType) : new URI(this.result[0].getDocumentNamespace() + matcher.group(2).trim());
                referenceType = new ReferenceType(refTypeUri, null, null, null);
            }
            catch (URISyntaxException e) {
                throw new InvalidSpdxTagFileException("Invalid External Ref type: " + value + " at line number " + lineNumber);
            }
        }
        return new ExternalRef(referenceCategory, referenceType, matcher.group(3), null);
    }

    public static Checksum parseChecksum(String value, int lineNumber) throws InvalidSpdxTagFileException {
        Matcher matcher = CHECKSUM_PATTERN.matcher(value.trim());
        if (!matcher.find()) {
            throw new InvalidSpdxTagFileException("Invalid checksum: " + value + " at line number " + lineNumber);
        }
        Checksum.ChecksumAlgorithm algorithm = (Checksum.ChecksumAlgorithm)((Object)Checksum.CHECKSUM_TAG_TO_ALGORITHM.get((Object)matcher.group(1)));
        if (algorithm == null) {
            throw new InvalidSpdxTagFileException("Invalid checksum algorithm: " + value + " at line number " + lineNumber);
        }
        return new Checksum(algorithm, matcher.group(2));
    }

    private void buildFile(SpdxFile file, String tag, String value, int lineNumber) throws Exception {
        if (file == null) {
            if (this.FILE_TAGS.contains(tag)) {
                throw new InvalidSpdxTagFileException("Missing File Name - A file name must be specified before the file properties at line number " + lineNumber);
            }
            throw new InvalidSpdxTagFileException("Unrecognized SPDX Tag: " + tag + " at line number " + lineNumber);
        }
        if (tag.equals(this.constants.getProperty("PROP_ELEMENT_ID"))) {
            file.setId(value);
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_TYPE"))) {
            SpdxFile.FileType fileType = SpdxFile.FileType.fromTag(value.trim());
            if (fileType == null) {
                fileType = SpdxFile.FileType.fromTag(value.trim().toUpperCase());
                if (fileType == null) {
                    throw new InvalidSpdxTagFileException("Unknown file type: " + value + " at line number " + lineNumber);
                }
                this.warningMessages.add("Invalid filetype - needs to be uppercased: " + value + " at line number " + lineNumber);
            }
            file.addFileType(fileType);
        } else if (this.constants.getProperty("PROP_FILE_CHECKSUM").startsWith(tag)) {
            file.addChecksum(BuildDocument.parseChecksum(value, lineNumber));
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_LICENSE"))) {
            AnyLicenseInfo licenseSet = LicenseInfoFactory.parseSPDXLicenseString(value, this.analysis.getDocumentContainer());
            file.setLicenseConcluded(licenseSet);
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_SEEN_LICENSE"))) {
            AnyLicenseInfo fileLicense = LicenseInfoFactory.parseSPDXLicenseString(value, this.analysis.getDocumentContainer());
            ArrayList seenLicenses = Lists.newArrayList((Object[])file.getLicenseInfoFromFiles());
            seenLicenses.add(fileLicense);
            file.setLicenseInfosFromFiles(seenLicenses.toArray(new AnyLicenseInfo[0]));
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_LIC_COMMENTS"))) {
            file.setLicenseComments(value);
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_COPYRIGHT"))) {
            file.setCopyrightText(value);
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_COMMENT"))) {
            file.setComment(value);
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_NOTICE_TEXT"))) {
            file.setNoticeText(value);
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_CONTRIBUTOR"))) {
            this.addFileContributor(file, value);
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_DEPENDENCY"))) {
            this.addFileDependency(file, value);
        } else if (tag.equals(this.constants.getProperty("PROP_ANNOTATOR"))) {
            if (this.lastAnnotation != null) {
                this.annotations.add(this.lastAnnotation);
            }
            this.inAnnotation = true;
            this.lastAnnotation = new AnnotationWithId(value, lineNumber);
        } else if (tag.equals(this.constants.getProperty("PROP_RELATIONSHIP"))) {
            if (this.lastRelationship != null) {
                this.relationships.add(this.lastRelationship);
            }
            this.lastRelationship = this.parseRelationship(value, lineNumber);
        } else if (tag.equals(this.constants.getProperty("PROP_RELATIONSHIP_COMMENT"))) {
            if (this.lastRelationship == null) {
                throw new InvalidSpdxTagFileException("Relationship comment found outside of a relationship: " + value + " at line number " + lineNumber);
            }
            this.lastRelationship.setComment(value);
        } else {
            this.buildProject(file, tag, value, lineNumber);
        }
    }

    private void addFileContributor(SpdxFile file, String contributor) {
        String[] contributors = file.getFileContributors();
        if (contributors == null) {
            contributors = new String[]{contributor};
        } else {
            contributors = Arrays.copyOf(contributors, contributors.length + 1);
            contributors[contributors.length - 1] = contributor;
        }
        file.setFileContributors(contributors);
    }

    private void addFileDependency(SpdxFile file, String dependentFileName) {
        ArrayList filesWithThisAsADependency = this.fileDependencyMap.get(dependentFileName);
        if (filesWithThisAsADependency == null) {
            filesWithThisAsADependency = Lists.newArrayList();
            this.fileDependencyMap.put(dependentFileName, filesWithThisAsADependency);
        }
        filesWithThisAsADependency.add(file);
    }

    private void buildProject(SpdxFile file, String tag, String value, int lineNumber) throws Exception {
        if (tag.equals(this.constants.getProperty("PROP_PROJECT_NAME"))) {
            if (this.lastProject != null) {
                this.verifyElement(this.lastProject.verify(), "DOAP Project", this.lastProjectLineNumber);
            }
            this.lastProject = new DoapProject(value, null);
            this.lastProjectLineNumber = lineNumber;
            ArrayList projects = Lists.newArrayList((Object[])file.getArtifactOf());
            projects.add(this.lastProject);
            file.setArtifactOf(projects.toArray(new DoapProject[0]));
        } else if (tag.equals(this.constants.getProperty("PROP_PROJECT_HOMEPAGE"))) {
            if (this.lastProject == null) {
                throw new InvalidSpdxTagFileException("Missing Project Name - A project name must be provided before the project properties at line number" + lineNumber);
            }
            this.lastProject.setHomePage(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PROJECT_URI"))) {
            int i;
            if (this.lastProject == null) {
                throw new InvalidSpdxTagFileException("Missing Project Name - A project name must be provided before the project properties at line number" + lineNumber);
            }
            DoapProject[] existingProjects = file.getArtifactOf();
            for (i = 0; i < existingProjects.length && !existingProjects[i].equals(this.lastProject); ++i) {
            }
            if (i >= existingProjects.length) {
                existingProjects = Arrays.copyOf(existingProjects, existingProjects.length + 1);
            }
            existingProjects[i] = new DoapProject(this.lastProject.getName(), this.lastProject.getHomePage());
            existingProjects[i].setProjectUri(value);
            file.setArtifactOf(existingProjects);
            this.lastProject = existingProjects[i];
        } else {
            throw new InvalidSpdxTagFileException("Unrecognized tag: " + tag + " at line number" + lineNumber);
        }
    }

    private static String trim(String value) {
        value = value.replaceAll("\u00a0", " ");
        value = value.trim();
        value = value.replaceAll("<text>", "").replaceAll("</text>", "");
        return value;
    }

    @Override
    public void exit() throws Exception {
        if (this.inExtractedLicenseDefinition && this.lastExtractedLicense != null) {
            this.verifyElement(this.lastExtractedLicense.verify(), "Extracted License", this.lastExtractedLicenseLineNumber, false);
        }
        this.addLastFile();
        if (this.lastPackage != null) {
            this.analysis.getDocumentContainer().addElement(this.lastPackage);
            this.elementIdLineNumberMap.put(this.lastPackage.getId(), this.lastPackageLineNumber);
        }
        this.fixFileAndSnippetDependencies();
        this.addRelationships();
        this.checkSinglePackageDefault();
        this.addAnnotations();
        List<SpdxElement> allElements = this.analysis.getDocumentContainer().findAllElements();
        for (SpdxElement element : allElements) {
            if (!this.elementIdLineNumberMap.containsKey(element.getId())) continue;
            String prefix = "Element";
            if (element instanceof SpdxPackage) {
                prefix = "Package";
            } else if (element instanceof SpdxSnippet) {
                prefix = "Snippet";
            } else if (element instanceof SpdxFile) {
                prefix = "File";
            }
            this.verifyElement(element.verify(), prefix, this.elementIdLineNumberMap.get(element.getId()));
        }
        List<String> analysisVerify = this.analysis.verify();
        for (String analysisVerifyMsg : analysisVerify) {
            boolean found = false;
            for (String warningMsg : this.warningMessages) {
                if (!warningMsg.contains(analysisVerifyMsg)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.warningMessages.add(analysisVerifyMsg);
        }
    }

    private void checkSinglePackageDefault() throws InvalidSPDXAnalysisException, InvalidSpdxTagFileException {
        Relationship[] documentRelationships = this.analysis.getRelationships();
        for (int i = 0; i < documentRelationships.length; ++i) {
            if (documentRelationships[i].getRelationshipType() != Relationship.RelationshipType.DESCRIBES) continue;
            return;
        }
        List<SpdxPackage> pkgs = this.analysis.getDocumentContainer().findAllPackages();
        if (pkgs.size() == 0) {
            throw new InvalidSpdxTagFileException("Missing describes relationship and there is no package to create a default - see SPDX specification relationship section under DESCRIBES relationship description for more information");
        }
        Relationship describesRelationship = new Relationship(pkgs.get(0), Relationship.RelationshipType.DESCRIBES, "This describes relationship was added as a default relationship by the SPDX Tools Tag parser.");
        this.analysis.addRelationship(describesRelationship);
    }

    private void addAnnotations() throws InvalidSPDXAnalysisException {
        if (this.lastAnnotation != null) {
            this.annotations.add(this.lastAnnotation);
            this.lastAnnotation = null;
        }
        for (int i = 0; i < this.annotations.size(); ++i) {
            String id = this.annotations.get(i).getId();
            if (id == null) {
                this.warningMessages.add("missing SPDXREF: tag in annotation " + this.annotations.get(i).getAnnotation().getComment() + " at line number " + this.annotations.get(i).getLineNumber());
                continue;
            }
            SpdxElement element = this.analysis.getDocumentContainer().findElementById(id);
            if (element == null) {
                this.warningMessages.add("Invalid element reference in annotation: " + id + " at line number " + this.annotations.get(i).getLineNumber());
                continue;
            }
            Annotation[] elementAnnotations = element.getAnnotations();
            if (elementAnnotations == null) {
                elementAnnotations = new Annotation[]{};
            }
            Annotation[] newAnnotations = Arrays.copyOf(elementAnnotations, elementAnnotations.length + 1);
            newAnnotations[elementAnnotations.length] = this.annotations.get(i).getAnnotation();
            this.verifyElement(this.annotations.get(i).getAnnotation().verify(), "Annotation", this.annotations.get(i).getLineNumber());
            element.setAnnotations(newAnnotations);
        }
    }

    private void addRelationships() throws InvalidSPDXAnalysisException {
        if (this.lastRelationship != null) {
            this.relationships.add(this.lastRelationship);
            this.lastRelationship = null;
        }
        for (int i = 0; i < this.relationships.size(); ++i) {
            RelationshipWithId relationship = this.relationships.get(i);
            SpdxElement element = this.analysis.getDocumentContainer().findElementById(relationship.getId());
            if (element == null) {
                this.warningMessages.add("Missing element for a relationship.  SPDX ID: " + relationship.getId() + " at line number " + relationship.getLineNumber());
                continue;
            }
            SpdxElement relatedElement = this.analysis.getDocumentContainer().findElementById(relationship.getRelatedId());
            element.getRelationships();
            Relationship newRelationship = new Relationship(relatedElement, this.relationships.get(i).getRelationshipType(), this.relationships.get(i).getComment());
            this.verifyElement(newRelationship.verify(), "Relationship", this.relationships.get(i).getLineNumber());
            element.addRelationship(newRelationship);
        }
    }

    private void fixFileAndSnippetDependencies() throws InvalidSPDXAnalysisException, InvalidSpdxTagFileException, InvalidFileFormatException {
        Set<String> missingSnippetFileIds;
        HashMap filesWithDependencies = Maps.newHashMap();
        HashMap filesWithSnippets = Maps.newHashMap();
        this.checkAnalysisNull();
        SpdxFile[] allFiles = this.analysis.getDocumentContainer().getFileReferences();
        for (int i = 0; i < allFiles.length; ++i) {
            List<SpdxSnippet> alSnippetsWithThisFile;
            List<SpdxFile> alFilesHavingThisDependency = this.fileDependencyMap.get(allFiles[i].getName());
            if (alFilesHavingThisDependency != null) {
                for (int j = 0; j < alFilesHavingThisDependency.size(); ++j) {
                    SpdxFile fileWithDependency = alFilesHavingThisDependency.get(j);
                    Object alDepdenciesForThisFile = (List)filesWithDependencies.get(fileWithDependency);
                    if (alDepdenciesForThisFile == null) {
                        alDepdenciesForThisFile = Lists.newArrayList();
                        filesWithDependencies.put(fileWithDependency, alDepdenciesForThisFile);
                    }
                    alDepdenciesForThisFile.add(allFiles[i]);
                }
                this.fileDependencyMap.remove(allFiles[i].getName());
            }
            if ((alSnippetsWithThisFile = this.snippetDependencyMap.get(allFiles[i].getId())) != null) {
                ArrayList snippets = Lists.newArrayList();
                filesWithSnippets.put(allFiles[i], snippets);
                for (SpdxSnippet snippet : alSnippetsWithThisFile) {
                    snippets.add(snippet);
                }
            }
            this.snippetDependencyMap.remove(allFiles[i].getId());
        }
        for (Map.Entry entry : filesWithDependencies.entrySet()) {
            List alDependencies = (List)entry.getValue();
            if (alDependencies == null || alDependencies.size() <= 0) continue;
            ((SpdxFile)entry.getKey()).setFileDependencies(alDependencies.toArray(new SpdxFile[alDependencies.size()]));
        }
        for (Map.Entry entry : filesWithSnippets.entrySet()) {
            List alSnippets = (List)entry.getValue();
            if (alSnippets == null) continue;
            for (SpdxSnippet snippet : alSnippets) {
                snippet.setSnippetFromFile((SpdxFile)entry.getKey());
            }
        }
        Set<String> missingDependencies = this.fileDependencyMap.keySet();
        if (missingDependencies != null && missingDependencies.size() > 0) {
            this.warningMessages.add("The following file names were listed as file dependencies but were not found in the list of files:");
            Iterator<String> missingIter = missingDependencies.iterator();
            while (missingIter.hasNext()) {
                this.warningMessages.add("\t" + missingIter.next());
            }
        }
        if ((missingSnippetFileIds = this.snippetDependencyMap.keySet()) != null && missingSnippetFileIds.size() > 0) {
            this.warningMessages.add("The following file IDs were listed as files for snippets but were not found in the list of files:");
            Iterator<String> missingIter = missingDependencies.iterator();
            while (missingIter.hasNext()) {
                this.warningMessages.add("\t" + missingIter.next());
            }
        }
    }

    private static class RelationshipWithId {
        private String id;
        private String relatedId;
        private Relationship.RelationshipType relationshipType;
        private String comment;
        private int lineNumber;

        public RelationshipWithId(String id, String relatedId, Relationship.RelationshipType relationshipType, int lineNumber) {
            this.id = id;
            this.relatedId = relatedId;
            this.relationshipType = relationshipType;
            this.lineNumber = lineNumber;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getId() {
            return this.id;
        }

        public String getRelatedId() {
            return this.relatedId;
        }

        public Relationship.RelationshipType getRelationshipType() {
            return this.relationshipType;
        }

        public String getComment() {
            return this.comment;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }

    private static class AnnotationWithId {
        private Annotation annotation;
        private String id;
        private int lineNumber;

        private AnnotationWithId(String annotator, int lineNumber) {
            this.annotation = new Annotation(annotator, null, null, null);
            this.lineNumber = lineNumber;
        }

        public void setAnnotator(String annotator) {
            this.annotation.setAnnotator(annotator);
        }

        public void setDate(String date) throws InvalidSPDXAnalysisException {
            this.annotation.setAnnotationDate(date);
        }

        public void setAnnotationType(Annotation.AnnotationType annotationType) throws InvalidSPDXAnalysisException {
            this.annotation.setAnnotationType(annotationType);
        }

        public void setComment(String comment) {
            this.annotation.setComment(comment);
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

