/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client.support;

import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.Pool;
import org.springframework.data.gemfire.client.PoolResolver;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SinglePoolPoolResolver
implements PoolResolver {
    private final Pool pool;

    public static SinglePoolPoolResolver from(@NonNull ClientCache clientCache) {
        Assert.notNull((Object)clientCache, (String)"ClientCache must not be null");
        return new SinglePoolPoolResolver(clientCache.getDefaultPool());
    }

    public SinglePoolPoolResolver(@NonNull Pool pool) {
        Assert.notNull((Object)pool, (String)"Pool must not be null");
        this.pool = pool;
    }

    @NonNull
    protected Pool getPool() {
        return this.pool;
    }

    @Override
    @Nullable
    public Pool resolve(@Nullable String poolName) {
        Pool pool = this.getPool();
        return pool.getName().equals(poolName) ? pool : null;
    }
}

