/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation.support;

import javax.naming.NamingException;
import org.apache.geode.ra.GFConnectionFactory;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.gemfire.config.annotation.support.AbstractGemFireAsLastResourceAspectSupport;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;

@Aspect
public class GemFireAsLastResourceConnectionAcquiringAspect
extends AbstractGemFireAsLastResourceAspectSupport {
    private static final int DEFAULT_ORDER = 2048000;
    @Autowired(required=false)
    private GFConnectionFactory gemfireConnectionFactory;

    @Before(value="atTransactionalType() || atTransactionalMethod()")
    public void doGemFireConnectionFactoryGetConnection() {
        this.logTraceInfo("Acquiring GemFire Connection from GemFire JCA ResourceAdapter registered at [%s]...", this.resolveGemFireJcaResourceAdapterJndiName());
        AbstractGemFireAsLastResourceAspectSupport.GemFireConnectionHolder.acquire(this.resolveGemFireConnectionFactory(), this.isThrowOnError(), x$0 -> this.logError((String)x$0, new Object[0]));
    }

    synchronized GFConnectionFactory resolveGemFireConnectionFactory() {
        GFConnectionFactory connectionFactory = this.getGemFireConnectionFactory();
        if (connectionFactory == null) {
            String resolvedGemFireJcaResourceAdapterJndiName = this.resolveGemFireJcaResourceAdapterJndiName();
            try {
                connectionFactory = this.gemfireConnectionFactory = (GFConnectionFactory)this.resolveContext().lookup(resolvedGemFireJcaResourceAdapterJndiName);
            }
            catch (NamingException cause) {
                throw RuntimeExceptionFactory.newRuntimeException(cause, "Failed to resolve a GFConnectionFactory from the configured JNDI context name [%s]", resolvedGemFireJcaResourceAdapterJndiName);
            }
        }
        return connectionFactory;
    }

    @Override
    protected Integer getDefaultOrder() {
        return 2048000;
    }

    public synchronized GFConnectionFactory getGemFireConnectionFactory() {
        return this.gemfireConnectionFactory;
    }
}

