/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.function.config.AbstractFunctionExecutionBeanDefinitionBuilder;
import org.springframework.data.gemfire.function.config.AbstractFunctionExecutionConfigurationSource;
import org.springframework.data.gemfire.function.config.AnnotationFunctionExecutionConfigurationSource;
import org.springframework.data.gemfire.function.config.FunctionExecutionBeanDefinitionBuilderFactory;
import org.springframework.data.gemfire.function.config.FunctionExecutionConfiguration;
import org.springframework.data.gemfire.function.config.XmlFunctionExecutionConfigurationSource;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class FunctionExecutionBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        AbstractFunctionExecutionConfigurationSource configurationSource = this.newAnnotationBasedFunctionExecutionConfigurationSource(annotationMetadata);
        this.registerBeanDefinitions(configurationSource, registry);
    }

    protected AbstractFunctionExecutionConfigurationSource newAnnotationBasedFunctionExecutionConfigurationSource(AnnotationMetadata annotationMetadata) {
        return new AnnotationFunctionExecutionConfigurationSource(annotationMetadata);
    }

    protected void registerBeanDefinitions(Element element, ParserContext parserContext) {
        AbstractFunctionExecutionConfigurationSource configurationSource = this.newXmlBasedFunctionExecutionConfigurationSource(element, parserContext);
        this.registerBeanDefinitions(configurationSource, parserContext.getRegistry());
    }

    protected AbstractFunctionExecutionConfigurationSource newXmlBasedFunctionExecutionConfigurationSource(Element element, ParserContext parserContext) {
        return new XmlFunctionExecutionConfigurationSource(element, parserContext);
    }

    void registerBeanDefinitions(AbstractFunctionExecutionConfigurationSource functionExecutionConfigurationSource, BeanDefinitionRegistry registry) {
        Set<String> functionExecutionAnnotationTypeNames = AbstractFunctionExecutionConfigurationSource.getFunctionExecutionAnnotationTypeNames();
        for (ScannedGenericBeanDefinition beanDefinition : functionExecutionConfigurationSource.getCandidates((ResourceLoader)new DefaultResourceLoader())) {
            String functionExecutionAnnotation = Optional.ofNullable(this.getFunctionExecutionAnnotation(beanDefinition, functionExecutionAnnotationTypeNames)).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("No Function Execution Annotation [%1$s] found for type [%2$s]", functionExecutionAnnotationTypeNames, beanDefinition.getBeanClassName()));
            String beanName = Optional.of(beanDefinition.getMetadata()).map(annotationMetadata -> annotationMetadata.getAnnotationAttributes(functionExecutionAnnotation)).map(AnnotationAttributes::fromMap).map(annotationAttributes -> annotationAttributes.getString("id")).filter(StringUtils::hasText).orElseGet(() -> BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry));
            AbstractFunctionExecutionBeanDefinitionBuilder builder = FunctionExecutionBeanDefinitionBuilderFactory.newInstance(new FunctionExecutionConfiguration(beanDefinition, functionExecutionAnnotation));
            registry.registerBeanDefinition(beanName, builder.build(registry));
        }
    }

    private String getFunctionExecutionAnnotation(ScannedGenericBeanDefinition beanDefinition, Set<String> functionExecutionAnnotationTypeNames) {
        String existingFunctionExecutionAnnotation = null;
        for (String annotationType : beanDefinition.getMetadata().getAnnotationTypes()) {
            if (!functionExecutionAnnotationTypeNames.contains(annotationType)) continue;
            Assert.isNull(existingFunctionExecutionAnnotation, (String)String.format("Interface [%1$s] contains multiple Function Execution Annotations: %2$s, %3$s", beanDefinition.getBeanClassName(), existingFunctionExecutionAnnotation, annotationType));
            existingFunctionExecutionAnnotation = annotationType;
        }
        return existingFunctionExecutionAnnotation;
    }
}

