/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.gemfire.function.GemfireFunctionUtils;
import org.springframework.data.gemfire.function.annotation.GemfireFunction;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class GemfireFunctionBeanPostProcessor
implements BeanPostProcessor {
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.registerAnyDeclaredGemfireFunctionAnnotatedMethods(bean);
        return bean;
    }

    private void registerAnyDeclaredGemfireFunctionAnnotatedMethods(Object bean) {
        Arrays.stream(ArrayUtils.nullSafeArray(ReflectionUtils.getAllDeclaredMethods(bean.getClass()), Method.class)).forEach(method -> {
            GemfireFunction gemfireFunctionAnnotation = (GemfireFunction)AnnotationUtils.getAnnotation((Method)method, GemfireFunction.class);
            if (gemfireFunctionAnnotation != null) {
                Assert.isTrue((boolean)Modifier.isPublic(method.getModifiers()), (String)String.format("The bean [%s] method [%s] annotated with [%s] must be public", bean.getClass().getName(), method.getName(), GemfireFunction.class.getName()));
                AnnotationAttributes gemfireFunctionAttributes = this.resolveAnnotationAttributes(gemfireFunctionAnnotation);
                GemfireFunctionUtils.registerFunctionForPojoMethod(bean, method, gemfireFunctionAttributes, false);
            }
        });
    }

    private AnnotationAttributes resolveAnnotationAttributes(Annotation annotation) {
        return AnnotationAttributes.fromMap((Map)AnnotationUtils.getAnnotationAttributes((Annotation)annotation, (boolean)false, (boolean)true));
    }
}

