/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.wan;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayReceiverFactory;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.gemfire.config.annotation.GatewayReceiverConfigurer;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.wan.AbstractWANComponentFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GatewayReceiverFactoryBean
extends AbstractWANComponentFactoryBean<GatewayReceiver> {
    private boolean manualStart = false;
    private volatile GatewayReceiver gatewayReceiver;
    private Integer endPort;
    private Integer maximumTimeBetweenPings;
    private Integer socketBufferSize;
    private Integer startPort;
    @Autowired(required=false)
    private List<GatewayReceiverConfigurer> gatewayReceiverConfigurers;
    @Autowired(required=false)
    private List<GatewayTransportFilter> transportFilters;
    private String bindAddress;
    private String hostnameForSenders;

    public GatewayReceiverFactoryBean(Cache cache) {
        super((GemFireCache)cache);
    }

    @Override
    protected void doInit() {
        GatewayReceiverFactory gatewayReceiverFactory = this.cache.createGatewayReceiverFactory();
        StreamSupport.stream(CollectionUtils.nullSafeIterable(this.gatewayReceiverConfigurers).spliterator(), false).forEach(it -> it.configure(this.getName(), this));
        Optional.ofNullable(this.bindAddress).filter(StringUtils::hasText).ifPresent(arg_0 -> ((GatewayReceiverFactory)gatewayReceiverFactory).setBindAddress(arg_0));
        Optional.ofNullable(this.hostnameForSenders).filter(StringUtils::hasText).ifPresent(arg_0 -> ((GatewayReceiverFactory)gatewayReceiverFactory).setHostnameForSenders(arg_0));
        int localStartPort = this.defaultPort(this.startPort, 5000);
        int localEndPort = this.defaultPort(this.endPort, 5500);
        Assert.isTrue((localStartPort <= localEndPort ? 1 : 0) != 0, (String)String.format("[startPort] must be less than or equal to [%d]", localEndPort));
        gatewayReceiverFactory.setStartPort(localStartPort);
        gatewayReceiverFactory.setEndPort(localEndPort);
        gatewayReceiverFactory.setManualStart(this.manualStart);
        Optional.ofNullable(this.maximumTimeBetweenPings).ifPresent(arg_0 -> ((GatewayReceiverFactory)gatewayReceiverFactory).setMaximumTimeBetweenPings(arg_0));
        Optional.ofNullable(this.socketBufferSize).ifPresent(arg_0 -> ((GatewayReceiverFactory)gatewayReceiverFactory).setSocketBufferSize(arg_0));
        CollectionUtils.nullSafeList(this.transportFilters).forEach(arg_0 -> ((GatewayReceiverFactory)gatewayReceiverFactory).addGatewayTransportFilter(arg_0));
        this.gatewayReceiver = gatewayReceiverFactory.create();
    }

    public GatewayReceiver getObject() throws Exception {
        return this.gatewayReceiver;
    }

    public Class<?> getObjectType() {
        return this.gatewayReceiver != null ? this.gatewayReceiver.getClass() : GatewayReceiver.class;
    }

    protected int defaultPort(Integer port, int defaultPort) {
        return port != null ? port : defaultPort;
    }

    public void setGatewayReceiver(GatewayReceiver gatewayReceiver) {
        this.gatewayReceiver = gatewayReceiver;
    }

    public void setGatewayReceiverConfigurers(List<GatewayReceiverConfigurer> gatewayReceiverConfigurers) {
        this.gatewayReceiverConfigurers = gatewayReceiverConfigurers;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setHostnameForSenders(String hostnameForSenders) {
        this.hostnameForSenders = hostnameForSenders;
    }

    public void setStartPort(Integer startPort) {
        this.startPort = startPort;
    }

    public void setEndPort(Integer endPort) {
        this.endPort = endPort;
    }

    public void setManualStart(Boolean manualStart) {
        this.manualStart = Boolean.TRUE.equals(manualStart);
    }

    public void setMaximumTimeBetweenPings(Integer maximumTimeBetweenPings) {
        this.maximumTimeBetweenPings = maximumTimeBetweenPings;
    }

    public void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public void setTransportFilters(List<GatewayTransportFilter> transportFilters) {
        this.transportFilters = transportFilters;
    }

    public Collection<? extends GatewayTransportFilter> getTransportFilters() {
        return Collections.unmodifiableList(this.transportFilters);
    }
}

