/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.EnableGatewayReceiver;
import org.springframework.data.gemfire.config.annotation.GatewayReceiverConfigurer;
import org.springframework.data.gemfire.config.annotation.LazyResolvingComposableGatewayReceiverConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.wan.GatewayReceiverFactoryBean;

public class GatewayReceiverConfiguration
extends AbstractAnnotationConfigSupport
implements ImportBeanDefinitionRegistrar {
    static final boolean DEFAULT_MANUAL_START = false;
    static final int DEFAULT_START_PORT = 5000;
    static final int DEFAULT_END_PORT = 5500;
    static final int DEFAULT_MAXIMUM_TIME_BETWEEN_PINGS = 60000;
    static final int DEFAULT_SOCKET_BUFFER_SIZE = 524288;
    static final String DEFAULT_BIND_ADDRESS = "";
    static final String DEFAULT_HOSTNAME_FOR_SENDERS = "";
    private final String START_PORT_LITERAL = "startPort";
    private final String END_PORT_LITERAL = "endPort";
    private final String MANUAL_START_LITERAL = "manualStart";
    private final String MAXIMUM_TIME_BETWEEN_PINGS_LITERAL = "maximumTimeBetweenPings";
    private final String SOCKET_BUFFER_SIZE_LITERAL = "socketBufferSize";
    private final String BIND_ADDRESS_LITERAL = "bindAddress";
    private final String HOSTNAME_FOR_SENDERS_LITERAL = "hostnameForSenders";
    private final String TRANSPORT_FILTERS_LITERAL = "transportFilters";
    private final String START_PORT_PROPERTY_LITERAL = "start-port";
    private final String END_PORT_PROPERTY_LITERAL = "end-port";
    private final String MANUAL_START_PROPERTY_LITERAL = "manual-start";
    private final String MAXIMUM_TIME_BETWEEN_PINGS_PROPERTY_LITERAL = "maximum-time-between-pings";
    private final String SOCKET_BUFFER_SIZE_PROPERTY_LITERAL = "socket-buffer-size";
    private final String BIND_ADDRESS_PROPERTY_LITERAL = "bind-address";
    private final String HOSTNAME_FOR_SENDERS_PROPERTY_LITERAL = "hostname-for-senders";
    private final String TRANSPORT_FILTERS_PROPERTY_LITERAL = "transport-filters";
    @Autowired(required=false)
    private List<GatewayReceiverConfigurer> gatewayReceiverConfigurers = Collections.emptyList();

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableGatewayReceiver.class;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (this.isAnnotationPresent(importingClassMetadata)) {
            AnnotationAttributes enableGatewayReceiverAttributes = this.getAnnotationAttributes(importingClassMetadata);
            this.registerGatewayReceiverBeanDefinition(enableGatewayReceiverAttributes, registry);
        }
    }

    private void registerGatewayReceiverBeanDefinition(AnnotationAttributes enableGatewayReceiverAttributes, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder gatewayReceiverBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(GatewayReceiverFactoryBean.class);
        String gatewayReceiverBeanName = "GatewayReceiver";
        this.configureBeanFromAnnotationAttributes(enableGatewayReceiverAttributes, gatewayReceiverBeanBuilder, gatewayReceiverBeanName);
        this.configureBeanFromPropertiesOrWithDefaultValues(gatewayReceiverBeanBuilder);
        this.registerGatewayTransportFilterDependencies(enableGatewayReceiverAttributes, gatewayReceiverBeanBuilder);
        registry.registerBeanDefinition(gatewayReceiverBeanName, (BeanDefinition)gatewayReceiverBeanBuilder.getBeanDefinition());
    }

    private void configureBeanFromAnnotationAttributes(AnnotationAttributes enableGatewayReceiverAttributes, BeanDefinitionBuilder gatewayReceiverBeanBuilder, String gatewayReceiverBeanName) {
        gatewayReceiverBeanBuilder.addConstructorArgReference("gemfireCache");
        gatewayReceiverBeanBuilder.addPropertyValue("beanName", (Object)gatewayReceiverBeanName);
        gatewayReceiverBeanBuilder.addPropertyReference("cache", "gemfireCache");
        this.setPropertyValueIfNotDefault(gatewayReceiverBeanBuilder, "startPort", enableGatewayReceiverAttributes.getNumber("startPort"), 5000);
        this.setPropertyValueIfNotDefault(gatewayReceiverBeanBuilder, "endPort", enableGatewayReceiverAttributes.getNumber("endPort"), 5500);
        this.setPropertyValueIfNotDefault(gatewayReceiverBeanBuilder, "manualStart", enableGatewayReceiverAttributes.getBoolean("manualStart"), false);
        this.setPropertyValueIfNotDefault(gatewayReceiverBeanBuilder, "maximumTimeBetweenPings", enableGatewayReceiverAttributes.getNumber("maximumTimeBetweenPings"), 60000);
        this.setPropertyValueIfNotDefault(gatewayReceiverBeanBuilder, "socketBufferSize", enableGatewayReceiverAttributes.getNumber("socketBufferSize"), 524288);
        this.setPropertyValueIfNotDefault(gatewayReceiverBeanBuilder, "bindAddress", enableGatewayReceiverAttributes.getString("bindAddress"), "");
        this.setPropertyValueIfNotDefault(gatewayReceiverBeanBuilder, "hostnameForSenders", enableGatewayReceiverAttributes.getString("hostnameForSenders"), "");
        this.setPropertyValueIfNotDefault(gatewayReceiverBeanBuilder, "transportFilters", this.resolveGatewayTransportFilterBeanReferences(enableGatewayReceiverAttributes.getStringArray("transportFilters")), new ManagedList());
    }

    private void configureBeanFromPropertiesOrWithDefaultValues(BeanDefinitionBuilder gatewayReceiverBeanBuilder) {
        MutablePropertyValues beanPropertyValues = gatewayReceiverBeanBuilder.getRawBeanDefinition().getPropertyValues();
        gatewayReceiverBeanBuilder.addPropertyValue("gatewayReceiverConfigurers", this.resolveGatewayReceiverConfigurers());
        this.configureFromProperties(gatewayReceiverBeanBuilder, "bindAddress", "bind-address", String.class, (String)beanPropertyValues.getPropertyValue("bindAddress").getValue());
        this.configureFromProperties(gatewayReceiverBeanBuilder, "hostnameForSenders", "hostname-for-senders", String.class, (String)beanPropertyValues.getPropertyValue("hostnameForSenders").getValue());
        this.configureFromProperties(gatewayReceiverBeanBuilder, "manualStart", "manual-start", Boolean.class, (Boolean)beanPropertyValues.getPropertyValue("manualStart").getValue());
        this.configureFromProperties(gatewayReceiverBeanBuilder, "maximumTimeBetweenPings", "maximum-time-between-pings", Integer.class, (Integer)beanPropertyValues.getPropertyValue("maximumTimeBetweenPings").getValue());
        this.configureFromProperties(gatewayReceiverBeanBuilder, "startPort", "start-port", Integer.class, (Integer)beanPropertyValues.getPropertyValue("startPort").getValue());
        this.configureFromProperties(gatewayReceiverBeanBuilder, "endPort", "end-port", Integer.class, (Integer)beanPropertyValues.getPropertyValue("endPort").getValue());
        this.configureFromProperties(gatewayReceiverBeanBuilder, "socketBufferSize", "socket-buffer-size", Integer.class, (Integer)beanPropertyValues.getPropertyValue("socketBufferSize").getValue());
        String[] filters = this.resolveProperty(this.gatewayReceiverProperty("transport-filters"), String[].class);
        Optional.ofNullable(filters).ifPresent(transportFilters -> {
            ManagedList<BeanReference> beanReferences = this.resolveGatewayTransportFilterBeanReferences((String[])transportFilters);
            gatewayReceiverBeanBuilder.addPropertyValue("transportFilters", beanReferences);
        });
    }

    private <T> void configureFromProperties(BeanDefinitionBuilder gatewayReceiverBeanBuilder, String beanPropertyName, String propertyName, Class<T> propertyType, T annotationAttributeValue) {
        T propertyValue = this.resolveProperty(this.gatewayReceiverProperty(propertyName), propertyType, annotationAttributeValue);
        gatewayReceiverBeanBuilder.addPropertyValue(beanPropertyName, propertyValue);
    }

    private List<GatewayReceiverConfigurer> resolveGatewayReceiverConfigurers() {
        return Optional.ofNullable(this.gatewayReceiverConfigurers).filter(gatewayReceiverConfigurers -> !gatewayReceiverConfigurers.isEmpty()).orElseGet(() -> Collections.singletonList(LazyResolvingComposableGatewayReceiverConfigurer.create(this.getBeanFactory())));
    }

    private ManagedList<BeanReference> resolveGatewayTransportFilterBeanReferences(String[] gatewayTransportFilterBeanNames) {
        ManagedList gatewayTransportFilterBeanReferences = new ManagedList();
        Optional.ofNullable(gatewayTransportFilterBeanNames).ifPresent(it -> Arrays.stream(it).map(RuntimeBeanReference::new).forEach(arg_0 -> gatewayTransportFilterBeanReferences.add(arg_0)));
        return gatewayTransportFilterBeanReferences;
    }

    private void registerGatewayTransportFilterDependencies(AnnotationAttributes annotationAttributes, BeanDefinitionBuilder gatewayReceiverBeanBuilder) {
        String[] transportFilters = annotationAttributes.getStringArray("transportFilters");
        Optional.ofNullable(transportFilters).ifPresent(transportFilerBeanNames -> Arrays.stream(transportFilerBeanNames).forEach(arg_0 -> ((BeanDefinitionBuilder)gatewayReceiverBeanBuilder).addDependsOn(arg_0)));
    }

    private <T> BeanDefinitionBuilder setPropertyValueIfNotDefault(BeanDefinitionBuilder beanDefinitionBuilder, String propertyName, T value, T defaultValue) {
        return value != null ? beanDefinitionBuilder.addPropertyValue(propertyName, value) : beanDefinitionBuilder.addPropertyValue(propertyName, defaultValue);
    }
}

