/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.schema.definitions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Optional;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.Index;
import org.springframework.data.gemfire.IndexType;
import org.springframework.data.gemfire.config.admin.GemfireAdminOperations;
import org.springframework.data.gemfire.config.schema.SchemaObjectDefinition;
import org.springframework.data.gemfire.config.schema.SchemaObjectType;
import org.springframework.data.gemfire.domain.support.AbstractIndexSupport;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.StringUtils;

public class IndexDefinition
extends SchemaObjectDefinition {
    protected static final int ORDER = 2;
    private transient Index index;
    private IndexType indexType;
    private String expression;
    private String fromClause;
    private String name;

    public static IndexDefinition from(Index index) {
        return new IndexDefinition(index);
    }

    protected IndexDefinition(Index index) {
        super(Optional.ofNullable(index).map(Index::getName).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Index is required", new Object[0])));
        this.index = index;
    }

    protected Index getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return Optional.ofNullable(this.name).filter(StringUtils::hasText).orElseGet(() -> super.getName());
    }

    public String getExpression() {
        return Optional.ofNullable(this.expression).filter(StringUtils::hasText).orElseGet(() -> ((Index)this.index).getIndexedExpression());
    }

    public String getFromClause() {
        return Optional.ofNullable(this.fromClause).filter(StringUtils::hasText).orElseGet(() -> ((Index)this.index).getFromClause());
    }

    public IndexType getIndexType() {
        return Optional.ofNullable(this.indexType).orElseGet(() -> IndexType.valueOf(this.index.getType()));
    }

    public int getOrder() {
        return 2;
    }

    @Override
    public SchemaObjectType getType() {
        return SchemaObjectType.INDEX;
    }

    @Override
    public void create(GemfireAdminOperations gemfireAdminOperations) {
        gemfireAdminOperations.createIndex(this);
    }

    public IndexDefinition as(org.apache.geode.cache.query.IndexType gemfireGeodeIndexType) {
        return this.as(IndexType.valueOf(gemfireGeodeIndexType));
    }

    public IndexDefinition as(IndexType indexType) {
        this.indexType = indexType;
        return this;
    }

    public IndexDefinition having(String expression) {
        this.expression = Optional.ofNullable(expression).filter(StringUtils::hasText).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Expression is required", new Object[0]));
        return this;
    }

    public IndexDefinition on(Region<?, ?> region) {
        return this.on(Optional.ofNullable(region).map(Region::getFullPath).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Region is required", new Object[0])));
    }

    public IndexDefinition on(String fromClause) {
        this.fromClause = Optional.ofNullable(fromClause).filter(StringUtils::hasText).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("From Clause is required", new Object[0]));
        return this;
    }

    public IndexDefinition with(String name) {
        this.name = name;
        return this;
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.writeUTF(this.getName());
        outputStream.writeUTF(this.getExpression());
        outputStream.writeUTF(this.getFromClause());
        outputStream.writeObject((Object)this.getIndexType());
    }

    private void readObject(ObjectInputStream inputStream) throws ClassNotFoundException, IOException {
        String name = inputStream.readUTF();
        String expression = inputStream.readUTF();
        String fromClause = inputStream.readUTF();
        IndexType indexType = (IndexType)((Object)inputStream.readObject());
        this.index = IndexWrapper.from(name, expression, fromClause, indexType);
    }

    protected static final class IndexWrapper
    extends AbstractIndexSupport {
        private IndexType indexType;
        private final String name;
        private final String expression;
        private final String fromClause;

        protected static Index from(String name, String expression, String fromClause, IndexType indexType) {
            return new IndexWrapper(name, expression, fromClause, indexType);
        }

        protected IndexWrapper(String name, String expression, String fromClause, IndexType indexType) {
            this.name = name;
            this.expression = expression;
            this.fromClause = fromClause;
            this.indexType = indexType;
        }

        @Override
        public String getFromClause() {
            return this.fromClause;
        }

        @Override
        public String getIndexedExpression() {
            return this.expression;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public org.apache.geode.cache.query.IndexType getType() {
            return Optional.ofNullable(this.indexType).map(IndexType::getGemfireIndexType).orElse(null);
        }
    }
}

