/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query.support;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class PagingUtils {
    public static final String INVALID_PAGE_NUMBER_MESSAGE = "Page Number [%d] must be greater than equal to 0";
    public static final String INVALID_PAGE_SIZE_MESSAGE = "Page Size [%d] must be greater than equal to 1";
    public static final String NON_NULL_PAGEABLE_MESSAGE = "Pageable must not be null";
    protected static final Function<QueryMethod, Boolean> DEFAULT_IS_PAGE_QUERY_FUNCTION = QueryMethod::isPageQuery;
    static Function<QueryMethod, Boolean> isPageQueryFunction = DEFAULT_IS_PAGE_QUERY_FUNCTION;
    static Function<QueryMethod, Boolean> hasPageableParameterFunction = queryMethod -> Optional.ofNullable(queryMethod).map(QueryMethod::getParameters).filter(Parameters::hasPageableParameter).isPresent();

    public static void assertPageable(@NonNull Pageable pageable) {
        Assert.notNull((Object)pageable, (String)NON_NULL_PAGEABLE_MESSAGE);
        int pageNumber = pageable.getPageNumber();
        Assert.isTrue((pageNumber >= 0 ? 1 : 0) != 0, () -> String.format(INVALID_PAGE_NUMBER_MESSAGE, pageNumber));
        int pageSize = pageable.getPageSize();
        Assert.isTrue((pageSize > 0 ? 1 : 0) != 0, () -> String.format(INVALID_PAGE_SIZE_MESSAGE, pageSize));
    }

    public static boolean isPageOne(@NonNull Pageable pageable) {
        return pageable != null && pageable.getPageNumber() == 0;
    }

    public static boolean isPagingPresent(@Nullable QueryMethod queryMethod) {
        return queryMethod != null && (isPageQueryFunction.apply(queryMethod) != false || hasPageableParameterFunction.apply(queryMethod) != false);
    }

    @NonNull
    public static <T> List<T> getPagedList(@NonNull List<T> list, @NonNull Pageable pageable) {
        list = CollectionUtils.nullSafeList(list);
        int total = list.size();
        int startIndex = PagingUtils.getQueryResultSetStartIndexForPage(pageable);
        int endIndex = PagingUtils.getQueryResultSetEndIndexForPage(pageable);
        return list.isEmpty() || total <= startIndex ? Collections.emptyList() : list.subList(startIndex, Math.min(total, endIndex));
    }

    @NonNull
    public static Pageable getPageRequest(@NonNull QueryMethod queryMethod, Object ... arguments) {
        Assert.notNull((Object)queryMethod, (String)"QueryMethod must not be null");
        Parameters queryMethodParameters = queryMethod.getParameters();
        Assert.state((boolean)queryMethodParameters.hasPageableParameter(), () -> String.format("QueryMethod [%s] does not have a Pageable parameter", queryMethod));
        arguments = ArrayUtils.nullSafeArray(arguments, Object.class);
        long queryMethodArgumentCount = arguments.length;
        long queryMethodParameterCount = queryMethodParameters.stream().count();
        Assert.isTrue((queryMethodArgumentCount == queryMethodParameterCount ? 1 : 0) != 0, () -> String.format("The number of arguments [%d] must match the number of QueryMethod [%s] parameters [%d]", queryMethodArgumentCount, queryMethod, queryMethodParameterCount));
        int pageableIndex = queryMethodParameters.getPageableIndex();
        Object pageableArgument = arguments[pageableIndex];
        Assert.isInstanceOf(Pageable.class, (Object)pageableArgument, () -> String.format("Argument [%1$s] must be of type [%2$s]", pageableArgument, Pageable.class.getName()));
        return (Pageable)pageableArgument;
    }

    public static int getQueryResultSetStartIndexForPage(@Nullable Pageable pageable) {
        return pageable != null ? pageable.getPageNumber() * pageable.getPageSize() : 0;
    }

    public static int getQueryResultSetEndIndexForPage(@Nullable Pageable pageable) {
        return pageable != null ? PagingUtils.getQueryResultSetStartIndexForPage(pageable) + pageable.getPageSize() : 0;
    }

    public static int getQueryResultSetLimitForPage(@Nullable Pageable pageable) {
        return pageable != null ? PagingUtils.normalizePageNumber(pageable) * pageable.getPageSize() : 0;
    }

    public static int normalizePageNumber(@Nullable Page<?> page) {
        return page != null ? PagingUtils.normalize(page.getNumber()) : 0;
    }

    public static int normalizePageNumber(@Nullable Pageable pageable) {
        return pageable != null ? PagingUtils.normalize(pageable.getPageNumber()) : 0;
    }

    protected static int normalize(int pageNumber) {
        return Math.max(pageNumber, -1) + 1;
    }

    protected static long nullSafeSize(@Nullable Iterable<?> iterable) {
        return iterable == null ? 0L : (iterable instanceof Collection ? (long)((Collection)iterable).size() : StreamSupport.stream(iterable.spliterator(), false).count());
    }

    @NonNull
    public static <T> Page<T> toPage(@NonNull List<T> list, @NonNull Pageable pageable) {
        List<T> pagedList = PagingUtils.getPagedList(list, pageable);
        return pagedList.isEmpty() ? Page.empty() : new PageImpl(pagedList, pageable, PagingUtils.nullSafeSize(list));
    }
}

