/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.springframework.lang.NonNull;

public abstract class GemfireFunctions {
    @NonNull
    public static <K, V> Function<GemFireCache, Region<K, V>> getRegionFromCache(String regionName) {
        return cache -> cache.getRegion(regionName);
    }

    @NonNull
    public static <K, V> Supplier<Region<K, V>> getRegionFromCache(@NonNull GemFireCache cache, String regionName) {
        return () -> cache.getRegion(regionName);
    }

    @NonNull
    public static <K, V> Function<Region<?, ?>, Region<K, V>> getSubregionFromRegion(String regionName) {
        return parentRegion -> parentRegion.getSubregion(regionName);
    }
}

