/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.client.ClientCache;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.gemfire.CacheResolver;
import org.springframework.data.gemfire.client.support.ClientCacheFactoryCacheResolver;
import org.springframework.data.gemfire.support.AbstractFactoryBeanSupport;
import org.springframework.data.gemfire.support.BeanFactoryCacheResolver;
import org.springframework.data.gemfire.support.CacheFactoryCacheResolver;
import org.springframework.data.gemfire.support.ComposableCacheResolver;
import org.springframework.data.gemfire.support.SingleCacheCacheResolver;
import org.springframework.data.gemfire.util.CacheUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.data.gemfire.util.SpringExtensions;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SmartCacheResolverFactoryBean
extends AbstractFactoryBeanSupport<CacheResolver<GemFireCache>>
implements InitializingBean {
    private CacheResolver<GemFireCache> cacheResolver;
    private CompositionStrategy compositionStrategy = CompositionStrategy.DEFAULT;
    private GemFireCache cache;
    private List<CacheResolver> configuredCacheResolvers;
    private String cacheBeanName;

    @NonNull
    public static SmartCacheResolverFactoryBean create() {
        return new SmartCacheResolverFactoryBean();
    }

    public void afterPropertiesSet() {
        this.cacheResolver = this.getCompositionStrategy().use(this);
        Assert.state((this.cacheResolver != null ? 1 : 0) != 0, () -> String.format("No CacheResolver was composed with CompositionStrategy [%s]", new Object[]{this.getCompositionStrategy()}));
    }

    CacheResolver<GemFireCache> getCacheResolver() {
        return this.cacheResolver;
    }

    @NonNull
    public CacheResolver<GemFireCache> getObject() {
        return new CacheResolverProxy();
    }

    @Nullable
    public Class<?> getObjectType() {
        CacheResolver<GemFireCache> cacheResolver = this.getCacheResolver();
        return cacheResolver != null ? cacheResolver.getClass() : CacheResolver.class;
    }

    @Nullable
    protected CacheResolver newBeanFactoryCacheResolver() {
        return Optional.ofNullable(this.getBeanFactory()).map(BeanFactoryCacheResolver::new).map(cacheResolver -> {
            this.getCacheBeanName().ifPresent(cacheResolver::setCacheBeanName);
            return cacheResolver;
        }).orElse(null);
    }

    @NonNull
    protected CacheResolver newClientCacheFactoryCacheResolver() {
        return new ClientCacheFactoryCacheResolver();
    }

    @NonNull
    protected CacheResolver newPeerCacheFactoryCacheResolver() {
        return new CacheFactoryCacheResolver();
    }

    @Nullable
    protected CacheResolver newSingleCacheCacheResolver() {
        return this.getCache().map(this::newSingleCacheCacheResolver).orElse(null);
    }

    @NonNull
    private CacheResolver newSingleCacheCacheResolver(@NonNull GemFireCache cache) {
        return CacheUtils.isClient(cache) ? SingleCacheCacheResolver.from((ClientCache)cache) : SingleCacheCacheResolver.from((Cache)cache);
    }

    public final void setCache(@Nullable GemFireCache cache) {
        this.cache = cache;
    }

    protected Optional<GemFireCache> getCache() {
        return Optional.ofNullable(this.cache);
    }

    public final void setCacheBeanName(@Nullable String cacheBeanName) {
        this.cacheBeanName = cacheBeanName;
    }

    protected Optional<String> getCacheBeanName() {
        return Optional.ofNullable(this.cacheBeanName).filter(StringUtils::hasText);
    }

    public final void setCompositionStrategy(CompositionStrategy compositionStrategy) {
        this.compositionStrategy = compositionStrategy;
    }

    protected CompositionStrategy getCompositionStrategy() {
        return this.compositionStrategy != null ? this.compositionStrategy : CompositionStrategy.DEFAULT;
    }

    @Autowired(required=false)
    public final void setConfiguredCacheResolvers(List<CacheResolver> cacheResolvers) {
        this.configuredCacheResolvers = CollectionUtils.nullSafeList(cacheResolvers).stream().filter(Objects::nonNull).filter(this::isNotCacheResolverProxyForThisFactoryBean).collect(Collectors.toList());
    }

    protected List<CacheResolver> getConfiguredCacheResolvers() {
        return this.configuredCacheResolvers;
    }

    private boolean isCacheResolverProxyForThisFactoryBean(CacheResolver<?> cacheResolver) {
        return cacheResolver instanceof CacheResolverProxy && ((CacheResolverProxy)cacheResolver).getCacheResolverFactoryBean().equals(this);
    }

    private boolean isNotCacheResolverProxyForThisFactoryBean(CacheResolver<?> cacheResolver) {
        return !this.isCacheResolverProxyForThisFactoryBean(cacheResolver);
    }

    private List<CacheResolver> resolveCacheResolvers() {
        BeanFactory beanFactory = this.getBeanFactory();
        Assert.state((beanFactory != null ? 1 : 0) != 0, () -> String.format("A Spring context is not present and is required to use [%1$s.%2$s.%3$s]", CompositionStrategy.class.getEnclosingClass().getSimpleName(), CompositionStrategy.class.getSimpleName(), CompositionStrategy.USER_DEFINED.name()));
        List<CacheResolver> orderedCacheResolvers = SpringExtensions.getOrderedStreamOfBeansByType(beanFactory, CacheResolver.class).collect(Collectors.toList());
        this.setConfiguredCacheResolvers(orderedCacheResolvers);
        return orderedCacheResolvers;
    }

    public SmartCacheResolverFactoryBean withCache(GemFireCache cache) {
        this.setCache(cache);
        return this;
    }

    public SmartCacheResolverFactoryBean withCacheBeanName(String cacheBeanName) {
        this.setCacheBeanName(cacheBeanName);
        return this;
    }

    public SmartCacheResolverFactoryBean usingCompositionStrategy(CompositionStrategy compositionStrategy) {
        this.setCompositionStrategy(compositionStrategy);
        return this;
    }

    static enum CompositionStrategy {
        DEFAULT{

            @Override
            <T extends GemFireCache> CacheResolver<T> use(SmartCacheResolverFactoryBean factoryBean) {
                return ComposableCacheResolver.compose(factoryBean.newSingleCacheCacheResolver(), factoryBean.newBeanFactoryCacheResolver(), factoryBean.newClientCacheFactoryCacheResolver(), factoryBean.newPeerCacheFactoryCacheResolver());
            }
        }
        ,
        GEODE{

            @Override
            <T extends GemFireCache> CacheResolver<T> use(SmartCacheResolverFactoryBean factoryBean) {
                return ComposableCacheResolver.compose(factoryBean.newSingleCacheCacheResolver(), factoryBean.newClientCacheFactoryCacheResolver(), factoryBean.newPeerCacheFactoryCacheResolver());
            }
        }
        ,
        SPRING{

            @Override
            <T extends GemFireCache> CacheResolver<T> use(SmartCacheResolverFactoryBean factoryBean) {
                return ComposableCacheResolver.compose(factoryBean.newSingleCacheCacheResolver(), factoryBean.newBeanFactoryCacheResolver());
            }
        }
        ,
        USER_DEFINED{

            @Override
            <T extends GemFireCache> CacheResolver<T> use(SmartCacheResolverFactoryBean factoryBean) {
                List<CacheResolver> cacheResolvers = this.computeIfAbsent(factoryBean);
                Assert.state((boolean)this.isNotEmpty(cacheResolvers), (String)"No CacheResolver beans were defined");
                CacheResolver current = null;
                for (CacheResolver cacheResolver : cacheResolvers) {
                    current = ComposableCacheResolver.compose(current, cacheResolver);
                }
                return current;
            }

            private synchronized List<CacheResolver> computeIfAbsent(SmartCacheResolverFactoryBean factoryBean) {
                return Optional.ofNullable(factoryBean.getConfiguredCacheResolvers()).filter(this::isNotEmpty).orElseGet(() -> factoryBean.resolveCacheResolvers());
            }

            private boolean isNotEmpty(List<?> list) {
                return list != null && !list.isEmpty();
            }
        };


        abstract <T extends GemFireCache> CacheResolver<T> use(SmartCacheResolverFactoryBean var1);
    }

    class CacheResolverProxy
    implements CacheResolver<GemFireCache> {
        CacheResolverProxy() {
        }

        Optional<CacheResolver<GemFireCache>> getCacheResolver() {
            return Optional.ofNullable(this.getCacheResolverFactoryBean().getCacheResolver());
        }

        SmartCacheResolverFactoryBean getCacheResolverFactoryBean() {
            return SmartCacheResolverFactoryBean.this;
        }

        @Override
        public GemFireCache resolve() {
            return this.getCacheResolver().map(CacheResolver::resolve).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("CacheResolver was not initialized", new Object[0]));
        }
    }
}

