/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.transaction.event;

import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.TransactionEvent;
import org.apache.geode.cache.TransactionWriter;
import org.apache.geode.cache.TransactionWriterException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ComposableTransactionWriter
implements TransactionWriter {
    private final TransactionWriter transactionWriterOne;
    private final TransactionWriter transactionWriterTwo;

    @Nullable
    public static TransactionWriter compose(@Nullable TransactionWriter transactionWriterOne, @Nullable TransactionWriter transactionWriterTwo) {
        return transactionWriterOne == null ? transactionWriterTwo : (transactionWriterTwo == null ? transactionWriterOne : new ComposableTransactionWriter(transactionWriterOne, transactionWriterTwo));
    }

    private ComposableTransactionWriter(@NonNull TransactionWriter transactionWriterOne, @NonNull TransactionWriter transactionWriterTwo) {
        Assert.notNull((Object)transactionWriterOne, (String)"TransactionWriter one must not be null");
        Assert.notNull((Object)transactionWriterTwo, (String)"TransactionWriter two must not be null");
        this.transactionWriterOne = transactionWriterOne;
        this.transactionWriterTwo = transactionWriterTwo;
    }

    protected TransactionWriter getTransactionWriterOne() {
        return this.transactionWriterOne;
    }

    protected TransactionWriter getTransactionWriterTwo() {
        return this.transactionWriterTwo;
    }

    public void beforeCommit(TransactionEvent event) throws TransactionWriterException {
        this.getTransactionWriterOne().beforeCommit(event);
        this.getTransactionWriterTwo().beforeCommit(event);
    }

    public void close() {
        this.getTransactionWriterOne().close();
        this.getTransactionWriterTwo().close();
    }

    public void init(Properties properties) {
        this.getTransactionWriterOne().init(properties);
        this.getTransactionWriterTwo().init(properties);
    }

    public void initialize(Cache cache, Properties properties) {
        this.getTransactionWriterOne().initialize(cache, properties);
        this.getTransactionWriterTwo().initialize(cache, properties);
    }
}

