/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.config;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.ldap.core.mapping.LdapMappingContext;
import org.springframework.data.ldap.repository.LdapRepository;
import org.springframework.data.ldap.repository.support.LdapRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.ldap.odm.annotations.Entry;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class LdapRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    private static final String ATT_LDAP_TEMPLATE_REF = "ldap-template-ref";
    private static final String MAPPING_CONTEXT_BEAN_NAME = "ldapMappingContext";

    public String getModuleName() {
        return "LDAP";
    }

    protected String getModulePrefix() {
        return "ldap";
    }

    public String getRepositoryFactoryBeanClassName() {
        return LdapRepositoryFactoryBean.class.getName();
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(Entry.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(LdapRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        String ldapTemplateRef = element.getAttribute(ATT_LDAP_TEMPLATE_REF);
        if (!StringUtils.hasText((String)ldapTemplateRef)) {
            ldapTemplateRef = "ldapTemplate";
        }
        builder.addPropertyReference("ldapOperations", ldapTemplateRef);
        builder.addPropertyReference("mappingContext", MAPPING_CONTEXT_BEAN_NAME);
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference("ldapOperations", attributes.getString("ldapTemplateRef"));
        builder.addPropertyReference("mappingContext", MAPPING_CONTEXT_BEAN_NAME);
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        if (!registry.containsBeanDefinition(MAPPING_CONTEXT_BEAN_NAME)) {
            RootBeanDefinition definition = new RootBeanDefinition(LdapMappingContext.class);
            definition.setRole(2);
            definition.setSource(configurationSource.getSource());
            registry.registerBeanDefinition(MAPPING_CONTEXT_BEAN_NAME, (BeanDefinition)definition);
        }
    }

    protected boolean useRepositoryConfiguration(RepositoryMetadata metadata) {
        return !metadata.isReactiveRepository();
    }
}

