/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.R2dbcEntityOperations;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.repository.query.AbstractR2dbcQuery;
import org.springframework.data.r2dbc.repository.query.R2dbcQueryCreator;
import org.springframework.data.r2dbc.repository.query.R2dbcQueryMethod;
import org.springframework.data.relational.repository.query.RelationalEntityMetadata;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.relational.repository.query.RelationalParameters;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.r2dbc.core.PreparedOperation;
import reactor.core.publisher.Mono;

public class PartTreeR2dbcQuery
extends AbstractR2dbcQuery {
    private final ResultProcessor processor;
    private final ReactiveDataAccessStrategy dataAccessStrategy;
    private final RelationalParameters parameters;
    private final PartTree tree;

    public PartTreeR2dbcQuery(R2dbcQueryMethod method, R2dbcEntityOperations entityOperations, R2dbcConverter converter, ReactiveDataAccessStrategy dataAccessStrategy) {
        super(method, entityOperations, converter);
        this.processor = method.getResultProcessor();
        this.dataAccessStrategy = dataAccessStrategy;
        this.parameters = method.getParameters();
        try {
            this.tree = new PartTree(method.getName(), method.getEntityInformation().getJavaType());
            R2dbcQueryCreator.validate((PartTree)this.tree, (Parameters)this.parameters);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.format("Failed to create query for method %s! %s", new Object[]{method, e.getMessage()}), e);
        }
    }

    @Override
    protected boolean isModifyingQuery() {
        return this.tree.isDelete();
    }

    @Override
    protected boolean isCountQuery() {
        return this.tree.isCountProjection();
    }

    @Override
    protected boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }

    @Override
    protected Mono<PreparedOperation<?>> createQuery(RelationalParameterAccessor accessor) {
        return Mono.fromSupplier(() -> {
            ReturnedType returnedType = this.processor.withDynamicProjection((ParameterAccessor)accessor).getReturnedType();
            List<String> projectedProperties = Collections.emptyList();
            if (returnedType.needsCustomConstruction()) {
                projectedProperties = new ArrayList(returnedType.getInputProperties());
            }
            RelationalEntityMetadata<?> entityMetadata = this.getQueryMethod().getEntityInformation();
            R2dbcQueryCreator queryCreator = new R2dbcQueryCreator(this.tree, this.dataAccessStrategy, entityMetadata, accessor, projectedProperties);
            return (PreparedOperation)queryCreator.createQuery(this.getDynamicSort(accessor));
        });
    }

    private Sort getDynamicSort(RelationalParameterAccessor accessor) {
        return this.parameters.potentiallySortsDynamically() ? accessor.getSort() : Sort.unsorted();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [").append(this.getQueryMethod().getName());
        sb.append(']');
        return sb.toString();
    }
}

