/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetchingEnvironment;
import java.lang.annotation.Annotation;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class AuthenticationPrincipalArgumentResolver
implements HandlerMethodArgumentResolver {
    private final ExpressionParser parser = new SpelExpressionParser();
    private final BeanResolver beanResolver;

    public AuthenticationPrincipalArgumentResolver(BeanResolver beanResolver) {
        Assert.notNull((Object)beanResolver, (String)"BeanResolver is required");
        this.beanResolver = beanResolver;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return AuthenticationPrincipalArgumentResolver.findMethodAnnotation(parameter) != null;
    }

    @Nullable
    private static AuthenticationPrincipal findMethodAnnotation(MethodParameter parameter) {
        Annotation[] annotationsToSearch;
        AuthenticationPrincipal annotation = (AuthenticationPrincipal)parameter.getParameterAnnotation(AuthenticationPrincipal.class);
        if (annotation != null) {
            return annotation;
        }
        for (Annotation toSearch : annotationsToSearch = parameter.getParameterAnnotations()) {
            annotation = (AuthenticationPrincipal)AnnotationUtils.findAnnotation(toSearch.annotationType(), AuthenticationPrincipal.class);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) throws Exception {
        return this.getCurrentAuthentication().flatMap(auth -> Mono.justOrEmpty((Object)this.resolvePrincipal(parameter, auth.getPrincipal()))).transform(argument -> AuthenticationPrincipalArgumentResolver.isParameterMonoAssignable(parameter) ? Mono.just((Object)argument) : argument);
    }

    private static boolean isParameterMonoAssignable(MethodParameter parameter) {
        Class type = parameter.getParameterType();
        return Publisher.class.equals((Object)type) || Mono.class.equals((Object)type);
    }

    private Mono<Authentication> getCurrentAuthentication() {
        return Mono.justOrEmpty((Object)SecurityContextHolder.getContext().getAuthentication()).switchIfEmpty(ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication));
    }

    @Nullable
    private Object resolvePrincipal(MethodParameter parameter, Object principal) {
        AuthenticationPrincipal annotation = AuthenticationPrincipalArgumentResolver.findMethodAnnotation(parameter);
        String expressionValue = annotation.expression();
        if (StringUtils.hasLength((String)expressionValue)) {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setRootObject(principal);
            context.setVariable("this", principal);
            context.setBeanResolver(this.beanResolver);
            Expression expression = this.parser.parseExpression(expressionValue);
            principal = expression.getValue((EvaluationContext)context);
        }
        if (this.isInvalidType(parameter, principal)) {
            if (annotation.errorOnInvalidType()) {
                throw new ClassCastException(principal + " is not assignable to " + parameter.getParameterType());
            }
            return null;
        }
        return principal;
    }

    private boolean isInvalidType(MethodParameter parameter, @Nullable Object principal) {
        if (principal == null) {
            return false;
        }
        Class typeToCheck = parameter.getParameterType();
        if (AuthenticationPrincipalArgumentResolver.isParameterMonoAssignable(parameter)) {
            Class genericType = parameter.nested().getNestedParameterType();
            if (genericType.equals(Object.class)) {
                return false;
            }
            typeToCheck = genericType;
        }
        return !ClassUtils.isAssignable((Class)typeToCheck, principal.getClass());
    }
}

