/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import graphql.language.FieldDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.idl.FieldWiringEnvironment;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.WiringFactory;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class AutoRegistrationRuntimeWiringConfigurer
implements RuntimeWiringConfigurer {
    private final Map<String, Function<Boolean, DataFetcher<?>>> dataFetcherFactories;

    public AutoRegistrationRuntimeWiringConfigurer(Map<String, Function<Boolean, DataFetcher<?>>> dataFetcherFactories) {
        this.dataFetcherFactories = dataFetcherFactories;
    }

    @Override
    public void configure(RuntimeWiring.Builder builder) {
    }

    @Override
    public void configure(RuntimeWiring.Builder builder, List<WiringFactory> container) {
        container.add(new AutoRegistrationWiringFactory(builder));
    }

    private class AutoRegistrationWiringFactory
    implements WiringFactory {
        private final RuntimeWiring.Builder builder;
        @Nullable
        private Predicate<String> existingQueryDataFetcherPredicate;

        AutoRegistrationWiringFactory(RuntimeWiring.Builder builder) {
            this.builder = builder;
        }

        public boolean providesDataFetcher(FieldWiringEnvironment environment) {
            if (AutoRegistrationRuntimeWiringConfigurer.this.dataFetcherFactories.isEmpty()) {
                return false;
            }
            if (!environment.getParentType().getName().equals("Query")) {
                return false;
            }
            GraphQLOutputType outputType = environment.getFieldType() instanceof GraphQLList ? ((GraphQLList)environment.getFieldType()).getWrappedType() : environment.getFieldType();
            String outputTypeName = outputType instanceof GraphQLNamedOutputType ? ((GraphQLNamedOutputType)outputType).getName() : null;
            return outputTypeName != null && AutoRegistrationRuntimeWiringConfigurer.this.dataFetcherFactories.containsKey(outputTypeName) && !this.hasDataFetcherFor(environment.getFieldDefinition());
        }

        private boolean hasDataFetcherFor(FieldDefinition fieldDefinition) {
            if (this.existingQueryDataFetcherPredicate == null) {
                Map map = this.builder.build().getDataFetcherForType("Query");
                this.existingQueryDataFetcherPredicate = fieldName -> map.get(fieldName) != null;
            }
            return this.existingQueryDataFetcherPredicate.test(fieldDefinition.getName());
        }

        public DataFetcher<?> getDataFetcher(FieldWiringEnvironment environment) {
            return environment.getFieldType() instanceof GraphQLList ? this.initDataFetcher(((GraphQLList)environment.getFieldType()).getWrappedType(), false) : this.initDataFetcher((GraphQLType)environment.getFieldType(), true);
        }

        private DataFetcher<?> initDataFetcher(GraphQLType type, boolean single) {
            Assert.isInstanceOf(GraphQLNamedOutputType.class, (Object)type);
            String typeName = ((GraphQLNamedOutputType)type).getName();
            Function factory = (Function)AutoRegistrationRuntimeWiringConfigurer.this.dataFetcherFactories.get(typeName);
            Assert.notNull((Object)factory, (String)"Expected DataFetcher factory");
            return (DataFetcher)factory.apply(single);
        }
    }
}

