/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.GraphQLContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.dataloader.BatchLoaderContextProvider;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderFactory;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.MappedBatchLoaderWithContext;
import org.springframework.graphql.execution.BatchLoaderRegistry;
import org.springframework.graphql.execution.ReactorContextManager;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class DefaultBatchLoaderRegistry
implements BatchLoaderRegistry {
    private final List<ReactorBatchLoader<?, ?>> loaders = new ArrayList();
    private final List<ReactorMappedBatchLoader<?, ?>> mappedLoaders = new ArrayList();

    @Override
    public <K, V> BatchLoaderRegistry.RegistrationSpec<K, V> forTypePair(Class<K> keyType, Class<V> valueType) {
        return new DefaultRegistrationSpec(valueType);
    }

    @Override
    public <K, V> BatchLoaderRegistry.RegistrationSpec<K, V> forName(String name) {
        return new DefaultRegistrationSpec(name);
    }

    @Override
    public void registerDataLoaders(DataLoaderRegistry registry, GraphQLContext context) {
        DataLoader dataLoader;
        DataLoaderOptions options;
        BatchLoaderContextProvider contextProvider = () -> context;
        DataLoaderOptions defaultOptions = DataLoaderOptions.newOptions().setBatchLoaderContextProvider(contextProvider);
        for (ReactorBatchLoader<?, ?> reactorBatchLoader : this.loaders) {
            options = reactorBatchLoader.getOptionsOrDefault(contextProvider, defaultOptions);
            dataLoader = DataLoaderFactory.newDataLoader(reactorBatchLoader, (DataLoaderOptions)options);
            this.registerDataLoader(reactorBatchLoader.getName(), dataLoader, registry);
        }
        for (ReactorMappedBatchLoader reactorMappedBatchLoader : this.mappedLoaders) {
            options = reactorMappedBatchLoader.getOptionsOrDefault(contextProvider, defaultOptions);
            dataLoader = DataLoaderFactory.newMappedDataLoader((MappedBatchLoaderWithContext)reactorMappedBatchLoader, (DataLoaderOptions)options);
            this.registerDataLoader(reactorMappedBatchLoader.getName(), dataLoader, registry);
        }
    }

    private void registerDataLoader(String name, DataLoader<?, ?> dataLoader, DataLoaderRegistry registry) {
        if (registry.getDataLoader(name) != null) {
            throw new IllegalStateException("More than one DataLoader named '" + name + "'");
        }
        registry.register(name, dataLoader);
    }

    private static class ReactorMappedBatchLoader<K, V>
    implements MappedBatchLoaderWithContext<K, V> {
        private final String name;
        private final BiFunction<Set<K>, BatchLoaderEnvironment, Mono<Map<K, V>>> loader;
        @Nullable
        private final DataLoaderOptions options;

        private ReactorMappedBatchLoader(String name, BiFunction<Set<K>, BatchLoaderEnvironment, Mono<Map<K, V>>> loader, @Nullable DataLoaderOptions options) {
            this.name = name;
            this.loader = loader;
            this.options = options;
        }

        public String getName() {
            return this.name;
        }

        public DataLoaderOptions getOptionsOrDefault(BatchLoaderContextProvider provider, DataLoaderOptions defaultOptions) {
            if (this.options != null) {
                return new DataLoaderOptions(this.options).setBatchLoaderContextProvider(provider);
            }
            return defaultOptions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletionStage<Map<K, V>> load(Set<K> keys, BatchLoaderEnvironment environment) {
            ContextView contextView = ReactorContextManager.getReactorContext((GraphQLContext)environment.getContext());
            try {
                ReactorContextManager.restoreThreadLocalValues(contextView);
                CompletableFuture completableFuture = this.loader.apply(keys, environment).contextWrite(contextView).toFuture();
                return completableFuture;
            }
            finally {
                ReactorContextManager.resetThreadLocalValues(contextView);
            }
        }
    }

    private static class ReactorBatchLoader<K, V>
    implements BatchLoaderWithContext<K, V> {
        private final String name;
        private final BiFunction<List<K>, BatchLoaderEnvironment, Flux<V>> loader;
        @Nullable
        private final DataLoaderOptions options;

        private ReactorBatchLoader(String name, BiFunction<List<K>, BatchLoaderEnvironment, Flux<V>> loader, @Nullable DataLoaderOptions options) {
            this.name = name;
            this.loader = loader;
            this.options = options;
        }

        public String getName() {
            return this.name;
        }

        public DataLoaderOptions getOptionsOrDefault(BatchLoaderContextProvider provider, DataLoaderOptions defaultOptions) {
            if (this.options != null) {
                return new DataLoaderOptions(this.options).setBatchLoaderContextProvider(provider);
            }
            return defaultOptions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletionStage<List<V>> load(List<K> keys, BatchLoaderEnvironment environment) {
            ContextView contextView = ReactorContextManager.getReactorContext((GraphQLContext)environment.getContext());
            try {
                ReactorContextManager.restoreThreadLocalValues(contextView);
                CompletableFuture completableFuture = this.loader.apply(keys, environment).collectList().contextWrite(contextView).toFuture();
                return completableFuture;
            }
            finally {
                ReactorContextManager.resetThreadLocalValues(contextView);
            }
        }
    }

    private class DefaultRegistrationSpec<K, V>
    implements BatchLoaderRegistry.RegistrationSpec<K, V> {
        @Nullable
        private final Class<?> valueType;
        @Nullable
        private String name;
        @Nullable
        private DataLoaderOptions options;

        public DefaultRegistrationSpec(Class<V> valueType) {
            this.valueType = valueType;
        }

        public DefaultRegistrationSpec(String name) {
            this.name = name;
            this.valueType = null;
        }

        @Override
        public BatchLoaderRegistry.RegistrationSpec<K, V> withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public BatchLoaderRegistry.RegistrationSpec<K, V> withOptions(Consumer<DataLoaderOptions> optionsConsumer) {
            this.options = this.options != null ? this.options : DataLoaderOptions.newOptions();
            optionsConsumer.accept(this.options);
            return this;
        }

        @Override
        public BatchLoaderRegistry.RegistrationSpec<K, V> withOptions(DataLoaderOptions options) {
            this.options = options;
            return this;
        }

        @Override
        public void registerBatchLoader(BiFunction<List<K>, BatchLoaderEnvironment, Flux<V>> loader) {
            DefaultBatchLoaderRegistry.this.loaders.add(new ReactorBatchLoader(this.initName(), loader, this.options));
        }

        @Override
        public void registerMappedBatchLoader(BiFunction<Set<K>, BatchLoaderEnvironment, Mono<Map<K, V>>> loader) {
            DefaultBatchLoaderRegistry.this.mappedLoaders.add(new ReactorMappedBatchLoader(this.initName(), loader, this.options));
        }

        private String initName() {
            if (StringUtils.hasText((String)this.name)) {
                return this.name;
            }
            Assert.notNull(this.valueType, (String)"Value type not available to select a default DataLoader name.");
            return StringUtils.hasText((String)this.name) ? this.name : this.valueType.getName();
        }
    }
}

