/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.execution.ReactorContextManager;
import org.springframework.graphql.execution.ThreadLocalAccessor;
import org.springframework.graphql.server.WebGraphQlHandler;
import org.springframework.graphql.server.WebGraphQlInterceptor;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.graphql.server.WebSocketGraphQlInterceptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;

class DefaultWebGraphQlHandlerBuilder
implements WebGraphQlHandler.Builder {
    private final ExecutionGraphQlService service;
    private final List<WebGraphQlInterceptor> interceptors = new ArrayList<WebGraphQlInterceptor>();
    @Nullable
    private WebSocketGraphQlInterceptor webSocketInterceptor;
    @Nullable
    private List<ThreadLocalAccessor> accessors;

    DefaultWebGraphQlHandlerBuilder(ExecutionGraphQlService service) {
        Assert.notNull((Object)service, (String)"GraphQlService is required");
        this.service = service;
    }

    @Override
    public WebGraphQlHandler.Builder interceptor(WebGraphQlInterceptor ... interceptors) {
        return this.interceptors(Arrays.asList(interceptors));
    }

    @Override
    public WebGraphQlHandler.Builder interceptors(List<WebGraphQlInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
        interceptors.forEach(interceptor -> {
            if (interceptor instanceof WebSocketGraphQlInterceptor) {
                Assert.isNull((Object)this.webSocketInterceptor, (String)"There can be at most 1 WebSocketInterceptor");
                this.webSocketInterceptor = (WebSocketGraphQlInterceptor)interceptor;
            }
        });
        return this;
    }

    @Override
    public WebGraphQlHandler.Builder threadLocalAccessor(ThreadLocalAccessor ... accessors) {
        return this.threadLocalAccessors(Arrays.asList(accessors));
    }

    @Override
    public WebGraphQlHandler.Builder threadLocalAccessors(List<ThreadLocalAccessor> accessors) {
        if (!CollectionUtils.isEmpty(accessors)) {
            this.accessors = this.accessors != null ? this.accessors : new ArrayList<ThreadLocalAccessor>();
            this.accessors.addAll(accessors);
        }
        return this;
    }

    @Override
    public WebGraphQlHandler build() {
        WebGraphQlInterceptor.Chain endOfChain = request -> this.service.execute(request).map(WebGraphQlResponse::new);
        final WebGraphQlInterceptor.Chain executionChain = this.interceptors.stream().reduce(WebGraphQlInterceptor::andThen).map(interceptor -> interceptor.apply(endOfChain)).orElse(endOfChain);
        final ThreadLocalAccessor accessor = CollectionUtils.isEmpty(this.accessors) ? null : ThreadLocalAccessor.composite(this.accessors);
        return new WebGraphQlHandler(){

            @Override
            public WebSocketGraphQlInterceptor getWebSocketInterceptor() {
                return DefaultWebGraphQlHandlerBuilder.this.webSocketInterceptor != null ? DefaultWebGraphQlHandlerBuilder.this.webSocketInterceptor : new WebSocketGraphQlInterceptor(){};
            }

            @Override
            @Nullable
            public ThreadLocalAccessor getThreadLocalAccessor() {
                return accessor;
            }

            @Override
            public Mono<WebGraphQlResponse> handleRequest(WebGraphQlRequest request) {
                return executionChain.next(request).contextWrite(context -> {
                    if (accessor != null) {
                        return ReactorContextManager.extractThreadLocalValues(accessor, context);
                    }
                    return context;
                });
            }
        };
    }
}

