/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.federation;

import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.graphql.data.GraphQlArgumentBinder;
import org.springframework.graphql.data.federation.EntityArgumentMethodArgumentResolver;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.util.Assert;

final class EntityArgumentsMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final GraphQlArgumentBinder argumentBinder;

    EntityArgumentsMethodArgumentResolver(GraphQlArgumentBinder argumentBinder) {
        Assert.notNull((Object)argumentBinder, (String)"GraphQlArgumentBinder is required");
        this.argumentBinder = argumentBinder;
    }

    @Override
    public boolean supportsParameter(MethodParameter param) {
        if (param.getParameterType().equals(List.class)) {
            param = param.nested(Integer.valueOf(0));
        }
        if (param.getNestedParameterType().equals(Map.class)) {
            return param.nested(Integer.valueOf(0)).getNestedParameterType().equals(String.class);
        }
        return false;
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment env) throws Exception {
        ResolvableType targetType = ResolvableType.forMethodParameter((MethodParameter)parameter);
        if (env instanceof EntityArgumentMethodArgumentResolver.EntityDataFetchingEnvironment) {
            EntityArgumentMethodArgumentResolver.EntityDataFetchingEnvironment entityEnv = (EntityArgumentMethodArgumentResolver.EntityDataFetchingEnvironment)env;
            return this.argumentBinder.bind(entityEnv.getRepresentation(), false, targetType);
        }
        if (env instanceof EntityArgumentMethodArgumentResolver.EntityBatchDataFetchingEnvironment) {
            EntityArgumentMethodArgumentResolver.EntityBatchDataFetchingEnvironment batchEnv = (EntityArgumentMethodArgumentResolver.EntityBatchDataFetchingEnvironment)env;
            return this.argumentBinder.bind(batchEnv.getRepresentations(), false, targetType);
        }
        throw new IllegalStateException("Expected decorated DataFetchingEnvironment");
    }
}

