/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import io.rsocket.loadbalance.LoadbalanceStrategy;
import io.rsocket.loadbalance.LoadbalanceTarget;
import io.rsocket.transport.ClientTransport;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.graphql.client.DefaultRSocketGraphQlClientBuilder;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.util.MimeType;
import reactor.core.publisher.Mono;

public interface RSocketGraphQlClient
extends GraphQlClient {
    public Mono<Void> start();

    public Mono<Void> stop();

    public Builder<?> mutate();

    public static Builder<?> builder() {
        return new DefaultRSocketGraphQlClientBuilder();
    }

    public static Builder<?> builder(RSocketRequester.Builder requesterBuilder) {
        return new DefaultRSocketGraphQlClientBuilder(requesterBuilder);
    }

    public static interface Builder<B extends Builder<B>>
    extends GraphQlClient.Builder<B> {
        public B tcp(String var1, int var2);

        public B webSocket(URI var1);

        public B clientTransport(ClientTransport var1);

        public B clientTransports(Publisher<List<LoadbalanceTarget>> var1, LoadbalanceStrategy var2);

        public B dataMimeType(MimeType var1);

        public B route(String var1);

        public B rsocketRequester(Consumer<RSocketRequester.Builder> var1);

        @Override
        public RSocketGraphQlClient build();
    }
}

