/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.federation;

import com.apollographql.federation.graphqljava.Federation;
import com.apollographql.federation.graphqljava.SchemaTransformer;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLSchema;
import graphql.schema.TypeResolver;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.graphql.data.GraphQlArgumentBinder;
import org.springframework.graphql.data.federation.EntitiesDataFetcher;
import org.springframework.graphql.data.federation.EntityArgumentMethodArgumentResolver;
import org.springframework.graphql.data.federation.EntityArgumentsMethodArgumentResolver;
import org.springframework.graphql.data.federation.EntityHandlerMethod;
import org.springframework.graphql.data.federation.EntityMapping;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolverComposite;
import org.springframework.graphql.data.method.annotation.support.AnnotatedControllerDetectionSupport;
import org.springframework.graphql.data.method.annotation.support.AuthenticationPrincipalArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ContextValueMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ContinuationHandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.DataFetchingEnvironmentMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.LocalContextValueMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.PrincipalMethodArgumentResolver;
import org.springframework.graphql.execution.ClassNameTypeResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class FederationSchemaFactory
extends AnnotatedControllerDetectionSupport<EntityMappingInfo> {
    @Nullable
    private TypeResolver typeResolver;
    private final Map<String, EntityHandlerMethod> handlerMethods = new LinkedHashMap<String, EntityHandlerMethod>();

    public void setTypeResolver(@Nullable TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.detectHandlerMethods().forEach(info -> this.handlerMethods.put(info.typeName(), new EntityHandlerMethod((EntityMappingInfo)info, this.getArgumentResolvers(), this.getExecutor(), this.shouldInvokeAsync(info.handlerMethod()))));
        if (this.typeResolver == null) {
            this.typeResolver = new ClassNameTypeResolver();
        }
        if (this.logger.isTraceEnabled()) {
            String formatted = this.handlerMethods.entrySet().stream().map(entry -> (String)entry.getKey() + " -> " + ((EntityHandlerMethod)entry.getValue()).getShortLogMessage()).collect(Collectors.joining("\n", "\n", "\n"));
            this.logger.trace((Object)("@EntityMapping registrations:" + formatted));
        }
    }

    @Override
    protected HandlerMethodArgumentResolverComposite initArgumentResolvers() {
        HandlerMethodArgumentResolverComposite resolvers = new HandlerMethodArgumentResolverComposite();
        GraphQlArgumentBinder argumentBinder = new GraphQlArgumentBinder((ConversionService)this.getConversionService(), this.isFallBackOnDirectFieldAccess());
        resolvers.addResolver(new ContextValueMethodArgumentResolver());
        resolvers.addResolver(new LocalContextValueMethodArgumentResolver());
        resolvers.addResolver(new EntityArgumentMethodArgumentResolver(argumentBinder));
        resolvers.addResolver(new EntityArgumentsMethodArgumentResolver(argumentBinder));
        resolvers.addResolver(new DataFetchingEnvironmentMethodArgumentResolver());
        if (springSecurityPresent) {
            ApplicationContext context = this.obtainApplicationContext();
            resolvers.addResolver(new PrincipalMethodArgumentResolver());
            resolvers.addResolver(new AuthenticationPrincipalArgumentResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)context)));
        }
        if (KotlinDetector.isKotlinPresent()) {
            resolvers.addResolver(new ContinuationHandlerMethodArgumentResolver());
        }
        return resolvers;
    }

    @Override
    @Nullable
    protected EntityMappingInfo getMappingInfo(Method method, Object handler, Class<?> handlerType) {
        EntityMapping mapping = (EntityMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, EntityMapping.class);
        if (mapping == null) {
            return null;
        }
        String typeName = mapping.name();
        if (!StringUtils.hasText((String)typeName)) {
            typeName = StringUtils.capitalize((String)method.getName());
        }
        HandlerMethod handlerMethod = this.createHandlerMethod(method, handler, handlerType);
        return new EntityMappingInfo(typeName, handlerMethod);
    }

    @Override
    protected HandlerMethod getHandlerMethod(EntityMappingInfo mappingInfo) {
        return mappingInfo.handlerMethod();
    }

    public GraphQLSchema createGraphQLSchema(TypeDefinitionRegistry registry, RuntimeWiring wiring) {
        return this.createSchemaTransformer(registry, wiring).build();
    }

    public SchemaTransformer createSchemaTransformer(TypeDefinitionRegistry registry, RuntimeWiring wiring) {
        Assert.state((this.typeResolver != null ? 1 : 0) != 0, (String)"afterPropertiesSet not called");
        return Federation.transform((TypeDefinitionRegistry)registry, (RuntimeWiring)wiring).fetchEntities((DataFetcher)new EntitiesDataFetcher(this.handlerMethods, this.getExceptionResolver())).resolveEntityType(this.typeResolver);
    }

    public record EntityMappingInfo(String typeName, HandlerMethod handlerMethod) {
        public boolean isBatchHandlerMethod() {
            MethodParameter returnType = this.handlerMethod().getReturnType();
            Class clazz = returnType.getParameterType();
            ReactiveAdapter adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(clazz);
            if (adapter != null) {
                if (adapter.isMultiValue()) {
                    return true;
                }
                returnType = returnType.nested();
            }
            return List.class.isAssignableFrom(returnType.getNestedParameterType());
        }
    }
}

