/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.support;

import graphql.GraphQLError;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.graphql.server.support.GraphQlWebSocketMessageType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class GraphQlWebSocketMessage {
    @Nullable
    private String id;
    @Nullable
    private GraphQlWebSocketMessageType type;
    @Nullable
    private Object payload;

    private GraphQlWebSocketMessage(@Nullable String id, GraphQlWebSocketMessageType type, @Nullable Object payload) {
        Assert.notNull((Object)((Object)type), (String)"GraphQlMessageType is required");
        Assert.isTrue((payload != null || type.doesNotRequirePayload() ? 1 : 0) != 0, (String)("Payload is required for [" + type + "]"));
        this.id = id;
        this.type = type;
        this.payload = payload;
    }

    GraphQlWebSocketMessage() {
        this.type = GraphQlWebSocketMessageType.NOT_SPECIFIED;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public String getType() {
        Assert.notNull((Object)((Object)this.type), (String)"Type is required");
        return this.type.value();
    }

    public GraphQlWebSocketMessageType resolvedType() {
        Assert.state((this.type != null ? 1 : 0) != 0, (String)"GraphQlWebSocketMessage does not have a type");
        return this.type;
    }

    public <P> P getPayload() {
        if (this.payload == null) {
            Assert.state((boolean)this.resolvedType().doesNotRequirePayload(), (String)(this.type + " requires a payload"));
            return (P)Collections.emptyMap();
        }
        return (P)this.payload;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = GraphQlWebSocketMessageType.fromValue(type);
    }

    public void setPayload(@Nullable Object payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GraphQlWebSocketMessage)) {
            return false;
        }
        GraphQlWebSocketMessage other = (GraphQlWebSocketMessage)o;
        return ObjectUtils.nullSafeEquals((Object)((Object)this.type), (Object)((Object)other.type)) && (ObjectUtils.nullSafeEquals((Object)this.id, (Object)other.id) || this.id == null && other.id == null) && ObjectUtils.nullSafeEquals(this.getPayload(), other.getPayload());
    }

    public int hashCode() {
        int hashCode = this.type != null ? this.type.hashCode() : 0;
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.id);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.payload);
        return hashCode;
    }

    public String toString() {
        return "GraphQlWebSocketMessage[" + (String)(this.id != null ? "id=\"" + this.id + "\", " : "") + "type=\"" + this.type + "\"" + (String)(this.payload != null ? ", payload=" + this.payload : "") + "]";
    }

    public static GraphQlWebSocketMessage connectionInit(@Nullable Object payload) {
        return new GraphQlWebSocketMessage(null, GraphQlWebSocketMessageType.CONNECTION_INIT, payload);
    }

    public static GraphQlWebSocketMessage connectionAck(@Nullable Object payload) {
        return new GraphQlWebSocketMessage(null, GraphQlWebSocketMessageType.CONNECTION_ACK, payload);
    }

    public static GraphQlWebSocketMessage subscribe(String id, GraphQlRequest request) {
        Assert.notNull((Object)request, (String)"GraphQlRequest is required");
        return new GraphQlWebSocketMessage(id, GraphQlWebSocketMessageType.SUBSCRIBE, request.toMap());
    }

    public static GraphQlWebSocketMessage next(String id, Map<String, Object> responseMap) {
        Assert.notNull(responseMap, (String)"'responseMap' is required");
        return new GraphQlWebSocketMessage(id, GraphQlWebSocketMessageType.NEXT, responseMap);
    }

    public static GraphQlWebSocketMessage error(String id, List<GraphQLError> errors) {
        Assert.notNull(errors, (String)"GraphQlError's are required");
        return new GraphQlWebSocketMessage(id, GraphQlWebSocketMessageType.ERROR, errors.stream().map(GraphQLError::toSpecification).collect(Collectors.toList()));
    }

    public static GraphQlWebSocketMessage complete(String id) {
        return new GraphQlWebSocketMessage(id, GraphQlWebSocketMessageType.COMPLETE, null);
    }

    public static GraphQlWebSocketMessage ping(@Nullable Object payload) {
        return new GraphQlWebSocketMessage(null, GraphQlWebSocketMessageType.PING, payload);
    }

    public static GraphQlWebSocketMessage pong(@Nullable Object payload) {
        return new GraphQlWebSocketMessage(null, GraphQlWebSocketMessageType.PONG, payload);
    }
}

