/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class UserCredentialsConnectionFactoryAdapter
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
InitializingBean {
    private ConnectionFactory targetConnectionFactory;
    private String username;
    private String password;
    private final ThreadLocal threadBoundCredentials = new ThreadLocal();

    public void setTargetConnectionFactory(ConnectionFactory targetConnectionFactory) {
        Assert.notNull((Object)targetConnectionFactory, (String)"'targetConnectionFactory' must not be null");
        this.targetConnectionFactory = targetConnectionFactory;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void afterPropertiesSet() {
        if (this.targetConnectionFactory == null) {
            throw new IllegalArgumentException("'targetConnectionFactory' is required");
        }
    }

    public void setCredentialsForCurrentThread(String username, String password) {
        this.threadBoundCredentials.set(new String[]{username, password});
    }

    public void removeCredentialsFromCurrentThread() {
        this.threadBoundCredentials.set(null);
    }

    public final Connection createConnection() throws JMSException {
        String[] threadCredentials = (String[])this.threadBoundCredentials.get();
        if (threadCredentials != null) {
            return this.doCreateConnection(threadCredentials[0], threadCredentials[1]);
        }
        return this.doCreateConnection(this.username, this.password);
    }

    public Connection createConnection(String username, String password) throws JMSException {
        return this.doCreateConnection(username, password);
    }

    protected Connection doCreateConnection(String username, String password) throws JMSException {
        Assert.state((this.targetConnectionFactory != null ? 1 : 0) != 0, (String)"'targetConnectionFactory' is required");
        if (StringUtils.hasLength((String)username)) {
            return this.targetConnectionFactory.createConnection(username, password);
        }
        return this.targetConnectionFactory.createConnection();
    }

    public final QueueConnection createQueueConnection() throws JMSException {
        String[] threadCredentials = (String[])this.threadBoundCredentials.get();
        if (threadCredentials != null) {
            return this.doCreateQueueConnection(threadCredentials[0], threadCredentials[1]);
        }
        return this.doCreateQueueConnection(this.username, this.password);
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        return this.doCreateQueueConnection(username, password);
    }

    protected QueueConnection doCreateQueueConnection(String username, String password) throws JMSException {
        Assert.state((this.targetConnectionFactory != null ? 1 : 0) != 0, (String)"'targetConnectionFactory' is required");
        if (!(this.targetConnectionFactory instanceof QueueConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is not a QueueConnectionFactory");
        }
        QueueConnectionFactory queueFactory = (QueueConnectionFactory)this.targetConnectionFactory;
        if (StringUtils.hasLength((String)username)) {
            return queueFactory.createQueueConnection(username, password);
        }
        return queueFactory.createQueueConnection();
    }

    public final TopicConnection createTopicConnection() throws JMSException {
        String[] threadCredentials = (String[])this.threadBoundCredentials.get();
        if (threadCredentials != null) {
            return this.doCreateTopicConnection(threadCredentials[0], threadCredentials[1]);
        }
        return this.doCreateTopicConnection(this.username, this.password);
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        return this.doCreateTopicConnection(username, password);
    }

    protected TopicConnection doCreateTopicConnection(String username, String password) throws JMSException {
        Assert.state((this.targetConnectionFactory != null ? 1 : 0) != 0, (String)"'targetConnectionFactory' is required");
        if (!(this.targetConnectionFactory instanceof TopicConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is not a TopicConnectionFactory");
        }
        TopicConnectionFactory queueFactory = (TopicConnectionFactory)this.targetConnectionFactory;
        if (StringUtils.hasLength((String)username)) {
            return queueFactory.createTopicConnection(username, password);
        }
        return queueFactory.createTopicConnection();
    }
}

