/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.remoting;

import org.aopalliance.intercept.Interceptor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jms.remoting.JmsInvokerClientInterceptor;

public class JmsInvokerProxyFactoryBean
extends JmsInvokerClientInterceptor
implements FactoryBean {
    private Class serviceInterface;
    private Object serviceProxy;

    public void setServiceInterface(Class serviceInterface) {
        if (serviceInterface == null || !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("serviceInterface must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.serviceInterface == null) {
            throw new IllegalArgumentException("serviceInterface is required");
        }
        this.serviceProxy = ProxyFactory.getProxy((Class)this.serviceInterface, (Interceptor)this);
    }

    public Object getObject() {
        return this.serviceProxy;
    }

    public Class getObjectType() {
        return this.serviceProxy != null ? this.serviceProxy.getClass() : this.serviceInterface;
    }

    public boolean isSingleton() {
        return true;
    }
}

